/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;

public class UTF8Utility {
    static final short KLeft1BitMask = 128;
    static final short KLeft2BitsMask = 192;
    static final short KLeft3BitsMask = 224;
    static final short KLeft4BitsMask = 240;
    static final short KLeft5BitsMask = 248;
    static final short KLeft6BitsMask = 252;
    static final short KLeft7BitsMask = 254;
    static final short K2BytesLeadByte = 192;
    static final short K3BytesLeadByte = 224;
    static final short K4BytesLeadByte = 240;
    static final short K5BytesLeadByte = 248;
    static final short K6BytesLeadByte = 252;
    static final short kTrailByte = 128;

    private static boolean utf8_1Bytes(byte c) {
        return (c & 0x80) == 0;
    }

    private static boolean utf8_2Bytes(byte c) {
        return (c & 0xE0) == 192;
    }

    private static boolean utf8_3Bytes(byte c) {
        return (c & 0xF0) == 224;
    }

    private static boolean utf8_4Bytes(byte c) {
        return (c & 0xF8) == 240;
    }

    private static boolean utf8_5Bytes(byte c) {
        return (c & 0xFC) == 248;
    }

    private static boolean utf8_6Bytes(byte c) {
        return (c & 0xFE) == 252;
    }

    private static boolean utf8_validateTrailByte(byte c) {
        return (c & 0xC0) == 128;
    }

    public static boolean isUTF8(byte[] utf8) {
        if (utf8 == null) {
            return false;
        }
        return UTF8Utility.isUTF8(utf8, utf8.length);
    }

    public static boolean isUTF8(byte[] utf8, int length) {
        int clen = 0;
        if (utf8 == null) {
            return false;
        }
        int len = length;
        if (len > utf8.length) {
            len = utf8.length;
        }
        for (int i = 0; i < len; i += clen) {
            if (UTF8Utility.utf8_1Bytes(utf8[i])) {
                clen = 1;
            } else if (UTF8Utility.utf8_2Bytes(utf8[i])) {
                clen = 2;
                if (i + clen > len) {
                    return false;
                }
                if ((utf8[i] & 0x1E) == 0) {
                    return false;
                }
            } else if (UTF8Utility.utf8_3Bytes(utf8[i])) {
                clen = 3;
                if (i + clen > len) {
                    return false;
                }
                if (237 == utf8[i] && 160 == (utf8[i + 1] & 0xA0)) {
                    return false;
                }
                if (0 == (utf8[i] & 0xF) && 0 == (utf8[i + 1] & 0x20)) {
                    return false;
                }
            } else if (UTF8Utility.utf8_4Bytes(utf8[i])) {
                clen = 4;
                if (i + clen > len) {
                    return false;
                }
                if (0 == (utf8[i] & 7) && 0 == (utf8[i + 1] & 0x30)) {
                    return false;
                }
            } else if (UTF8Utility.utf8_5Bytes(utf8[i])) {
                clen = 5;
                if (i + clen > len) {
                    return false;
                }
                if (0 == (utf8[i] & 3) && 0 == (utf8[i + 1] & 0x38)) {
                    return false;
                }
            } else if (UTF8Utility.utf8_6Bytes(utf8[i])) {
                clen = 6;
                if (i + clen > len) {
                    return false;
                }
                if (0 == (utf8[i] & 1) && 0 == (utf8[i + 1] & 0x3E)) {
                    return false;
                }
            } else {
                return false;
            }
            for (int j = 1; j < clen; ++j) {
                if (UTF8Utility.utf8_validateTrailByte(utf8[i + j])) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        String input = "/home/sagarwal/I18N/text";
        try {
            int numRead;
            FileInputStream in = new FileInputStream(new File(input));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int len = 80;
            byte[] buf = new byte[len];
            while ((numRead = in.read(buf)) > 0) {
                out.write(buf, 0, numRead);
            }
            byte[] utf8 = out.toByteArray();
            if (UTF8Utility.isUTF8(utf8)) {
                System.out.println("file " + input + " is utf8");
            } else {
                System.out.println("file " + input + " is not utf8");
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception " + e);
        }
    }
}

