/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.util.Config;
import com.wm.util.JournalLogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;

public class SocketProvider {
    public static final int NETSVC0013 = 13;
    static Method gGetCreds;
    static Method gStartHandshake;
    static boolean gProviderAvail;
    static final String CERT_PROVIDER_PROP = "watt.security.certProvider";
    static final String SECURESOCKET_PROVIDER_PROP = "watt.net.socketProvider";
    static final String SECURESERVERSOCKET_PROVIDER_PROP = "watt.net.serverSocketProvider";
    static final String IAIK = "com.wm.ext.iaik";
    static final String IAIK_CERT_PROVIDER = "com.wm.ext.iaik.IAIKCert";
    static final String IAIK_SECURESOCKET_PROVIDER = "com.wm.ext.iaik.IaikSecureSocket";
    static final String IAIK_SECURESERVERSOCKET_PROVIDER = "com.wm.ext.iaik.IaikSecureServerSocket";
    static final String PHAOS = "com.wm.ext.phaos";
    static final String PHAOS_CERT_PROVIDER = "com.wm.ext.phaos.PhaosCert";
    static final String PHAOS_SECURESOCKET_PROVIDER = "com.wm.ext.phaos.PhaosSecureSocket";
    static final String PHAOS_SECURESERVERSOCKET_PROVIDER = "com.wm.ext.phaos.PhaosSecureServerSocket";
    public static final String DEF_PROVIDER = "com.wm.ext.iaik.IaikSecureSocket";

    public static void init() {
        String providerName = Config.getProperty("com.wm.ext.iaik.IaikSecureSocket", SECURESOCKET_PROVIDER_PROP);
        if (providerName.indexOf(IAIK) != -1) {
            Config.setProperty(CERT_PROVIDER_PROP, IAIK_CERT_PROVIDER);
            Config.setProperty(SECURESERVERSOCKET_PROVIDER_PROP, IAIK_SECURESERVERSOCKET_PROVIDER);
        } else if (providerName.indexOf(PHAOS) != -1) {
            Config.setProperty(CERT_PROVIDER_PROP, PHAOS_CERT_PROVIDER);
            Config.setProperty(SECURESERVERSOCKET_PROVIDER_PROP, PHAOS_SECURESERVERSOCKET_PROVIDER);
        }
        try {
            Class<?> provider = Class.forName(providerName);
            Class[] paramTypes = new Class[]{Class.forName("java.net.Socket")};
            gGetCreds = provider.getMethod("getClientCredentials", paramTypes);
            gStartHandshake = provider.getMethod("startHandshake", paramTypes);
            gProviderAvail = true;
        }
        catch (ClassNotFoundException e) {
            JournalLogger.logCritical(13, 64, e);
        }
        catch (Exception e) {
            JournalLogger.logCritical(13, 64, e);
        }
    }

    private SocketProvider() {
    }

    public static boolean isProviderPresent() {
        return gProviderAvail;
    }

    public static Object[] getClientCredentials(Socket sock) {
        try {
            Object[] params = new Object[]{sock};
            return (Object[])gGetCreds.invoke(null, params);
        }
        catch (Exception e) {
            JournalLogger.logCritical(13, 64, e);
            return null;
        }
    }

    public static void startHandshake(Socket sock) throws IOException {
        try {
            Object[] params = new Object[]{sock};
            gStartHandshake.invoke(null, params);
        }
        catch (IllegalAccessException e) {
            JournalLogger.logCritical(13, 64, e);
        }
        catch (InvocationTargetException e) {
            JournalLogger.logCritical(13, 64, e.getTargetException());
        }
    }

    static {
        gProviderAvail = false;
        SocketProvider.init();
    }
}

