/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.HttpAuthManager;
import com.wm.net.HttpHeader;
import com.wm.net.HttpInputStream;
import com.wm.net.HttpOutputStream;
import com.wm.net.HttpURLConnection;
import com.wm.net.Net504Exception;
import com.wm.net.NetException;
import com.wm.net.URLStreamHandlerFactory;
import com.wm.net.resources.NetExceptionBundle;
import com.wm.net.socket.ISocketFactory;
import com.wm.net.socket.SocketFactories;
import com.wm.util.Base64;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import com.wm.util.Strings;
import com.wm.util.Values;
import iaik.security.ssl.SSLSocket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;

public class NetURLConnection
extends HttpURLConnection {
    public static final int NETSVC0012 = 12;
    public static final int NETSVC0013 = 13;
    public static final int NETSVC0014 = 14;
    public static final int NETSVC0015 = 15;
    public static final int NETSVC0016 = 16;
    public static final int NETSVC0017 = 17;
    public static final int NETSVC0018 = 18;
    public static final int NETSVC0020 = 20;
    String gProxyId = "";

    public NetURLConnection(URL u, Values context) {
        super(u, context);
        this.initialize(u);
    }

    public NetURLConnection(URL u) {
        super(u);
        this.initialize(u);
    }

    private void initialize(URL u) {
        this.setPersonality(u.getProtocol());
    }

    public static void init() {
        if (Config.getProperty("false", "watt.net.useURLFactory").equalsIgnoreCase("true")) {
            try {
                URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory());
            }
            catch (Throwable throwable) {}
        } else {
            Config.setProtocolPath();
        }
    }

    public void setPersonality(String protocol) {
        this.usingProxy = false;
        if (protocol.equalsIgnoreCase("https")) {
            this.defaultPort = 443;
            if (this.gSecureProxyHost != null && this.gSecureProxyHost.length() > 0) {
                this.usingProxy = NetURLConnection.isProxyAllowed(this.url.getHost());
            }
            if (this.gSecureProxyUser != null && this.gSecureProxyUser.length() > 0) {
                this.requestHeader.addField("Proxy-Authorization", Strings.cat("Basic ", Base64.encodeUTF8(Strings.cat(this.gSecureProxyUser, ":", this.gSecureProxyPass))));
            }
        } else {
            this.defaultPort = 80;
            if (this.proxyHost != null && this.proxyHost.length() > 0) {
                this.usingProxy = NetURLConnection.isProxyAllowed(this.url.getHost());
            }
            if (this.proxyUser != null && this.proxyUser.length() > 0) {
                this.requestHeader.addField("Proxy-Authorization", Strings.cat("Basic ", Base64.encodeUTF8(Strings.cat(this.proxyUser, ":", this.proxyPass))));
            }
        }
    }

    public synchronized void connect() throws IOException {
        if (80 == this.defaultPort) {
            this.httpConnect();
        } else {
            this.httpsConnect();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized InputStream getInputStream() throws IOException {
        int retry = 0;
        String redir = null;
        boolean handshakeInProgress = false;
        try {
            while (true) {
                void var5_14;
                String newAuth;
                String s3;
                block48: {
                    void var5_9;
                    String s2;
                    block45: {
                        void var5_22;
                        int code;
                        block44: {
                            block46: {
                                block47: {
                                    block42: {
                                        block43: {
                                            if (!this.connected) {
                                                this.connect();
                                            }
                                            if (!this.outputOpen) {
                                                int method = HttpHeader.getMethodValue(this.getRequestMethod());
                                                if (method == 2) {
                                                    this.genQuery(0);
                                                } else {
                                                    this.genQuery(method);
                                                }
                                                this.outputStream.setHeader(this.requestHeader);
                                                this.requestHeader.write(this.outputStream);
                                            } else {
                                                this.outputStream.setHeader(this.requestHeader);
                                                this.postOutput.writeToStream(this.outputStream);
                                            }
                                            this.outputStream.flush();
                                            this.responseHeader = new HttpHeader(2, this.url);
                                            this.inputStream.setHeader(this.responseHeader);
                                            this.responseHeader.read(this.inputStream);
                                            code = this.getResponseCode();
                                            if (code == 100) {
                                                this.responseHeader = new HttpHeader(2, this.url);
                                                this.inputStream.setHeader(this.responseHeader);
                                                this.responseHeader.read(this.inputStream);
                                                code = this.getResponseCode();
                                            }
                                            if (code != 401) break block42;
                                            if (NetURLConnection.getAuthListener() == null) break block43;
                                            String string = NetURLConnection.getAuthListener().getHttpAuth(this.responseHeader.getFieldValue("WWW-Authenticate"));
                                            if (string == null) {
                                                throw new NetException(NetExceptionBundle.class, NetExceptionBundle.AUTH_REQUIRED, "", this.getResponseMessage());
                                            }
                                            this.requestHeader.setField("Authorization", string);
                                            break block44;
                                        }
                                        Object var5_8 = null;
                                        s2 = null;
                                        break block45;
                                    }
                                    if (code != 407) break block46;
                                    if (NetURLConnection.getAuthListener() == null) break block47;
                                    String string = NetURLConnection.getAuthListener().getHttpAuth(this.responseHeader.getFieldValue("WWW-Authenticate"));
                                    if (string == null) {
                                        IOException ioe = new IOException("Proxy Authorization Required: " + this.getResponseMessage());
                                        JournalLogger.logCritical(9998, 64, ioe);
                                        throw ioe;
                                    }
                                    this.requestHeader.setField("Proxy-Authenticate", string);
                                    break block44;
                                }
                                Object var5_13 = null;
                                s3 = null;
                                break block48;
                            }
                            if (code == 504) {
                                throw new Net504Exception(NetExceptionBundle.class, NetExceptionBundle.SERVER_ERROR, "", this.getResponseMessage());
                            }
                            if (code >= 501 && code < 600) {
                                throw new NetException(NetExceptionBundle.class, NetExceptionBundle.SERVER_ERROR, "", this.getResponseMessage());
                            }
                        }
                        this.updateCookieList(this.cookies, this.responseHeader.getCookies(), this.getURL().getHost());
                        this.baseUrl = this.responseHeader.getBaseURL();
                        if (code == 204) {
                            ByteArrayInputStream byteArrayInputStream;
                            this.disconnect();
                            ByteArrayInputStream s3 = byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                            return s3;
                        }
                        redir = code >= 300 && code < 400 ? this.responseHeader.getFieldValue("location") : null;
                        if (null != redir) {
                            JournalLogger.logDebugPlus(1, 13, 64, redir);
                            if (++retry > maxRedirects) {
                                throw new NetException(NetExceptionBundle.class, NetExceptionBundle.MAX_REDIRECTS, "", String.valueOf(maxRedirects));
                            }
                            this.url = new URL(this.url, redir);
                        } else if (code != 401) {
                            HttpInputStream httpInputStream = this.inputStream;
                            return httpInputStream;
                        }
                        this.outputOpen = false;
                        this.setPersonality(this.url.getProtocol());
                        this.requestHeader.setRequestUrl(this.url);
                        String string = this.url.getHost();
                        int p = this.url.getPort();
                        if (p > 0) {
                            String string2 = string + ":" + p;
                        }
                        this.requestHeader.setField("Host", (String)var5_22);
                        this.requestHeader.clearField("Cookie");
                        this.requestHeader.clearField("Content-Length");
                        while (this.requestHeader.getRequestType() != 3 && this.inputStream.read() > 0) {
                        }
                        this.disconnect();
                    }
                    for (int i = 0; var5_9 == null && i < this.responseHeader.getNumFields(); ++i) {
                        if (!this.responseHeader.getFieldAttribute(i).equals("WWW-Authenticate")) continue;
                        s2 = this.responseHeader.getFieldValue(i);
                        if (this.authHandler != null && this.authHandler.canProcess(s2)) {
                            String string = s2;
                            continue;
                        }
                        if (!HttpAuthManager.hasAuthHandler(s2)) continue;
                        String string = s2;
                    }
                    if (this.authHandler == null) {
                        this.authHandler = HttpAuthManager.getAuthHandler((String)var5_9);
                    }
                    newAuth = null;
                    if (this.authHandler != null) {
                        newAuth = this.authHandler.getHttpAuth((String)var5_9);
                    }
                    if (this.requestHeader.getFieldValue("Cookie") == null && newAuth == null) {
                        throw new NetException(NetExceptionBundle.class, NetExceptionBundle.AUTH_REQUIRED, "", this.getResponseMessage());
                    }
                    if (newAuth != null) {
                        this.requestHeader.setField("Authorization", newAuth);
                    } else {
                        this.requestHeader.clearField("Cookie");
                        this.removeCookie(this.getURL());
                    }
                    if (this.authHandler != null && this.authHandler.needKeepAlive()) {
                        this.requestHeader.setField("Connection", "Keep-Alive");
                    }
                    while (this.requestHeader.getRequestType() != 3 && this.inputStream.read() > 0) {
                    }
                    if (handshakeInProgress) continue;
                    handshakeInProgress = true;
                    this.disconnect();
                    continue;
                }
                for (int i = 0; var5_14 == null && i < this.responseHeader.getNumFields(); ++i) {
                    if (!this.responseHeader.getFieldAttribute(i).equals("Proxy-Authenticate")) continue;
                    s3 = this.responseHeader.getFieldValue(i);
                    if (this.authHandler != null && this.authHandler.canProcess(s3)) {
                        String string = s3;
                        continue;
                    }
                    if (HttpAuthManager.getAuthHandler(s3) == null) continue;
                    String string = s3;
                }
                if (this.authHandler == null) {
                    this.authHandler = HttpAuthManager.getAuthHandler((String)var5_14);
                }
                newAuth = null;
                if (this.authHandler != null) {
                    newAuth = this.authHandler.getHttpAuth((String)var5_14);
                }
                if (newAuth == null) {
                    IOException ioe = new IOException("Proxy Authorization Required: " + this.getResponseMessage());
                    JournalLogger.log(9998, 64, ioe);
                    throw ioe;
                }
                if (this.authHandler.needKeepAlive()) {
                    this.requestHeader.setField("Proxy-Connection", "Keep-Alive");
                }
                this.requestHeader.setField("Proxy-Authorization", newAuth);
                while (this.requestHeader.getRequestType() != 3 && this.inputStream.read() > 0) {
                }
                if (handshakeInProgress) continue;
                handshakeInProgress = true;
                this.disconnect();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (this.authHandler != null) {
                this.authHandler.tearDown();
            }
        }
    }

    public synchronized void httpConnect() throws IOException {
        if (!this.connected) {
            if (this.proxyHost != null && this.proxyHost.length() > 0 && this.usingProxy) {
                int port;
                if (JournalLogger.isLogEnabledDebugPlus(2, 14, 64)) {
                    JournalLogger.logDebugPlus(2, 14, 64, this.url.toString(), this.proxyHost + ":" + this.proxyPort);
                }
                if (this.proxyPort != null) {
                    try {
                        port = Integer.valueOf(this.proxyPort);
                    }
                    catch (NumberFormatException e) {
                        port = this.defaultPort;
                    }
                } else {
                    port = this.defaultPort;
                }
                String host = this.proxyHost;
                this.socket = new Socket(host, port);
                this.socket.setTcpNoDelay(true);
                this.socket.setSoTimeout(this.gTimeout);
            } else {
                if (JournalLogger.isLogEnabledDebugPlus(2, 15, 64)) {
                    JournalLogger.logDebugPlus(2, 15, 64, this.url.toString());
                }
                String host = this.url.getHost();
                int port = this.url.getPort();
                if (port < 0) {
                    port = this.defaultPort;
                }
                this.socket = new Socket(host, port);
                this.socket.setTcpNoDelay(true);
                this.socket.setSoTimeout(this.gTimeout);
            }
            this.inputStream = new HttpInputStream(this.socket.getInputStream(), this.responseHeader);
            this.outputStream = new HttpOutputStream(this.socket.getOutputStream(), this.requestHeader);
            this.connected = true;
        }
    }

    private void getSocket(String host, int port, String protocol, Values context, boolean handshake) throws IOException {
        this.host = host;
        this.port = port;
        String key = host + ':' + protocol;
        if (!this.socketPoolMgr.poolExists(key, port)) {
            ISocketFactory socketFactory = SocketFactories.getFactory(protocol, context);
            socketFactory.setAutoHandshake(handshake);
            this.socketPoolMgr.addPool(key, port, socketFactory);
            this.socketPoolMgr.setPoolCacheSize(key, port, this.maxKeepAliveConns);
        }
        this.gTimeout = this.gTimeout < 0 ? 0 : this.gTimeout;
        this.socketPoolMgr.setKeepAliveTimeout(key, port, this.gTimeout);
        this.socket = this.socketPoolMgr.get(key, port);
    }

    public synchronized void httpsConnect() throws IOException {
        if (!this.connected) {
            this.gProxyId = "<none>";
            if (this.gSecureProxyHost != null && this.gSecureProxyHost.length() > 0 & this.usingProxy) {
                this.gProxyId = this.gSecureProxyPort != null && this.gSecureProxyPort.length() > 0 ? Strings.cat(this.gSecureProxyHost, ":", this.gSecureProxyPort) : Strings.cat(this.gSecureProxyHost, ":", Integer.toString(this.defaultPort));
            }
            this.trySSLConnect();
        }
    }

    public void trySSLConnect() throws IOException {
        Values context = new Values();
        JournalLogger.logDebugPlus(2, 14, 64, this.url.toString(), this.gProxyId);
        if (this.gSecureProxyHost != null && this.gSecureProxyHost.length() > 0 && this.usingProxy) {
            int port = this.gSecureProxyPort != null && this.gSecureProxyPort.length() > 0 ? Integer.valueOf(this.gSecureProxyPort) : this.defaultPort;
            ISocketFactory socketFactory = SocketFactories.getFactory("https", context);
            socketFactory.setAutoHandshake(false);
            this.socket = socketFactory.createSocket(this.gSecureProxyHost, port);
            this.socket.setSoTimeout(this.gTimeout);
            this.responseHeader = new HttpHeader(2, this.url);
            this.inputStream = new HttpInputStream(this.socket.getInputStream(), this.responseHeader);
            this.outputStream = new HttpOutputStream(this.socket.getOutputStream(), this.requestHeader);
            int targetPort = this.url.getPort();
            if (targetPort < 0) {
                targetPort = this.defaultPort;
            }
            this.sendConnectRequest(targetPort);
            ((SSLSocket)this.socket).setAutoHandshake(true);
            ((SSLSocket)this.socket).startHandshake();
        } else {
            int port = this.url.getPort();
            if (port < 0) {
                port = this.defaultPort;
            }
            ISocketFactory socketFactory = SocketFactories.getFactory("https", context);
            socketFactory.setAutoHandshake(true);
            this.socket = socketFactory.createSocket(this.url.getHost(), port);
            this.socket.setSoTimeout(this.gTimeout);
        }
        this.inputStream = new HttpInputStream(this.socket.getInputStream(), this.responseHeader);
        this.outputStream = new HttpOutputStream(this.socket.getOutputStream(), this.requestHeader);
        this.connected = true;
    }

    public int sendConnectRequest(int targetPort) throws IOException {
        if (!this.outputOpen) {
            HttpHeader orgHdr = this.requestHeader;
            HttpHeader hdr = new HttpHeader(1, this.getURL());
            hdr.setField("User-Agent", this.requestHeader.getFieldValue("User-Agent"));
            hdr.setField("Accept", this.requestHeader.getFieldValue("Accept"));
            hdr.setField("Host", this.requestHeader.getFieldValue("Host"));
            if (this.requestHeader.getFieldValue("Proxy-Authorization") != null && this.requestHeader.getFieldValue("Proxy-Authorization").length() > 0) {
                hdr.setField("Proxy-Authorization", this.requestHeader.getFieldValue("Proxy-Authorization"));
            }
            if (this.requestHeader.getFieldValue("Authorization") != null && this.requestHeader.getFieldValue("Authorization").length() > 0) {
                hdr.setField("Authorization", this.requestHeader.getFieldValue("Authorization"));
            }
            hdr.setField("Content-type", this.requestHeader.getFieldValue("Content-type"));
            this.requestHeader = hdr;
            this.requestHeader.setConnectPort(targetPort);
            this.requestHeader.setRequestType(4);
            this.requestHeader.setUsingProxy(this.usingProxy);
            this.outputStream.setHeader(this.requestHeader);
            this.requestHeader.write(this.outputStream);
            this.requestHeader = orgHdr;
        } else {
            this.postOutput.writeToStream(this.outputStream);
        }
        this.outputStream.flush();
        HttpHeader rsphdr = new HttpHeader(2);
        rsphdr.read(this.inputStream);
        if (JournalLogger.isLogEnabledDebugPlus(5, 17, 64)) {
            JournalLogger.logDebugPlus(5, 17, 64, rsphdr.getResponseMessage());
        }
        if (rsphdr.getResponseCode() == 200) {
            rsphdr = null;
            return 0;
        }
        String error = rsphdr.getResponseCode() + " " + rsphdr.getResponseMessage();
        rsphdr = null;
        throw new IOException(error);
    }

    public boolean usingProxy() {
        return this.usingProxy;
    }
}

