/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import java.util.Properties;

public class NetConfig {
    static final String BUFFER_SIZE_PROPERTY = "watt.net.defaultBufferSize";
    static final int DEFAULT_BUFFER_SIZE = 8096;
    private static int BufferSize;

    public static void initialize() {
        Properties props = System.getProperties();
        String buffer = (String)props.get(BUFFER_SIZE_PROPERTY);
        if (buffer != null && buffer.length() > 0) {
            try {
                BufferSize = Integer.parseInt(buffer);
            }
            catch (NumberFormatException nfe) {
                BufferSize = 8096;
            }
        } else {
            BufferSize = 8096;
        }
    }

    public static void reset() {
        NetConfig.initialize();
    }

    public static int getDefaultBufferSize() {
        return BufferSize;
    }

    public static void setDefaultBufferSize(int newSize) {
        BufferSize = newSize;
    }

    static {
        NetConfig.initialize();
    }
}

