/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.AuthenticationHandler;
import com.wm.net.HttpAuthListener;
import com.wm.net.HttpCookie;
import com.wm.net.HttpHeader;
import com.wm.net.HttpInputStream;
import com.wm.net.HttpOutputStream;
import com.wm.net.HttpPostBufferStream;
import com.wm.net.NetException;
import com.wm.net.NetURLConnection;
import com.wm.net.resources.NetExceptionBundle;
import com.wm.net.socket.pool.SocketPoolManager;
import com.wm.util.Base64;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import com.wm.util.ProxySettings;
import com.wm.util.StringMatcher;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.security.WmSecureString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class HttpURLConnection
extends java.net.HttpURLConnection {
    public static final int NETSVC0011 = 11;
    public static final int NETSVC0019 = 19;
    public static final int DEF_HTTP_PORT = 80;
    public static final int DEF_HTTPS_PORT = 443;
    protected static int maxRedirects = 5;
    protected int gTimeout = 0;
    protected int maxKeepAliveConns = 5;
    protected Vector cookies = null;
    protected boolean outputOpen = false;
    protected String baseUrl = null;
    protected HttpHeader requestHeader;
    protected HttpHeader responseHeader;
    protected int defaultPort;
    protected String host;
    protected int port;
    protected HttpPostBufferStream postOutput;
    protected HttpInputStream inputStream;
    protected HttpOutputStream outputStream;
    protected Socket socket;
    protected SocketPoolManager socketPoolMgr;
    protected String proxyHost;
    protected String proxyPort;
    protected String proxyUser;
    protected String proxyPass;
    protected String gSecureProxyHost;
    protected String gSecureProxyPort;
    protected String gSecureProxyUser;
    protected String gSecureProxyPass;
    protected boolean usingProxy = false;
    protected boolean proxyInfoGiven = false;
    private static HttpAuthListener authTarget = null;
    protected AuthenticationHandler authHandler = null;
    private static String lastSkipList;
    private static Hashtable noProxyHosts;
    private static Hashtable noProxyWildcardHosts;

    public static final HttpAuthListener getAuthListener() {
        return authTarget;
    }

    public static final void setAuthListener(HttpAuthListener newTarget) {
        authTarget = newTarget;
    }

    static final void setupProxyRules() {
        String skipList = Config.getProperty("localhost", "watt.net.proxySkipList");
        if (skipList == lastSkipList) {
            return;
        }
        lastSkipList = skipList;
        noProxyHosts.clear();
        noProxyWildcardHosts.clear();
        StringTokenizer st = new StringTokenizer(skipList, ", ");
        while (st.hasMoreTokens()) {
            HttpURLConnection.setUseProxy(st.nextToken(), false);
        }
    }

    public static final boolean isProxyAllowed(String aHost) {
        if (aHost == null || aHost.length() == 0) {
            return true;
        }
        String host = aHost.toLowerCase();
        HttpURLConnection.setupProxyRules();
        Enumeration e = noProxyWildcardHosts.elements();
        while (e.hasMoreElements()) {
            if (!new StringMatcher((String)e.nextElement()).match(host)) continue;
            return false;
        }
        return noProxyHosts.get(host) == null;
    }

    public static final void setUseProxy(String aHost, boolean use) {
        if (aHost == null || aHost.length() == 0) {
            return;
        }
        String host = aHost.toLowerCase();
        if (use) {
            noProxyHosts.remove(host);
            noProxyWildcardHosts.remove(host);
        } else if (host.indexOf(42) >= 0) {
            noProxyWildcardHosts.put(host, host);
        } else {
            noProxyHosts.put(host, host);
        }
    }

    public static final HttpURLConnection getHttpURLConnection(URL u, Values context) {
        return new NetURLConnection(u, context);
    }

    public static final HttpURLConnection getHttpURLConnection(URL u) {
        return new NetURLConnection(u);
    }

    protected HttpURLConnection(URL u, Values context) {
        super(u);
        this.init(u, context);
    }

    protected HttpURLConnection(URL u) {
        super(u);
        this.init(u, new Values());
    }

    private void init(URL u, Values context) {
        String t;
        WmSecureString sec;
        this.connected = false;
        this.socketPoolMgr = SocketPoolManager.getCurrent();
        String protocol = u.getProtocol();
        this.proxyHost = Config.getProperty("watt.net.proxyHost");
        if (this.proxyHost != null) {
            this.proxyHost = this.proxyHost.trim();
        }
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            this.proxyPort = Config.getProperty("watt.net.proxyPort");
            this.proxyUser = Config.getProperty("watt.net.proxyUser");
            this.proxyPass = Config.getProperty("watt.net.proxyPass");
            if (this.proxyPort != null) {
                this.proxyPort = this.proxyPort.trim();
            }
            if (this.proxyUser != null) {
                this.proxyUser = this.proxyUser.trim();
                if (this.proxyPass == null && (sec = ProxySettings.getHttpProxyPass()) != null) {
                    this.proxyPass = sec.toString();
                }
            }
            if (this.proxyPass != null) {
                this.proxyPass = this.proxyPass.trim();
            }
        }
        this.gSecureProxyHost = Config.getProperty("watt.net.secureProxyHost");
        if (this.gSecureProxyHost != null) {
            this.gSecureProxyHost = this.gSecureProxyHost.trim();
        }
        if (this.gSecureProxyHost != null && this.gSecureProxyHost.length() > 0) {
            this.gSecureProxyPort = Config.getProperty("watt.net.secureProxyPort");
            this.gSecureProxyUser = Config.getProperty("watt.net.secureProxyUser");
            this.gSecureProxyPass = Config.getProperty("watt.net.secureProxyPass");
            if (this.gSecureProxyPort != null) {
                this.gSecureProxyPort = this.gSecureProxyPort.trim();
            }
            if (this.gSecureProxyUser != null) {
                this.gSecureProxyUser = this.gSecureProxyUser.trim();
                if (this.gSecureProxyPass == null && (sec = ProxySettings.getSecureHttpProxyPass()) != null) {
                    this.gSecureProxyPass = sec.toString();
                }
            }
            if (this.gSecureProxyPass != null) {
                this.gSecureProxyPass = this.gSecureProxyPass.trim();
            }
        }
        try {
            String r = Config.getProperty("watt.net.maxRedirects");
            if (r != null) {
                maxRedirects = Integer.valueOf(r);
            }
        }
        catch (NumberFormatException e) {
            JournalLogger.logWarning(11, 64, e);
        }
        try {
            int timeout = context.getInt("timeout", -1);
            if (timeout < 0) {
                t = Config.getProperty("watt.net.timeout");
                if (t != null) {
                    this.gTimeout = Integer.valueOf(t) * 1000;
                }
            } else {
                this.gTimeout = timeout;
            }
        }
        catch (NumberFormatException e) {
            JournalLogger.logWarning(11, 64, e);
        }
        try {
            int kpconns = context.getInt("keepalive", -1);
            if (kpconns < 0) {
                t = Config.getProperty("watt.net.maxClientKeepaliveConns");
                if (t != null) {
                    this.maxKeepAliveConns = Integer.parseInt(t);
                }
            } else {
                this.maxKeepAliveConns = kpconns;
            }
        }
        catch (NumberFormatException e) {
            JournalLogger.logWarning(11, 64, e);
        }
        this.requestHeader = new HttpHeader(1, u);
        String s = Config.getProperty("watt.net.userAgent");
        if (s != null) {
            this.requestHeader.addField("User-Agent", s);
        } else {
            this.requestHeader.addField("User-Agent", "webMethods");
        }
        this.requestHeader.addField("Accept", "image/gif, */*");
        String h = u.getHost();
        int p = u.getPort();
        if (p > 0) {
            h = h + ":" + p;
        }
        this.requestHeader.addField("Host", h);
    }

    public abstract void connect() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public Vector getCookies() {
        return this.responseHeader == null ? null : this.responseHeader.getCookies();
    }

    public void setCookies(Vector cookies) {
        this.cookies = cookies;
    }

    public String getContentType() {
        return this.responseHeader == null ? null : this.responseHeader.getFieldValue("Content-Type");
    }

    public String getContentEncoding() {
        return this.responseHeader == null ? null : this.responseHeader.getFieldValue("Content-Encoding");
    }

    public int getResponseCode() {
        return this.responseHeader == null ? -1 : this.responseHeader.getResponseCode();
    }

    public String getResponseMessage() {
        return this.responseHeader == null ? null : this.responseHeader.getResponseMessage();
    }

    public void setRequestProperty(String attr, String value) {
        this.requestHeader.setField(attr, value);
    }

    public String getHeaderField(String attr) {
        return this.responseHeader == null ? null : this.responseHeader.getFieldValue(attr);
    }

    public void setHttpAuth(String user, String password) {
        if (user != null) {
            this.requestHeader.addField("Authorization", Strings.cat("Basic ", Base64.encode(Strings.cat(user, ":", password))));
        }
    }

    public String getHeaderField(int idx) {
        return this.responseHeader == null ? null : this.responseHeader.getFieldValue(idx);
    }

    public String getHeaderFieldKey(int idx) {
        return this.responseHeader == null ? null : this.responseHeader.getFieldAttribute(idx);
    }

    public HttpHeader getResponseHeader() {
        return this.responseHeader;
    }

    public HttpHeader getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(HttpHeader requestHeader) {
        this.requestHeader = requestHeader;
    }

    public String getBaseURL() {
        return this.baseUrl;
    }

    void genQuery(int type) {
        String cookieOut;
        this.requestHeader.setRequestType(type);
        this.requestHeader.setUsingProxy(this.usingProxy);
        if (this.cookies != null && (cookieOut = HttpURLConnection.buildCookieMatch(this.cookies, this.getURL())) != null) {
            JournalLogger.logDebugPlus(3, 19, 64, cookieOut);
            this.setRequestProperty("Cookie", cookieOut);
        }
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OutputStream getOutputStream(InputStream is) throws IOException {
        if (this.connected) {
            throw new NetException(NetExceptionBundle.class, NetExceptionBundle.CANNOT_WRITE, "");
        }
        if (this.getRequestMethod().equals(HttpHeader.reqStrType[2])) {
            this.genQuery(2);
        } else if (this.getRequestMethod().equals(HttpHeader.reqStrType[1])) {
            this.genQuery(1);
        } else {
            this.genQuery(2);
        }
        try {
            this.postOutput = new HttpPostBufferStream(this.requestHeader, is);
            this.connect();
            this.outputOpen = true;
        }
        finally {
            if (!this.connected) {
                this.postOutput = null;
                this.outputOpen = false;
            }
        }
        return this.postOutput;
    }

    public void setDoOutput(boolean b) {
        super.setDoOutput(b);
    }

    public synchronized void disconnect() {
        if (this.connected) {
            if (this.inputStream != null) {
                try {
                    this.inputStream.disconnect();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.connected = false;
    }

    public void removeCookie(URL url) {
        if (this.cookies == null) {
            return;
        }
        for (int j = 0; j < this.cookies.size(); ++j) {
            HttpCookie next = (HttpCookie)this.cookies.elementAt(j);
            if (!next.match(url)) continue;
            this.cookies.removeElementAt(j);
        }
    }

    protected void updateCookieList(Vector cookieList, Vector newCookies, String host) {
        HttpCookie toMatch = null;
        if (newCookies == null || cookieList == null) {
            return;
        }
        for (int i = 0; i < newCookies.size(); ++i) {
            HttpCookie next = (HttpCookie)newCookies.elementAt(i);
            if (next.domain == null) {
                next.domain = host;
            }
            int find = -1;
            for (int j = 0; j < cookieList.size(); ++j) {
                toMatch = (HttpCookie)cookieList.elementAt(j);
                if (!toMatch.match(next)) continue;
                find = j;
                break;
            }
            if (find == -1) {
                cookieList.addElement(next);
                continue;
            }
            if (toMatch.updateFrom(next)) continue;
            cookieList.removeElement(toMatch);
        }
    }

    static String buildCookieMatch(Vector cookies, URL url) {
        StringBuffer sb = new StringBuffer();
        int numMatch = 0;
        for (int j = 0; j < cookies.size(); ++j) {
            HttpCookie next = (HttpCookie)cookies.elementAt(j);
            if (next.version != null && sb.length() == 0) {
                sb.append("$Version=\"1\"");
            }
            if (!next.match(url)) continue;
            if (sb.length() != 0) {
                sb.append("; ");
            }
            sb.append(next.cookieString());
            ++numMatch;
        }
        return numMatch == 0 ? null : sb.toString();
    }

    public void setRequestMethod(String mtoken) throws ProtocolException {
        super.setRequestMethod(mtoken);
        int method = HttpHeader.getMethodValue(mtoken);
        switch (method) {
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
    }

    static {
        noProxyHosts = new Hashtable();
        noProxyWildcardHosts = new Hashtable();
        lastSkipList = null;
        noProxyHosts.put("localhost", "localhost");
    }
}

