/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.EncodeURL;
import com.wm.util.StringMatcher;
import java.net.URL;

public class HttpRedir {
    StringMatcher matcher;
    String matchPrefix;
    String mappedPrefix;
    boolean usesWildcard;
    String protocol;
    String host;
    String port;
    String virtualPath;
    String physicalPath;
    String pathInfo;
    String pathTranslated;
    String queryString;

    public HttpRedir(String url, String mappedPrefix) {
        int end;
        this.mappedPrefix = mappedPrefix;
        if (url.indexOf("http://") < 0) {
            url = "http://" + url;
        }
        this.matcher = new StringMatcher(url);
        int start = url.indexOf("/", 7);
        if (start < 0) {
            start = 7;
        }
        if ((end = url.indexOf("*")) < 0) {
            this.usesWildcard = false;
            this.matchPrefix = url.substring(start);
        } else {
            this.usesWildcard = true;
            end = url.lastIndexOf("/") + 1;
            this.matchPrefix = url.substring(start, end);
        }
    }

    public boolean match(URL url) {
        if (!this.matcher.match(url.toString())) {
            return false;
        }
        this.protocol = url.getProtocol();
        this.host = url.getHost();
        int tmpPort = url.getPort();
        this.port = tmpPort == -1 ? "80" : Integer.toString(tmpPort);
        String filePart = url.getFile();
        int qpos = filePart.indexOf("?");
        if (qpos < 0) {
            this.virtualPath = filePart;
            this.queryString = "";
        } else {
            this.virtualPath = filePart.substring(0, qpos);
            this.queryString = filePart.substring(qpos + 1);
        }
        if (this.usesWildcard) {
            qpos = this.virtualPath.indexOf("/", this.matchPrefix.length());
            if (qpos >= 0) {
                this.pathInfo = this.virtualPath.substring(qpos);
                this.virtualPath = this.virtualPath.substring(0, qpos);
                qpos = this.mappedPrefix.lastIndexOf("/");
                String root = qpos < 0 ? this.mappedPrefix : this.mappedPrefix.substring(0, qpos);
                this.pathInfo = EncodeURL.decode(this.pathInfo);
                this.pathTranslated = root + this.pathInfo;
            } else {
                this.pathInfo = "";
                this.pathTranslated = "";
            }
            String fname = this.virtualPath.substring(this.matchPrefix.length());
            this.physicalPath = this.mappedPrefix + fname;
        } else {
            this.physicalPath = this.mappedPrefix;
            this.pathInfo = "";
            this.pathTranslated = "";
        }
        return true;
    }
}

