/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.HttpHeader;
import com.wm.net.HttpOutputStream;
import com.wm.util.ByteOutputBuffer;
import com.wm.util.Streams;
import java.io.IOException;
import java.io.InputStream;

public class HttpPostBufferStream
extends ByteOutputBuffer {
    HttpHeader header;
    InputStream is = null;
    int clen = -1;

    public HttpPostBufferStream(HttpHeader header2) {
        this.header = header2;
    }

    public HttpPostBufferStream(HttpHeader header2, InputStream is) throws IOException {
        this.header = header2;
        String clenstr = null;
        if (is == null) {
            header2.clearField("Content-Length");
        } else {
            clenstr = this.header.getFieldValue("Content-Length");
        }
        if (is != null && clenstr != null) {
            try {
                Integer iclass = new Integer(clenstr);
                this.clen = iclass;
            }
            catch (Exception e) {
                header2.clearField("Content-Type");
                this.clen = -1;
            }
        }
        if (this.clen >= 0) {
            this.is = is;
        } else if (is != null) {
            Streams.pipe(is, this);
        }
    }

    public void close() throws IOException {
        super.close();
    }

    public void writeToStream(HttpOutputStream target) throws IOException {
        String schunked;
        if (!(this.clen >= 0 || (schunked = this.header.getFieldValue("Transfer-Encoding")) != null && schunked.equals("chunked"))) {
            if (this.header.getFieldValue("Content-Length") == null) {
                this.header.addField("Content-Length", Integer.toString(this.size()));
            } else {
                this.header.setField("Content-Length", Integer.toString(this.size()));
            }
        }
        this.header.write(target);
        if (this.clen < 0) {
            if (this.size() > 0) {
                super.writeToStream(target);
            }
        } else {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = this.is.read(buffer)) != -1) {
                target.write(buffer, 0, bytesRead);
            }
        }
    }
}

