/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.HttpHeader;
import com.wm.net.NetException;
import com.wm.net.resources.NetExceptionBundle;
import com.wm.util.Base64;
import com.wm.util.EncUtil;
import com.wm.util.JournalLogger;
import com.wm.util.Strings;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HttpOutputStream
extends OutputStream {
    protected HttpHeader header;
    protected boolean headerWritten;
    protected OutputStream out;
    protected int chunkSize = HttpHeader.HTTP_CHUNK_SIZE;

    public HttpOutputStream(OutputStream out, HttpHeader header2) {
        this.out = new BufferedOutputStream(out);
        this.header = header2;
        this.headerWritten = false;
    }

    public void close() throws IOException {
        if (this.out instanceof ChunkedOutputStream) {
            this.out.close();
            this.out = ((ChunkedOutputStream)this.out).getStream();
        }
        this.headerWritten = false;
    }

    public void flush() throws IOException {
        this.checkState(true);
        this.out.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkState(true);
        this.out.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.checkState(true);
        this.out.write(b);
    }

    public void write(int b) throws IOException {
        this.checkState(true);
        this.out.write(b);
    }

    public void setHeader(HttpHeader header2) {
        this.header = header2;
        this.headerWritten = false;
    }

    public void writeHeader() throws IOException {
        this.writeHeader(false);
    }

    public void writeHeader(boolean flushHeader) throws IOException {
        String headLine = null;
        if (this.headerWritten) {
            return;
        }
        if (this.header.hdrType == 1 && this.header.url != null) {
            String filename;
            if (this.header.usingProxy) {
                if (this.header.requestType == 4) {
                    headLine = HttpHeader.reqStrType[this.header.requestType] + " " + this.header.url.getHost() + ":" + this.header.connectPort + " " + this.header.httpVer;
                } else if (!this.header.url.getProtocol().equals("http")) {
                    filename = this.header.url.getFile();
                    if (filename == null || filename.length() == 0) {
                        filename = "/";
                    }
                    headLine = HttpHeader.reqStrType[this.header.requestType] + " " + filename + " " + this.header.httpVer;
                } else {
                    String urlString = this.header.url.toString();
                    String filename2 = this.header.url.getFile();
                    if ((filename2 == null || filename2.length() == 0) && this.header.url.getRef() == null) {
                        urlString = urlString.concat("/");
                    }
                    headLine = HttpHeader.reqStrType[this.header.requestType] + " " + urlString + " " + this.header.httpVer;
                }
            } else {
                filename = this.header.url.getFile();
                if (filename == null || filename.length() == 0) {
                    filename = "/";
                }
                headLine = Strings.cat(HttpHeader.reqStrType[this.header.requestType], " ", filename, " ", this.header.httpVer);
            }
        } else {
            headLine = this.header.hdrType == 1 && this.header.getRequestUrl() != null ? Strings.cat(HttpHeader.reqStrType[this.header.requestType], " ", this.header.getRequestUrl(), " ", this.header.httpVer) : (this.header.statMessage == null ? Strings.cat(this.header.httpVer, " ", Integer.toString(this.header.stat)) : Strings.cat(this.header.httpVer, " ", Integer.toString(this.header.stat), " ", this.header.statMessage));
        }
        this.out.write(headLine.getBytes("UTF8"));
        this.out.write(HttpHeader.EOL);
        if (JournalLogger.isLogEnabledDebugPlus(3, 2, 38)) {
            JournalLogger.logDebugPlus(3, 2, 38, "--> " + headLine);
        }
        int aSize = this.header.attrs.size();
        for (int i = 0; i < aSize; ++i) {
            HttpHeader.header cur = (HttpHeader.header)this.header.attrs.elementAt(i);
            Strings.writeLow(this.out, cur.attr);
            this.out.write(58);
            this.out.write(32);
            Strings.writeLow(this.out, cur.val);
            this.out.write(HttpHeader.EOL);
            if (!JournalLogger.isLogEnabledDebugPlus(3, 2, 38)) continue;
            if (cur.attr.equals("Authorization")) {
                JournalLogger.logDebugPlus(3, 2, 38, "--> " + cur.attr + ":" + this.decodeAuthField(cur.val) + ": ****");
                continue;
            }
            JournalLogger.logDebugPlus(3, 2, 38, "--> " + cur.attr + ": " + cur.val);
        }
        this.out.write(HttpHeader.EOL);
        if (flushHeader) {
            this.out.flush();
        }
        this.headerWritten = true;
        if (this.header.isChunked()) {
            this.out = new ChunkedOutputStream(this.out, this.chunkSize);
        }
    }

    private String decodeAuthField(String authVal) {
        String[] val = null;
        String decodedVal = "";
        if (authVal != null && !"".equalsIgnoreCase(authVal)) {
            decodedVal = Base64.decode(authVal.substring(5));
            val = decodedVal.split(":");
            return val[0];
        }
        return authVal;
    }

    public void setChunkSize(int size) {
        this.chunkSize = size;
    }

    private void checkState(boolean mustHaveWrittenHdr) throws IOException {
        if (mustHaveWrittenHdr && !this.headerWritten && !this.canWriteHeader()) {
            throw new NetException(NetExceptionBundle.class, NetExceptionBundle.HTTP_HEADER_NOT_WRITTEN, "");
        }
        if (!mustHaveWrittenHdr && this.headerWritten) {
            throw new NetException(NetExceptionBundle.class, NetExceptionBundle.HTTP_HEADER_WRITTEN, "");
        }
    }

    private boolean canWriteHeader() throws IOException {
        boolean rc = false;
        String chunked = this.header.getFieldValue("Transfer-Encoding");
        String contentLen = this.header.getFieldValue("Content-Length");
        boolean usingProxy = this.header.getUsingProxy();
        if (chunked != null && chunked.equalsIgnoreCase("chunked") || contentLen != null && contentLen.length() > 0 || usingProxy) {
            this.writeHeader();
            rc = true;
        }
        return rc;
    }

    class ChunkedOutputStream
    extends FilterOutputStream {
        private int chunkSize;
        private byte[] chunk;
        private int currentByte;

        public ChunkedOutputStream(OutputStream out, int size) {
            super(out);
            this.chunkSize = 0;
            this.currentByte = 0;
            this.chunkSize = size;
            this.chunk = new byte[this.chunkSize];
            this.currentByte = 0;
        }

        OutputStream getStream() {
            return this.out;
        }

        public void close() throws IOException {
            if (this.currentByte > 0) {
                this.flush();
            }
        }

        public void flush() throws IOException {
            if (this.currentByte > 0) {
                this.writeChunkSegment(this.chunk, this.currentByte);
                this.writeChunkSegment(this.chunk, 0);
                this.currentByte = 0;
            }
            this.out.write(HttpHeader.EOL);
            this.out.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.writeChunk(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.writeChunk(b);
        }

        public void write(int b) throws IOException {
            byte[] buf = new byte[]{(byte)b};
            this.writeChunk(buf);
        }

        private void writeChunk(byte[] b) throws IOException {
            this.writeChunk(b, 0, b.length);
        }

        private void writeChunk(byte[] b, int off, int len) throws IOException {
            int offset = off;
            for (int remaining = len; remaining > 0; --remaining) {
                if (this.currentByte >= this.chunk.length) {
                    this.writeChunkSegment(this.chunk, this.chunk.length);
                    this.currentByte = 0;
                }
                this.chunk[this.currentByte++] = b[offset++];
            }
        }

        private void writeChunkSegment(byte[] data, int len) throws IOException {
            String chunkLen = Integer.toHexString(len) + "; ";
            this.out.write(EncUtil.getBytes(1, chunkLen));
            this.out.write(HttpHeader.EOL);
            if (len > 0) {
                this.out.write(data, 0, len);
                this.out.write(HttpHeader.EOL);
            }
        }
    }
}

