/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.Disconnectable;
import com.wm.net.EncodeURL;
import com.wm.net.HttpCookie;
import com.wm.net.HttpFormatException;
import com.wm.net.HttpHeader;
import com.wm.net.NetException;
import com.wm.net.resources.HttpFormatExceptionBundle;
import com.wm.net.resources.NetExceptionBundle;
import com.wm.util.Base64;
import com.wm.util.EncUtil;
import com.wm.util.JournalLogger;
import com.wm.util.Streams;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;

public class HttpInputStream
extends InputStream
implements Disconnectable {
    private static final String PING_STR = "SAG-RG-PING";
    protected HttpHeader header;
    protected boolean headerRead;
    protected InputStream in;

    public HttpInputStream(InputStream in, HttpHeader header2) {
        this.in = new BufferedInputStream(in);
        this.header = header2;
        this.headerRead = false;
    }

    public int available() throws IOException {
        this.checkState(true);
        return this.in.available();
    }

    public void close() throws IOException {
        this.resetStream();
        this.headerRead = false;
    }

    public void disconnect() throws IOException {
        this.resetStream();
        this.headerRead = false;
        if (this.in instanceof Disconnectable) {
            Disconnectable dc = (Disconnectable)((Object)this.in);
            dc.disconnect();
        } else {
            this.in.close();
        }
    }

    public synchronized void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    public int read() throws IOException {
        this.checkState(true);
        return this.in.read();
    }

    public int read(byte[] b) throws IOException {
        this.checkState(true);
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int len) throws IOException {
        this.checkState(true);
        return this.in.read(b, offset, len);
    }

    public synchronized long skip(long n) throws IOException {
        this.checkState(true);
        return this.skip(n);
    }

    public boolean hasMoreData() throws IOException {
        this.checkState(true);
        if (this.in instanceof BoundedInputStream) {
            return ((BoundedInputStream)this.in).hasMoreData();
        }
        return false;
    }

    public void setHeader(HttpHeader header2) {
        this.header = header2;
        this.headerRead = false;
        this.resetStream();
    }

    public void readHeader() throws IOException {
        this.checkState(false);
        switch (this.header.hdrType) {
            case 2: {
                this.readStatus();
                break;
            }
            case 1: {
                this.readRequest();
            }
        }
        if (!this.header.httpVer.equals("HTTP/0.9")) {
            this.readAttributes();
        }
        if (this.header.hdrType == 1 && this.header.httpVer.equals("HTTP/1.1")) {
            String expect;
            if (this.header.getFieldValue("Host") == null) {
                throw new HttpFormatException(HttpFormatExceptionBundle.class, HttpFormatExceptionBundle.HTTP_BAD_REQUEST, "", 400);
            }
            String TEChunked = this.header.getFieldValue("Transfer-Encoding");
            if (TEChunked != null) {
                if (!TEChunked.equalsIgnoreCase("chunked")) {
                    throw new HttpFormatException(HttpFormatExceptionBundle.class, HttpFormatExceptionBundle.HTTP_NOT_IMPLEMENTED, "", 501);
                }
                this.header.chunked = true;
            }
            if ((expect = this.header.getFieldValue("Expect")) != null) {
                if (!expect.equalsIgnoreCase("100-continue")) {
                    throw new HttpFormatException(HttpFormatExceptionBundle.class, HttpFormatExceptionBundle.HTTP_NOT_EXPECTED, "", 417);
                }
                this.header.expectContinue = true;
            }
        }
        String contentLength = this.header.getFieldValue("Content-Length");
        if (!this.header.chunked && contentLength != null && contentLength.length() > 0) {
            int len = -1;
            try {
                len = Integer.parseInt(contentLength);
                this.header.bounded = true;
                this.in = new BoundedInputStream(this.in, len);
            }
            catch (Exception e) {
                this.header.bounded = false;
            }
        }
        if (this.header.chunked) {
            this.in = new ChunkedInputStream(this.in);
        }
        this.headerRead = true;
    }

    private void readRequest() throws IOException {
        String reqType = null;
        while ((reqType = this.readUntil(32, 10, true)) != null && reqType.equals(PING_STR)) {
            this.header.pool = new char[40];
        }
        if (reqType.length() == 0) {
            throw new NetException(NetExceptionBundle.class, NetExceptionBundle.CONNECTION_CLOSED, "");
        }
        if (reqType.equals("GET")) {
            this.header.requestType = 0;
        } else if (reqType.equals("POST")) {
            this.header.requestType = 2;
        } else if (reqType.equals("PUT")) {
            this.header.requestType = 1;
        } else if (reqType.equals("HEAD")) {
            this.header.requestType = 3;
        } else if (reqType.equals("CONNECT")) {
            this.header.requestType = 4;
        } else if (reqType.equals("OPTIONS")) {
            this.header.requestType = 5;
        } else if (reqType.equals("TRACE")) {
            this.header.requestType = 7;
        } else if (reqType.equals("DELETE")) {
            this.header.requestType = 6;
        } else {
            throw new HttpFormatException(HttpFormatExceptionBundle.class, HttpFormatExceptionBundle.HTTP_BAD_REQUEST, "", 400);
        }
        this.header.requestUrl = this.getUrl();
        if (this.header.requestUrl.length() == 0) {
            if (this.header.requestType == 5) {
                this.header.requestUrl = "*";
            } else {
                throw new HttpFormatException(HttpFormatExceptionBundle.class, HttpFormatExceptionBundle.HTTP_BAD_REQUEST, "", 400);
            }
        }
        if (JournalLogger.isLogEnabledDebugPlus(3, 1, 39)) {
            JournalLogger.logDebugPlus(3, 1, 39, reqType + " " + this.header.requestUrl);
        }
        if (this.header.requestType == 4) {
            try {
                this.header.url = new URL("http://localhost" + this.header.requestUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.header.lastCh == 10) {
            this.header.httpVer = "HTTP/0.9";
            this.header.hasBody = false;
        } else {
            String ver = this.readUntil(10);
            this.header.httpVer = ver != null && ver.endsWith(".1") ? "HTTP/1.1" : "HTTP/1.0";
        }
    }

    private String readUntil(int ch) throws IOException {
        this.header.poolPos = 0;
        while ((this.header.lastCh = this.in.read()) != -1 && this.header.lastCh != ch) {
            if (this.header.lastCh == 13) continue;
            this.bwrite(this.header.lastCh);
        }
        return this.bString();
    }

    private String readUntil(int ch1, int ch2) throws IOException {
        return this.readUntil(ch1, ch2, false);
    }

    private String readUntil(int ch1, int ch2, boolean lenient) throws IOException {
        this.header.poolPos = 0;
        this.header.lastCh = this.in.read();
        if (lenient && this.header.lastCh != -1 && this.header.lastCh <= 32) {
            this.header.lastCh = this.skipNonChars(this.header.lastCh);
        }
        while (this.header.lastCh != -1 && this.header.lastCh != ch1 && this.header.lastCh != ch2) {
            if (this.header.lastCh != 13) {
                this.bwrite(this.header.lastCh);
            }
            this.header.lastCh = this.in.read();
        }
        return this.bString();
    }

    private void bwrite(int ch) {
        this.header.lastCh = ch;
        this.header.pool[this.header.poolPos++] = (char)ch;
        if (this.header.poolPos == this.header.pool.length) {
            char[] npool = new char[this.header.pool.length * 2];
            System.arraycopy(this.header.pool, 0, npool, 0, this.header.pool.length);
            this.header.pool = npool;
        }
    }

    private String bString() {
        return new String(this.header.pool, 0, this.header.poolPos);
    }

    private String parseHeaderName() throws IOException {
        this.header.bsize = 0;
        while (this.header.ch >= 32 && this.header.ch != 58) {
            this.append((char)this.header.ch);
            this.header.ch = this.in.read();
        }
        this.expect(58);
        return new String(this.header.buffer, 0, 0, this.header.bsize);
    }

    private String parseHeaderBody() throws IOException {
        this.header.bsize = 0;
        this.skipSpaces();
        boolean loop = true;
        block8: while (loop) {
            block0 : switch (this.header.ch) {
                case -1: {
                    loop = false;
                    continue block8;
                }
                case 13: {
                    this.header.ch = this.in.read();
                    if (this.header.ch != 10) {
                        this.append(13);
                        continue block8;
                    }
                }
                case 10: {
                    this.header.ch = this.in.read();
                    switch (this.header.ch) {
                        case 9: 
                        case 32: {
                            do {
                                this.header.ch = this.in.read();
                            } while (this.header.ch == 32 || this.header.ch == 9);
                            this.append(this.header.ch);
                            break block0;
                        }
                    }
                    loop = false;
                    continue block8;
                }
                default: {
                    this.append((char)this.header.ch);
                }
            }
            this.header.ch = this.in.read();
        }
        return new String(this.header.buffer, 0, 0, this.header.bsize);
    }

    private int skipNonChars(int ch) throws IOException {
        for (int count = 0; ch <= 32 && count < 100; ++count) {
            ch = this.in.read();
        }
        return ch;
    }

    private void skipSpaces() throws IOException {
        while (this.header.ch == 32 || this.header.ch == 9) {
            this.header.ch = this.in.read();
        }
    }

    private void expect(int car) throws IOException {
        if (car != this.header.ch) {
            String sc = new Character((char)car).toString();
            String se = new Character((char)this.header.ch).toString();
            Object[] args = new Object[]{sc, new Integer(car), se, new Integer(this.header.ch), new String(this.header.buffer, 0, 0, this.header.bsize)};
            throw new NetException(NetExceptionBundle.class, NetExceptionBundle.EXPECTING_ERROR, "", args);
        }
        this.header.ch = this.in.read();
    }

    private final void append(int c) {
        if (this.header.bsize + 1 >= this.header.buffer.length) {
            byte[] nb = new byte[this.header.buffer.length * 2];
            System.arraycopy(this.header.buffer, 0, nb, 0, this.header.buffer.length);
            this.header.buffer = nb;
        }
        this.header.buffer[this.header.bsize++] = (byte)c;
    }

    private String getUrl() throws IOException {
        String ret = null;
        byte[] ba = this.readBytesUntil(32, 10);
        Object baout = null;
        ret = EncodeURL.unescape(ba, EncUtil.getNetEncoding(), 63);
        if (ret == null && (ret = EncodeURL.unescape(ba, EncUtil.getURLEncoding(), 63)) == null) {
            ret = EncodeURL.unescape(ba, 63);
        }
        if (ret != null) {
            return ret;
        }
        return new String();
    }

    private byte[] readBytesUntil(int ch1, int ch2) throws IOException {
        int data;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((data = this.in.read()) != -1 && data != ch1 && data != ch2) {
            bos.write(data);
        }
        return bos.toByteArray();
    }

    private void readAttributes() throws IOException {
        this.header.ch = this.in.read();
        while (!(this.header.ch == 13 ? (this.header.ch = this.in.read()) == 10 : this.header.ch == 10)) {
            String attr = this.parseHeaderName();
            this.skipSpaces();
            String val = this.parseHeaderBody();
            if (attr.equalsIgnoreCase("Set-Cookie")) {
                JournalLogger.logDebugPlus(4, 1, 41, val);
                this.header.cookies.addElement(new HttpCookie(val, this.header.url));
            } else if (attr.equalsIgnoreCase("WWW-Authenticate")) {
                StringTokenizer st = new StringTokenizer(val, " \"");
                this.header.authType = new String(st.nextToken());
                if (this.header.authType.equalsIgnoreCase("Basic") && st.countTokens() >= 3) {
                    st.nextToken();
                    this.header.authRealm = new String(st.nextToken());
                }
            } else if (attr.equalsIgnoreCase("Content-Base")) {
                JournalLogger.logDebugPlus(3, 2, 38, val);
                this.header.baseUrl = val;
            }
            if (JournalLogger.isLogEnabledDebugPlus(3, 2, 38)) {
                if (attr.equals("Authorization")) {
                    JournalLogger.logDebugPlus(3, 2, 38, "<-- " + attr + ": " + this.decodeAuthField(val) + ":****");
                } else {
                    JournalLogger.logDebugPlus(3, 2, 38, "<-- " + attr + ": " + val);
                }
            }
            this.header.addField(attr, val);
        }
        return;
    }

    private String decodeAuthField(String authVal) {
        String[] val = null;
        String decodedVal = "";
        if (authVal != null && !"".equalsIgnoreCase(authVal)) {
            decodedVal = Base64.decode(authVal.substring(5));
            val = decodedVal.split(":");
            return val[0];
        }
        return authVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readStatus() throws IOException {
        String http;
        boolean isMarked = false;
        if (this.in.markSupported()) {
            this.in.mark(20);
            isMarked = true;
        }
        if (!(http = this.readUntil(32, 10)).toLowerCase().startsWith("http/")) {
            if (!isMarked) throw new NetException(NetExceptionBundle.class, NetExceptionBundle.INVALID_HTTP_RESP, "", http);
            this.in.reset();
            this.header.stat = 200;
            this.header.statMessage = "OK";
            this.header.httpVer = "HTTP/0.9";
            return;
        }
        if (http.equalsIgnoreCase("HTTP/1.1")) {
            this.header.setHttpVersion(1);
        }
        if (http.equalsIgnoreCase("HTTP/1.0")) {
            this.header.setHttpVersion(0);
        }
        String statM = this.readUntil(32, 10);
        if (JournalLogger.isLogEnabledDebugPlus(3, 1, 40)) {
            JournalLogger.logDebugPlus(3, 1, 40, http + " " + statM);
        }
        if (statM != null && statM.length() > 0) {
            try {
                this.header.stat = Integer.parseInt(statM);
                this.header.statusIsValid = true;
            }
            catch (NumberFormatException e) {
                throw new NetException(NetExceptionBundle.class, NetExceptionBundle.INVALID_HTTP_RESP_STATUS, "");
            }
        }
        if (this.header.lastCh == 10) {
            return;
        }
        this.header.statMessage = this.readStatusMessage(10);
    }

    private String readStatusMessage(int ch) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((this.header.lastCh = this.in.read()) != -1 && this.header.lastCh != ch) {
            if (this.header.lastCh == 13) continue;
            bos.write(this.header.lastCh);
        }
        byte[] ba = bos.toByteArray();
        return new String(ba, "UTF8");
    }

    private void checkState(boolean mustHaveReadHdr) throws IOException {
        if (mustHaveReadHdr && !this.headerRead) {
            throw new NetException(NetExceptionBundle.class, NetExceptionBundle.HTTP_HEADER_NOT_READ, "");
        }
        if (!mustHaveReadHdr && this.headerRead) {
            throw new NetException(NetExceptionBundle.class, NetExceptionBundle.HTTP_HEADER_READ, "");
        }
    }

    private void resetStream() {
        if (this.in instanceof ChunkedInputStream) {
            this.in = ((ChunkedInputStream)this.in).getStream();
        } else if (this.in instanceof BoundedInputStream) {
            this.in = ((BoundedInputStream)this.in).getStream();
        }
    }

    class BoundedInputStream
    extends FilterInputStream
    implements Disconnectable {
        int left;
        int markLeft;

        public BoundedInputStream(InputStream is, int left) {
            super(is);
            this.left = left;
            this.markLeft = left;
        }

        InputStream getStream() {
            return this.in;
        }

        boolean hasMoreData() {
            return this.left > 0;
        }

        public int available() throws IOException {
            if (this.left < 0) {
                return this.in.available();
            }
            return Math.min(this.in.available(), this.left);
        }

        public void close() throws IOException {
        }

        public void disconnect() throws IOException {
            if (this.in instanceof Disconnectable) {
                Disconnectable dc = (Disconnectable)((Object)this.in);
                dc.disconnect();
            } else {
                this.in.close();
            }
        }

        public void mark(int limit) {
            this.in.mark(limit);
            this.markLeft = this.left;
        }

        public void reset() throws IOException {
            this.in.reset();
            this.left = this.markLeft;
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }

        public long skip(long n) throws IOException {
            if (this.left < 0) {
                return this.in.skip(n);
            }
            return this.in.skip(Math.min(n, (long)this.left));
        }

        public int read() throws IOException {
            if (this.left < 0) {
                return this.in.read();
            }
            if (this.left > 0) {
                --this.left;
                return this.in.read();
            }
            return -1;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.left < 0) {
                return this.in.read(b, off, len);
            }
            if (this.left == 0) {
                return -1;
            }
            int read = this.in.read(b, off, Math.min(this.left, len));
            this.left -= read;
            return read;
        }
    }

    class ChunkedInputStream
    extends FilterInputStream
    implements Disconnectable {
        private boolean reachedEOF;
        private int chunkLength;
        private byte[] oneByteBuffer;

        public ChunkedInputStream(InputStream inputStream) {
            super(inputStream);
            this.reachedEOF = false;
            this.chunkLength = -1;
            this.oneByteBuffer = new byte[1];
        }

        InputStream getStream() {
            return this.in;
        }

        public synchronized int read() throws IOException {
            int b = this.read(this.oneByteBuffer, 0, 1);
            return b == 1 ? this.oneByteBuffer[0] & 0xFF : -1;
        }

        public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.reachedEOF) {
                return -1;
            }
            if (this.chunkLength == -1) {
                this.chunkLength = this.getChunkLength();
            }
            if (this.chunkLength > 0) {
                int totalRead;
                if (length > this.chunkLength) {
                    length = this.chunkLength;
                }
                if ((totalRead = this.in.read(buffer, offset, length)) == -1) {
                    throw new EOFException("eof has been reached too early");
                }
                this.chunkLength -= totalRead;
                if (this.chunkLength == 0) {
                    this.in.read();
                    this.in.read();
                    this.chunkLength = -1;
                }
                return totalRead;
            }
            while (!Streams.readLine(this.in).equals("")) {
            }
            this.reachedEOF = true;
            return -1;
        }

        public void close() {
        }

        public void disconnect() {
            try {
                if (this.in instanceof Disconnectable) {
                    Disconnectable dc = (Disconnectable)((Object)this.in);
                    dc.disconnect();
                } else {
                    this.in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int getChunkLength() throws IOException {
            String chunkLengthLine = Streams.readLine(this.in);
            int index = chunkLengthLine.indexOf(59);
            if (index != -1) {
                chunkLengthLine = chunkLengthLine.substring(0, index);
            }
            try {
                return Integer.parseInt(chunkLengthLine.trim(), 16);
            }
            catch (NumberFormatException nfe) {
                throw new IOException("can not find valid chunk length " + chunkLengthLine);
            }
        }
    }
}

