/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.HttpInputStream;
import com.wm.net.HttpOutputStream;
import com.wm.util.ByteOutputBuffer;
import com.wm.util.Config;
import com.wm.util.EncUtil;
import com.wm.util.List;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public final class HttpHeader
implements ValuesCodable {
    public static int HTTP_CHUNK_SIZE = 8192;
    private static final String DEFAULT_CHUNK_SIZE = "8192";
    public static final byte[] EOL = new byte[]{13, 10};
    public static final String HVER0_9 = "HTTP/0.9";
    public static final String HVER1_0 = "HTTP/1.0";
    public static final String HVER1_1 = "HTTP/1.1";
    public static final String KEY_STATUS_CODE = "status";
    public static final String KEY_STATUS_MESSAGE = "statusMessage";
    public static final String KEY_CONTENT_LINES = "lines";
    public static final String HOST = "Host";
    public static final String CONNECTION = "Connection";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_ID = "Content-Id";
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_RANGE = "Accept-Ranges";
    public static final String ALLOW = "Allow";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CONTENT_BASE = "Content-Base";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String DATE = "Date";
    public static final String ETAG = "ETag";
    public static final String EXPECT = "Expect";
    public static final String EXPIRES = "Expires";
    public static final String FROM = "From";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String PRAGMA = "Pragma";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String PROXY_CONNECTION = "Proxy-Connection";
    public static final String PUBLIC = "Public";
    public static final String RANGE = "Range";
    public static final String REFER = "Refer";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String TE = "TE";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String USER_AGENT = "User-Agent";
    public static final String VARY = "Vary";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String CONNECTION_CLOSE = "close";
    public static final String CONNECTION_KEEPALIVE = "Keep-Alive";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String COOKIE = "Cookie";
    public static final String CHUNKED = "chunked";
    public static final String BASIC = "Basic";
    public static final String CONTINUE = "100-continue";
    public static final String SSNID = "ssnid";
    public static final String WEBM_PREFIX = "$$$Webm";
    public static final String RI_HOST = "$$$WebmReverseInvokeHost";
    public static final String RI_PORT = "$$$WebmReverseInvokePort";
    public static final String RI_CLIENT_HOST = "$$$WebmReverseInvokeClientHost";
    public static final String RI_CERT_COUNT = "$$$WebmCertCount";
    public static final String RI_CERT = "$$$WebmCert-";
    public static final String INIT_STATUS_STRING = "OK";
    public static final int INIT_STATUS = 200;
    public static final int REQUEST = 1;
    public static final int RESPONSE = 2;
    public static final int GET = 0;
    public static final int PUT = 1;
    public static final int POST = 2;
    public static final int HEAD = 3;
    public static final int CONNECT = 4;
    public static final int OPTIONS = 5;
    public static final int DELETE = 6;
    public static final int TRACE = 7;
    protected int ch = -1;
    protected byte[] buffer = new byte[128];
    protected int bsize = 0;
    protected boolean statusIsValid = false;
    char[] pool = new char[40];
    int poolPos;
    int lastCh;
    public static final String[] reqStrType = new String[]{"GET", "PUT", "POST", "HEAD", "CONNECT", "OPTIONS", "DELETE", "TRACE"};
    List attrs = new List();
    Vector cookies = new Vector(3);
    int hdrType;
    int requestType = 0;
    String requestUrl;
    URL url;
    boolean chunked = false;
    boolean bounded = false;
    boolean expectContinue = false;
    boolean usingProxy = false;
    boolean hasBody = true;
    int stat = 200;
    String statMessage = "OK";
    String authType = null;
    String authRealm = null;
    String baseUrl;
    String httpVer = "HTTP/1.1";
    int connectPort = 443;

    public static void main(String[] args) throws Exception {
        HttpHeader hdr = args[0].startsWith("req") ? new HttpHeader(1, null) : new HttpHeader(2, null);
        hdr.read(new HttpInputStream(new FileInputStream(args[1]), hdr));
        System.out.println(hdr);
    }

    public Values getValues() {
        String[][] lines = new String[this.attrs.size()][2];
        for (int i = 0; i < lines.length; ++i) {
            header hdr = (header)this.attrs.elementAt(i);
            lines[i][0] = hdr.attr;
            lines[i][1] = hdr.val;
        }
        Object[][] o = new Object[][]{{KEY_CONTENT_LINES, lines}, {KEY_STATUS_CODE, Integer.toString(this.stat)}, {KEY_STATUS_MESSAGE, this.statMessage}};
        return new Values(o);
    }

    public void setValues(Values val) {
    }

    public HttpHeader(HttpHeader head) {
        Enumeration enumvar = head.attrs.elements();
        while (enumvar.hasMoreElements()) {
            header hdr = (header)enumvar.nextElement();
            this.attrs.addElement(new header(hdr.attr, hdr.val));
        }
        int size = head.cookies.size();
        for (int i = 0; i < size; ++i) {
            this.cookies.addElement(head.cookies.elementAt(i));
        }
        this.hdrType = head.hdrType;
        this.requestType = head.requestType;
        this.requestUrl = head.requestUrl;
        this.url = head.url;
        this.chunked = head.chunked;
        this.expectContinue = head.expectContinue;
        this.usingProxy = head.usingProxy;
        this.hasBody = head.hasBody;
        this.stat = head.stat;
        this.statMessage = head.statMessage;
        this.authType = head.authType;
        this.authRealm = head.authRealm;
        this.baseUrl = head.baseUrl;
        this.httpVer = head.httpVer;
        this.connectPort = head.connectPort;
        this.ch = head.ch;
        this.buffer = new byte[head.buffer.length];
        this.bsize = head.bsize;
        this.statusIsValid = head.statusIsValid;
    }

    public HttpHeader(int hdrType) {
        this(hdrType, null);
    }

    public HttpHeader(int hdrType, URL url) {
        this.hdrType = hdrType;
        this.url = url;
    }

    public HttpHeader(int hdrType, int requestType, URL url) {
        this.hdrType = hdrType;
        this.requestType = requestType;
        this.url = url;
    }

    public void setHttpVersion(int i) {
        if (1 == i) {
            this.httpVer = HVER1_1;
        } else if (i == 0) {
            this.httpVer = HVER1_0;
        }
    }

    public boolean getUsingProxy() {
        return this.usingProxy;
    }

    public void setUsingProxy(boolean using) {
        this.usingProxy = using;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    public void setRequestUrl(URL u) {
        this.url = u;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getVersion() {
        return this.httpVer;
    }

    public int getResponseCode() {
        return this.stat;
    }

    public void setResponse(int code, String msg) {
        this.setResponseCode(code);
        this.setResponseMessage(msg);
    }

    public void setResponseCode(int code) {
        this.statusIsValid = true;
        this.stat = code;
    }

    public String getResponseMessage() {
        return this.statMessage;
    }

    public void setResponseMessage(String msg) {
        this.statMessage = msg;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getAuthRealm() {
        return this.authRealm;
    }

    public Vector getCookies() {
        return this.cookies;
    }

    public void setConnectPort(int port) {
        this.connectPort = port;
    }

    public int getConnectPort() {
        return this.connectPort;
    }

    public static int getMethodValue(String strMethod) {
        int ndx = -1;
        for (ndx = 0; ndx < reqStrType.length && !strMethod.equalsIgnoreCase(reqStrType[ndx]); ++ndx) {
        }
        if (ndx >= reqStrType.length) {
            ndx = -1;
        }
        return ndx;
    }

    public void clearField(int num) {
        if (num < this.attrs.size()) {
            this.attrs.removeElementAt(num);
        }
    }

    public void clearField(String attr) {
        for (int i = 0; i < this.attrs.size(); ++i) {
            if (!((header)this.attrs.elementAt((int)i)).attr.equalsIgnoreCase(attr)) continue;
            this.checkTransEncoding(attr, CHUNKED, true);
            this.attrs.removeElementAt(i);
        }
    }

    public void addField(String attr, int value) {
        this.addField(attr, Integer.toString(value));
    }

    public void addField(String attr, String value) {
        if (value != null) {
            value = value.trim();
        }
        this.checkTransEncoding(attr, value, false);
        this.attrs.addElement(new header(attr, value));
    }

    public void setField(String attr, String value) {
        if (value != null) {
            value = value.trim();
        }
        for (int i = 0; i < this.attrs.size(); ++i) {
            header cur = (header)this.attrs.elementAt(i);
            if (!cur.attr.equalsIgnoreCase(attr)) continue;
            this.checkTransEncoding(attr, value, false);
            cur.val = cur.attr.equalsIgnoreCase(COOKIE) ? Strings.cat(cur.val, "; ", value) : value;
            return;
        }
        this.addField(attr, value);
    }

    private void checkTransEncoding(String attr, String value, boolean clear) {
        if (attr.equalsIgnoreCase(TRANSFER_ENCODING) && value.equalsIgnoreCase(CHUNKED)) {
            this.chunked = !clear;
        }
    }

    public int getNumFields() {
        return this.attrs.size();
    }

    public String getBaseURL() {
        return this.baseUrl;
    }

    public URL getURL() {
        return this.url;
    }

    public String getFieldAttribute(int num) {
        if (num < this.attrs.size()) {
            return ((header)this.attrs.elementAt((int)num)).attr;
        }
        return null;
    }

    public String getFieldValue(String attr) {
        int aSize = this.attrs.size();
        for (int i = 0; i < aSize; ++i) {
            if (!((header)this.attrs.elementAt((int)i)).attr.equalsIgnoreCase(attr)) continue;
            return ((header)this.attrs.elementAt((int)i)).val;
        }
        return null;
    }

    public String getFieldValue(int num) {
        if (num < this.attrs.size()) {
            return ((header)this.attrs.elementAt((int)num)).val;
        }
        return null;
    }

    public String getFieldName(int num) {
        if (num < this.attrs.size()) {
            return ((header)this.attrs.elementAt((int)num)).attr;
        }
        return null;
    }

    public void write(HttpOutputStream os) throws IOException {
        os.writeHeader();
    }

    public void read(HttpInputStream is) throws IOException {
        is.readHeader();
    }

    public static String unescape(String inStr) {
        StringBuffer outStr = new StringBuffer();
        int len = inStr.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = inStr.charAt(i);
            switch (ch) {
                case '%': {
                    char escChar;
                    int val1 = Character.getNumericValue(inStr.charAt(i + 1));
                    int val2 = Character.getNumericValue(inStr.charAt(i + 2));
                    if (val1 < 0 || val1 > 7 || val2 < 0 || val2 > 15) {
                        return "";
                    }
                    String hexStr = inStr.substring(++i, i + 2);
                    ++i;
                    try {
                        escChar = (char)Integer.valueOf(hexStr, 16).intValue();
                    }
                    catch (NumberFormatException e) {
                        return "";
                    }
                    outStr.append(escChar);
                    continue block5;
                }
                default: {
                    outStr.append(ch);
                }
            }
        }
        return outStr.toString();
    }

    public String toString() {
        try {
            ByteOutputBuffer bo = new ByteOutputBuffer();
            HttpOutputStream os = new HttpOutputStream(bo, this);
            this.write(os);
            os = null;
            return bo.toString(EncUtil.getNetEncoding());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public boolean expectsContinue() {
        return this.expectContinue;
    }

    public boolean statusIsValid() {
        return this.statusIsValid;
    }

    private void checkHttpHeaders(String version) {
    }

    static {
        String defSize = System.getProperty("watt.net.httpChunkSize");
        if (defSize == null || defSize.length() == 0) {
            defSize = Config.getProperty(DEFAULT_CHUNK_SIZE, "watt.net.httpChunkSize");
        }
        if (defSize != null) {
            try {
                HTTP_CHUNK_SIZE = Integer.parseInt(defSize);
            }
            catch (NumberFormatException e) {
                HTTP_CHUNK_SIZE = 8192;
            }
        }
    }

    class header {
        String attr;
        String val;

        header(String a, String v) {
            this.attr = a;
            this.val = v;
        }
    }
}

