/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.util.JournalLogger;
import com.wm.util.Strings;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HttpCookie
implements Serializable {
    public static final String quot = "\"";
    public static final int NETSVC0010 = 10;
    public Hashtable values = new Hashtable();
    public String domain;
    public String port;
    public String path;
    public String expires;
    public String maxage;
    public String version;
    public String comment;
    public String secure;

    public HttpCookie(String cookie, URL url) {
        int num = 0;
        StringTokenizer st = new StringTokenizer(cookie, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int div = token.indexOf(61);
            if (div < 0) {
                token = token + "=";
                div = token.indexOf(61);
            }
            if (div <= 0) continue;
            String tname = token.substring(0, div).trim();
            String tval = token.substring(div + 1).trim();
            if (num++ == 0) {
                this.values.put(tname, tval);
                continue;
            }
            if (tname.equalsIgnoreCase("path")) {
                this.path = tval;
                continue;
            }
            if (tname.equalsIgnoreCase("version")) {
                this.version = tval;
                continue;
            }
            if (tname.equalsIgnoreCase("domain")) {
                this.domain = tval;
                continue;
            }
            if (tname.equalsIgnoreCase("port")) {
                this.port = tval;
                continue;
            }
            if (tname.equalsIgnoreCase("expires")) {
                this.expires = tval;
                continue;
            }
            if (tname.equalsIgnoreCase("max-age")) {
                this.maxage = tval;
                continue;
            }
            if (tname.equalsIgnoreCase("comment")) {
                this.comment = tval;
                continue;
            }
            if (!tname.equalsIgnoreCase("secure")) continue;
            this.secure = tval;
        }
        if (this.domain == null && url != null) {
            this.domain = url.getHost();
        }
        if (this.port == null && url != null) {
            this.port = Integer.toString(url.getPort());
        }
        if (this.path == null) {
            this.path = "/";
        }
    }

    public boolean match(HttpCookie check) {
        boolean match = true;
        if (!check.domain.equals(this.domain)) {
            match = false;
        }
        if (!check.port.equals(this.port)) {
            match = false;
        }
        if (check.path != null && !check.path.equals(this.path)) {
            match = false;
        }
        return match;
    }

    public boolean match(URL url) {
        if (this.path == null || this.domain == null) {
            return false;
        }
        String host = url.getHost();
        String file = url.getFile();
        String urlport = Integer.toString(url.getPort());
        if (file.indexOf(this.path) == 0 && urlport.indexOf(this.port) == 0) {
            int loc = host.indexOf(this.domain);
            if (loc < 0) {
                return false;
            }
            if (loc + this.domain.length() == host.length()) {
                return true;
            }
        }
        return false;
    }

    public synchronized boolean updateFrom(HttpCookie match) {
        if (match.maxage != null && match.maxage.equals("0")) {
            return false;
        }
        this.expires = match.expires;
        this.comment = match.comment;
        this.maxage = match.maxage;
        this.secure = match.secure;
        JournalLogger.logDebugPlus(6, 10, 64, match.toString());
        Enumeration x = match.values.keys();
        while (x.hasMoreElements()) {
            String name = (String)x.nextElement();
            String val = (String)match.values.get(name);
            if (val == null) continue;
            this.values.put(name, val);
        }
        return true;
    }

    public String cookieString() {
        StringBuffer sb = new StringBuffer(60);
        int cookiesFound = 0;
        Enumeration x = this.values.keys();
        while (x.hasMoreElements()) {
            String name = (String)x.nextElement();
            String val = (String)this.values.get(name);
            if (val != null && val.length() > 0) {
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append(name);
                sb.append("=");
                if (this.version != null) {
                    sb.append(quot);
                }
                sb.append(val);
                if (this.version != null) {
                    sb.append(quot);
                }
                ++cookiesFound;
                continue;
            }
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(name);
            sb.append("=");
        }
        if (this.path != null && this.version != null) {
            sb.append("; $Path=");
            if (this.version != null) {
                sb.append(quot);
            }
            sb.append(this.path);
            if (this.version != null) {
                sb.append(quot);
            }
        }
        if (this.domain != null && this.version != null) {
            sb.append("; $Domain=");
            if (this.version != null) {
                sb.append(quot);
            }
            sb.append(this.domain);
            if (this.version != null) {
                sb.append(quot);
            }
        }
        return sb.toString();
    }

    public String toString() {
        return Strings.cat(this.cookieString(), "; path=", this.path, "; domain=", this.domain, "; port=", this.port);
    }
}

