/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.HttpAuth;
import com.wm.net.HttpFormatException;
import com.wm.net.HttpHeader;
import com.wm.net.HttpURLConnection;
import com.wm.net.RedirectException;
import com.wm.net.resources.HttpFormatExceptionBundle;
import com.wm.util.Base64;
import com.wm.util.EncUtil;
import com.wm.util.JournalLogger;
import com.wm.util.Values;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HttpContext
implements Cloneable,
Serializable {
    public static final int NETSVC0001 = 1;
    public static final int NETSVC0002 = 2;
    public static final int NETSVC0003 = 3;
    public static final int NETSVC0004 = 4;
    URL url = null;
    URLConnection connection = null;
    Values connectionContext = new Values();
    Values headerInfo = new Values();
    Vector cookies = new Vector();
    String httpUser = null;
    String httpPass = null;
    boolean useCookies = false;
    Values tempHeaderInfo = null;
    String tempHttpUser = null;
    String tempHttpPass = null;
    Vector authList = new Vector();
    static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded";
    String defaultContentType = "application/x-www-form-urlencoded";

    public HttpContext() {
        this.httpUser = System.getProperty("watt.net.httpUser");
        this.httpPass = System.getProperty("watt.net.httpPass");
        String s = System.getProperty("watt.net.useCookies");
        this.useCookies = new Boolean(s);
    }

    public HttpContext(String user, String pass) {
        this();
        this.setAuth(user, pass);
    }

    public HttpContext getClone() {
        try {
            return (HttpContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            JournalLogger.logError(1, 64);
            return new HttpContext();
        }
    }

    public String getURLPath(String url) {
        int k;
        if (url == null) {
            return null;
        }
        String path = url;
        int i = path.indexOf("//");
        if (i >= 0 && (k = path.indexOf("?", i + 2)) > i) {
            path = path.substring(0, k);
        }
        return path;
    }

    public void addAuth(String user, String pass, String urlString) {
        HttpAuth auth = new HttpAuth(user, pass, HttpHeader.unescape(urlString));
        if (!this.authList.contains(auth)) {
            this.authList.addElement(auth);
        } else {
            int ndx = this.authList.indexOf(auth);
            this.authList.setElementAt(auth, ndx);
        }
    }

    public void checkUrlAuth(URL url) {
        if (this.tempHttpUser != null) {
            return;
        }
        if (url == null) {
            return;
        }
        if (this.authList.size() == 0) {
            return;
        }
        String toMatch = this.getURLPath(HttpHeader.unescape(url.toString()));
        for (int i = 0; i < this.authList.size(); ++i) {
            HttpAuth a = (HttpAuth)this.authList.elementAt(i);
            if (!a.match(toMatch)) continue;
            this.setTempAuth(a.user, a.pass);
        }
    }

    public Vector getCookies() {
        return this.cookies;
    }

    public void setCookies(Vector cookies) {
        this.cookies = cookies;
    }

    public void setUseCookies(boolean useCookies) {
        this.useCookies = useCookies;
    }

    public boolean isUseCookies() {
        return this.useCookies;
    }

    public void setTempAuth(String user, String pass) {
        this.tempHttpUser = user;
        this.tempHttpPass = pass;
    }

    public void setTempHdr(Values hdrInfo) {
        this.tempHeaderInfo = hdrInfo;
    }

    public void setConnectionContext(Values connectionContext) {
        this.connectionContext = connectionContext;
    }

    public void setAuth(String user, String pass) {
        this.httpUser = user;
        this.httpPass = pass;
    }

    public void setDefaultContentType(String ct) {
        this.defaultContentType = ct;
    }

    public void setRequestHeader(String header2, String value) {
        this.headerInfo.put(header2, value);
    }

    public HttpHeader getResponseHeader() {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getResponseHeader();
        }
        return null;
    }

    public String getResponseHeader(String header2) {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getHeaderField(header2);
    }

    protected URL getConnectionURL() {
        return this.url;
    }

    public InputStream getInputStream(String urlString) throws IOException {
        return this.getInputStream(0, urlString);
    }

    public InputStream getInputStream(int method, String urlString) throws IOException {
        if (urlString.indexOf("://") < 0) {
            int qpos = urlString.indexOf("?");
            if (qpos < 0) {
                qpos = urlString.length();
            }
            urlString = urlString.substring(0, qpos);
            this.url = new URL("file:/" + urlString.replace(':', '|').replace('\\', '/'));
            return new FileInputStream(urlString);
        }
        if (urlString.startsWith("file://")) {
            int qpos = urlString.indexOf("?");
            if (qpos < 0) {
                qpos = urlString.length();
            }
            String filePath = urlString.substring("file://".length());
            this.url = new URL("file://" + filePath.replace(':', '|').replace('\\', '/'));
            return new FileInputStream(filePath);
        }
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new HttpFormatException(HttpFormatExceptionBundle.class, HttpFormatExceptionBundle.MALFORMED_URL, "", urlString);
        }
        return this.getInputStream(method, this.url);
    }

    public InputStream getInputStream(URL url) throws IOException {
        return this.getInputStream(0, url);
    }

    public InputStream getInputStream(int method, URL url) throws IOException {
        this.url = url;
        this.connection = this.getURLConnection();
        ((HttpURLConnection)this.connection).setRequestMethod(HttpHeader.reqStrType[method].toUpperCase());
        return this.finishInputStream(this.getFinalInputStream());
    }

    public InputStream get(String urlString) throws IOException {
        if (JournalLogger.isLogEnabledDebugPlus(5, 2, 64)) {
            JournalLogger.logDebugPlus(5, 2, 64, urlString);
        }
        return this.getInputStream(0, urlString);
    }

    public InputStream get(String url, String arg) throws IOException {
        return this.get(url + (arg.length() > 0 ? "?" + arg : ""));
    }

    public InputStream options(String urlString) throws IOException {
        if (JournalLogger.isLogEnabledDebugPlus(5, 2, 64)) {
            JournalLogger.logDebugPlus(5, 2, 64, urlString);
        }
        return this.getInputStream(5, urlString);
    }

    public InputStream del(String urlString) throws IOException {
        if (JournalLogger.isLogEnabledDebugPlus(5, 2, 64)) {
            JournalLogger.logDebugPlus(5, 2, 64, urlString);
        }
        return this.getInputStream(6, urlString);
    }

    public InputStream head(String urlString) throws IOException {
        if (JournalLogger.isLogEnabledDebugPlus(5, 2, 64)) {
            JournalLogger.logDebugPlus(5, 2, 64, urlString);
        }
        return this.getInputStream(3, urlString);
    }

    public InputStream head(String url, String arg) throws IOException {
        return this.head(url + (arg.length() > 0 ? "?" + arg : ""));
    }

    public InputStream trace(String url, String arg) throws IOException {
        return this.trace(url + (arg.length() > 0 ? "?" + arg : ""));
    }

    public InputStream trace(String urlString) throws IOException {
        if (JournalLogger.isLogEnabledDebugPlus(5, 2, 64)) {
            JournalLogger.logDebugPlus(5, 2, 64, urlString);
        }
        return this.getInputStream(7, urlString);
    }

    public InputStream post(String urlString, String data) throws IOException {
        return this.post(urlString, data, null);
    }

    public InputStream post(String urlString, String data, String contentType) throws IOException {
        OutputStream outStream = this.getOutputStream(2, urlString, contentType);
        if (data != null && data.length() != 0) {
            if (JournalLogger.isLogEnabledDebugPlus(5, 2, 64)) {
                JournalLogger.logDebugPlus(5, 2, 64, data);
            }
            outStream.write(EncUtil.getNetBytes(data));
        }
        return this.finishInputStream(this.getFinalInputStream());
    }

    public InputStream post(String urlString, InputStream sourceStream, String contentType) throws IOException {
        OutputStream outStream = this.getOutputStream(2, urlString, contentType, sourceStream);
        return this.finishInputStream(this.getFinalInputStream());
    }

    public InputStream post(String urlString, byte[] data) throws IOException {
        return this.post(urlString, data, null);
    }

    public InputStream post(String urlString, byte[] data, String contentType) throws IOException {
        OutputStream outStream = this.getOutputStream(2, urlString, contentType);
        if (data != null && data.length != 0) {
            if (JournalLogger.isLogEnabledDebugPlus(5, 2, 64)) {
                JournalLogger.logDebugPlus(5, 2, 64, new String(data));
            }
            outStream.write(data);
        }
        return this.finishInputStream(this.getFinalInputStream());
    }

    public InputStream put(String urlString, String data) throws IOException {
        return this.put(urlString, data, null);
    }

    public InputStream put(String urlString, String data, String contentType) throws IOException {
        OutputStream outStream = this.getOutputStream(1, urlString, contentType);
        if (data != null && data.length() != 0) {
            if (JournalLogger.isLogEnabledDebugPlus(5, 2, 64)) {
                JournalLogger.logDebugPlus(5, 2, 64, data);
            }
            outStream.write(EncUtil.getNetBytes(data));
        }
        return this.finishInputStream(this.getFinalInputStream());
    }

    public InputStream put(String urlString, byte[] data) throws IOException {
        return this.put(urlString, data, null);
    }

    public InputStream put(String urlString, byte[] data, String contentType) throws IOException {
        OutputStream outStream = this.getOutputStream(1, urlString, contentType);
        if (data != null && data.length != 0) {
            if (JournalLogger.isLogEnabledDebugPlus(5, 2, 64)) {
                JournalLogger.logDebugPlus(5, 2, 64, new String(data));
            }
            outStream.write(data);
        }
        return this.finishInputStream(this.getFinalInputStream());
    }

    public String getURL() {
        if (this.connection != null) {
            return this.connection.getURL().toString();
        }
        if (this.url != null) {
            return this.url.toString();
        }
        return null;
    }

    public String getBaseURL() {
        String baseUrl;
        if (this.connection != null && this.connection instanceof HttpURLConnection && (baseUrl = ((HttpURLConnection)this.connection).getBaseURL()) != null) {
            return baseUrl;
        }
        return this.getURL();
    }

    public Hashtable getHeaderInfo() {
        String n;
        if (this.connection == null) {
            return null;
        }
        Hashtable<String, String> h = new Hashtable<String, String>();
        int i = 0;
        while ((n = this.connection.getHeaderFieldKey(i)) != null) {
            n = n.toLowerCase();
            String v = this.connection.getHeaderField(i);
            h.put(n, v);
            ++i;
        }
        return h;
    }

    public Vector getCookieInfo() {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getCookies();
        }
        return null;
    }

    public void setHttpAuth(URLConnection c, String user, String password) {
        if (user != null && user.length() > 0) {
            c.setRequestProperty("Authorization", "Basic " + Base64.encode(user + ":" + password));
        }
    }

    public void setConnectionInfo(URLConnection c) {
        if (this.tempHttpUser != null) {
            this.setHttpAuth(c, this.tempHttpUser, this.tempHttpPass);
        } else {
            this.setHttpAuth(c, this.httpUser, this.httpPass);
        }
        if (this.defaultContentType != null) {
            c.setRequestProperty("Content-Type", this.defaultContentType);
        }
        this.addRequestHeaderInfo(c, this.headerInfo);
        this.addRequestHeaderInfo(c, this.tempHeaderInfo);
        if (this.useCookies && this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).setCookies(this.cookies);
        }
    }

    private InputStream finishInputStream(InputStream is) throws IOException {
        this.tempHttpUser = null;
        this.tempHttpPass = null;
        this.tempHeaderInfo = null;
        return is;
    }

    private void addRequestHeaderInfo(URLConnection c, Values hash) {
        if (hash == null) {
            return;
        }
        Enumeration e = hash.keys();
        while (e.hasMoreElements()) {
            String Key2 = (String)e.nextElement();
            String Value = (String)hash.get(Key2);
            c.setRequestProperty(Key2, Value);
        }
    }

    private OutputStream getOutputStream(int method, String urlString) throws IOException {
        return this.getOutputStream(method, urlString, null);
    }

    private OutputStream getOutputStream(int method, String urlString, String contentType) throws IOException {
        return this.getOutputStream(method, urlString, contentType, null);
    }

    private OutputStream getOutputStream(int method, String urlString, String contentType, InputStream is) throws IOException {
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new HttpFormatException(HttpFormatExceptionBundle.class, HttpFormatExceptionBundle.MALFORMED_URL, "", urlString);
        }
        this.connection = this.getURLConnection();
        this.connection.setDoOutput(true);
        ((HttpURLConnection)this.connection).setRequestMethod(HttpHeader.reqStrType[method].toUpperCase());
        if (contentType != null) {
            this.connection.setRequestProperty("Content-Type", contentType);
        }
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getOutputStream(is);
        }
        return this.connection.getOutputStream();
    }

    private InputStream getFinalInputStream() throws IOException {
        boolean redir;
        InputStream is = null;
        do {
            redir = false;
            try {
                is = this.connection.getInputStream();
            }
            catch (RedirectException r) {
                redir = true;
                this.url = r.url;
                this.cookies = r.cookies;
                this.connection = this.redirectURLConnection(r.requestHeader);
            }
        } while (redir);
        return this.finishInputStream(is);
    }

    protected URLConnection getURLConnection() throws IOException {
        this.checkUrlAuth(this.url);
        this.connection = HttpURLConnection.getHttpURLConnection(this.url, this.connectionContext);
        this.setConnectionInfo(this.connection);
        return this.connection;
    }

    private URLConnection redirectURLConnection(HttpHeader requestHeader) throws IOException {
        this.connection = HttpURLConnection.getHttpURLConnection(this.url);
        if (!(this.connection instanceof HttpURLConnection)) {
            this.setConnectionInfo(this.connection);
            return this.connection;
        }
        ((HttpURLConnection)this.connection).setRequestHeader(requestHeader);
        if (this.useCookies) {
            ((HttpURLConnection)this.connection).setCookies(this.cookies);
        }
        return this.connection;
    }
}

