/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.AuthenticationHandler;
import com.wm.net.AuthenticationHandlerFactory;
import java.util.Enumeration;
import java.util.Vector;

public class HttpAuthManager {
    static Vector gListeners;

    static void init() {
        if (gListeners == null) {
            gListeners = new Vector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerHandlerFactory(AuthenticationHandlerFactory fac) {
        if (fac == null) {
            return false;
        }
        int wt = fac.getWeight();
        Vector vector = gListeners;
        synchronized (vector) {
            int index;
            int size = gListeners.size();
            if (size == 0) {
                index = 0;
            } else {
                index = size - 1;
                for (int i = 0; i < size; ++i) {
                    AuthenticationHandlerFactory listener = (AuthenticationHandlerFactory)gListeners.elementAt(i);
                    if (wt == listener.getWeight()) {
                        if (!fac.getName().equals(listener.getName())) continue;
                        return true;
                    }
                    if (wt <= listener.getWeight()) continue;
                    index = i;
                    break;
                }
            }
            gListeners.insertElementAt(fac, index);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterHandlerFactory(String name) {
        if (name == null) {
            return true;
        }
        Vector vector = gListeners;
        synchronized (vector) {
            int size = gListeners.size();
            for (int i = 0; i < size; ++i) {
                AuthenticationHandlerFactory listener = (AuthenticationHandlerFactory)gListeners.elementAt(i);
                if (!name.equals(listener.getName())) continue;
                gListeners.removeElementAt(i);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] listListeners() {
        String[] names = null;
        Vector vector = gListeners;
        synchronized (vector) {
            int size = gListeners.size();
            names = new String[size];
            for (int i = 0; i < size; ++i) {
                AuthenticationHandlerFactory fac = (AuthenticationHandlerFactory)gListeners.elementAt(i);
                names[i] = fac.getName();
            }
        }
        return names;
    }

    static AuthenticationHandler getAuthHandler(String authHdr) {
        AuthenticationHandlerFactory hal = HttpAuthManager.findAuthHandlerFactory(authHdr);
        return hal == null ? null : hal.create();
    }

    static boolean hasAuthHandler(String authHdr) {
        return HttpAuthManager.findAuthHandlerFactory(authHdr) != null;
    }

    private static AuthenticationHandlerFactory findAuthHandlerFactory(String authHdr) {
        AuthenticationHandlerFactory returnFactory = null;
        if (authHdr != null) {
            Enumeration e = gListeners.elements();
            while (e.hasMoreElements()) {
                AuthenticationHandlerFactory hal = (AuthenticationHandlerFactory)e.nextElement();
                if (!hal.canProcess(authHdr)) continue;
                returnFactory = hal;
                break;
            }
        }
        return returnFactory;
    }

    static {
        HttpAuthManager.init();
    }
}

