/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.FTPSSession;
import com.wm.net.FTPSession;
import com.wm.util.Config;
import com.wm.util.Debug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

public class FTPSessionManager
implements Runnable {
    private static final int minute = 60000;
    private static final int seconds = 1000;
    public static Hashtable sessions = new Hashtable(10);
    static long timeout = 600000L;
    static boolean running = false;
    static boolean quiesced = false;
    private static int oneUpNumber = 0;
    private static long idleTimeout;
    static boolean debug;

    public static FTPSession createFTPSession(String serverhost, int sport, String username, String password, String acct, int dport, boolean active, int timeout, String encoding, String svrEnc) throws Exception {
        FTPSession session = new FTPSession(serverhost, sport, username, password, acct, dport, active, timeout, encoding, svrEnc);
        if ((long)oneUpNumber == Long.MAX_VALUE) {
            oneUpNumber = 0;
        }
        session.setID(FTPSessionManager.getFTPSessionID(serverhost, sport, username) + "_" + oneUpNumber++);
        session.setIdleTimeout(idleTimeout);
        FTPSessionManager.addFTPSession(session.getID(), session);
        return session;
    }

    public static FTPSSession createFTPSSession(String serverhost, int sport, String username, String password, String acct, int dport, boolean active, int timeout, String enc, String svrEnc, boolean secureDataChannel, String authMechanism) throws Exception {
        FTPSSession session = new FTPSSession(serverhost, sport, username, password, acct, dport, active, timeout, enc, svrEnc, secureDataChannel, authMechanism);
        if ((long)oneUpNumber == Long.MAX_VALUE) {
            oneUpNumber = 0;
        }
        session.setID(FTPSessionManager.getFTPSessionID(serverhost, sport, username) + "_" + oneUpNumber++);
        session.setIdleTimeout(idleTimeout);
        FTPSessionManager.addFTPSession(session.getID(), session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FTPSession getFTPSession(String id) {
        FTPSession session;
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            session = (FTPSession)sessions.get(id.trim());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFTPSession(String id, FTPSession session) {
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            sessions.put(id.trim(), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFTPSession(String id) {
        Hashtable hashtable = sessions;
        synchronized (hashtable) {
            sessions.remove(id);
        }
    }

    public static String getFTPSessionID(String serverhost, int sport, String username) {
        String serverKey = null;
        try {
            InetAddress ip = InetAddress.getByName(serverhost);
            serverKey = ip.getHostAddress();
        }
        catch (UnknownHostException e) {
            serverKey = serverhost.toLowerCase();
        }
        String sessionkey = serverKey + ":" + sport + ":" + username + ":" + Thread.currentThread().hashCode();
        return sessionkey;
    }

    public static void setIdleTimeout(long tm) {
        idleTimeout = tm * 1000L;
    }

    public static long getIdleTimeout() {
        return idleTimeout;
    }

    public static void setQuiesced(boolean b) {
        quiesced = b;
    }

    public static boolean isQuiesced() {
        return quiesced;
    }

    public static int getNumContexts() {
        return sessions.size();
    }

    public static FTPSession getSession(String sid) {
        return sid == null ? null : sessions.get(sid);
    }

    public static Enumeration getSessionIDs() {
        return sessions.keys();
    }

    public void run() {
        debug = Boolean.getBoolean("watt.net.ftpDebug");
        if (debug) {
            Debug.log(1, "");
            Debug.log(1, "Running FTPSession Sweeper");
        }
        Enumeration e = sessions.keys();
        while (e.hasMoreElements()) {
            String ssnid = (String)e.nextElement();
            FTPSession next = (FTPSession)sessions.get(ssnid);
            if (next == null) continue;
            if (debug) {
                Debug.log(1, "   FTP session " + next.getID());
                Debug.log(1, "     last is " + next.getLast());
                Debug.log(1, "     tmout is " + next.getIdleTimeout() + " ms");
                Debug.log(1, "     busy is " + next.isBusy());
            }
            long last = next.getLast();
            long tmout = next.getIdleTimeout();
            if (tmout <= 0L || System.currentTimeMillis() - last < tmout || next.isBusy()) continue;
            if (debug) {
                Debug.log(1, "     deleting session");
            }
            FTPSessionManager.deleteSession(ssnid);
        }
        if (debug) {
            Debug.log(1, "Leaving FTPSession Sweeper\n");
        }
    }

    public static void deleteSession(String ssnid) {
        if (ssnid != null) {
            FTPSession session = (FTPSession)sessions.get(ssnid);
            if (session != null && session.getIdleTimeout() == 0L) {
                return;
            }
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sessions.remove(ssnid);
            }
        }
    }

    static {
        debug = false;
        try {
            long tmout = Long.valueOf(Config.getProperty("watt.net.ftpClientTimeout"));
            FTPSessionManager.setIdleTimeout(tmout);
        }
        catch (Exception e) {
            FTPSessionManager.setIdleTimeout(600L);
        }
    }
}

