/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.ftpCException;
import com.wm.net.resources.FtpExceptionBundle;
import com.wm.util.Config;
import com.wm.util.EncUtil;
import com.wm.util.EncodingNames;
import com.wm.util.JournalLogger;
import com.wm.util.ProxySettings;
import com.wm.util.StringMatcher;
import com.wm.util.security.WmSecureString;
import com.wm.util.tspace.InsufficientSpaceException;
import com.wm.util.tspace.Reservation;
import com.wm.util.tspace.ReservationAgent;
import com.wm.util.tspace.ReservationException;
import com.wm.util.tspace.ReservationInitException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FTPSession {
    public static final int NETSVC0020 = 20;
    public static final int NETSVC0021 = 21;
    public static final int NETSVC0022 = 22;
    public static final int NETSVC0023 = 23;
    public static final int NETSVC0024 = 24;
    public static final int NETSVC0025 = 25;
    public static final int NETSVC0026 = 26;
    public static final int NETSVC0028 = 28;
    public static final long DEFAULT_IDLE_TIMEOUT = 300000L;
    protected static final String lineSeparator = System.getProperty("line.separator");
    public String encoding = null;
    public String svrEncoding = null;
    String sessionname;
    String message = null;
    public String hostName = null;
    public int port = 0;
    static int type = 0;
    public String userName = null;
    public String password = null;
    public String account = null;
    String[] Cmd = null;
    boolean connected = false;
    boolean signon = false;
    Socket sock = null;
    InputStream socketInputStream = null;
    OutputStream socketOutputStream = null;
    PrintWriter ftpOut;
    InputStreamReader ftpIn;
    Object usrData = null;
    Object rcvData = null;
    char mode = (char)65;
    StringBuffer log;
    String filename;
    int rc = 0;
    int dataport = 0;
    int defaultProxyPort = 21;
    public boolean activemode = true;
    ServerSocket ssock = null;
    Socket sk = null;
    String localfile;
    int gTimeout = 0;
    boolean aborted = false;
    String lastCmd;
    String id = "";
    int loginReturnCode = -1;
    String loginReturnMsg = null;
    String loginLogMsg = null;
    boolean multiline = false;
    boolean cleanLineFeeds = true;
    private boolean skipLF;
    protected static String proxyHost;
    protected static String proxyPort;
    protected static String proxyUser;
    protected static String proxyPass;
    protected static String proxyType;
    protected static boolean usingProxy;
    private boolean busy = false;
    private long idleTimeout = 300000L;
    private long lastCall;
    private Date start;
    private int calls;
    private static String lastSkipList;
    private static Hashtable noProxyHosts;
    private static Hashtable noProxyWildcardHosts;

    protected FTPSession() {
    }

    public FTPSession(String serverhost, int serverport, String username, String passwd, int dport, boolean active, int timeout) throws ftpCException, IOException {
        this(serverhost, serverport, username, passwd, null, dport, active, timeout, null, null);
    }

    public FTPSession(String serverhost, int serverport, String username, String passwd, int dport, boolean active, int timeout, String enc) throws ftpCException, IOException {
        this(serverhost, serverport, username, passwd, null, dport, active, timeout, enc, null);
    }

    public FTPSession(String serverhost, int serverport, String username, String passwd, String acct, int dport, boolean active, int timeout, String enc) throws ftpCException, IOException {
        this(serverhost, serverport, username, passwd, acct, dport, active, timeout, enc, null);
    }

    public FTPSession(String serverhost, int serverport, String username, String passwd, String acct, int dport, boolean active, int timeout, String enc, String svrEnc) throws ftpCException, IOException {
        this.init(serverhost, serverport, username, passwd, acct, dport, active, timeout, enc, svrEnc);
    }

    void init(String serverhost, int serverport, String username, String passwd, String acct, int dport, boolean active, int timeout, String enc, String svrEnc) throws ftpCException, IOException {
        Date now;
        this.hostName = serverhost;
        this.port = serverport;
        this.userName = username;
        this.password = passwd;
        this.account = acct;
        this.dataport = dport;
        this.activemode = active;
        this.encoding = EncodingNames.getJavaName(enc);
        this.svrEncoding = EncodingNames.getJavaName(svrEnc);
        this.gTimeout = timeout;
        this.log = new StringBuffer(1024);
        this.start = now = new Date();
        this.lastCall = now.getTime();
        this.calls = 0;
        this.setupProxy();
        this.setPersonality(this.hostName);
        if (!usingProxy) {
            this.login();
        } else {
            this.proxyLogin();
        }
        this.update(false);
    }

    void setupProxy() {
        proxyHost = ProxySettings.getFtpProxyHost();
        proxyType = "0";
        if (proxyHost != null) {
            proxyHost = proxyHost.trim();
        }
        if (proxyHost != null && proxyHost.length() > 0) {
            proxyPort = ProxySettings.getFtpProxyPort();
            proxyUser = ProxySettings.getFtpProxyUser();
            WmSecureString proPass = ProxySettings.getFtpProxyPass();
            proxyPass = proPass != null ? ((Object)proPass).toString() : null;
            proxyType = ProxySettings.getFtpProxyType();
            if (proxyPort != null) {
                proxyPort = proxyPort.trim();
            }
            if (proxyUser != null) {
                proxyUser = proxyUser.trim();
            }
            if (proxyPass != null) {
                proxyPass = proxyPass.trim();
            }
            if (proxyType != null) {
                proxyType = proxyType.trim();
            }
        }
    }

    public void setUsrData(Object data) {
        this.usrData = data;
    }

    public void setID(String key) {
        this.id = key;
    }

    public String getID() {
        return this.id;
    }

    protected void connect() throws ftpCException {
        try {
            this.connect(this.hostName, this.port);
        }
        catch (Exception e) {
            this.rc = -1;
            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_CONNECT_ERROR, "", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(String hName, int hPort) throws Exception {
        try {
            this.update(true);
            this.rcvData = null;
            this.rc = 0;
            int pport = this.defaultProxyPort;
            if (hName == null || hPort == 0) {
                throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_INVALID_HOST_PORT, "");
            }
            Object[] args = new Object[]{this.hostName, new Integer(this.port), this.userName};
            JournalLogger.logDebugPlus(5, 20, 64, args);
            if (usingProxy) {
                if (proxyPort != null) {
                    pport = Integer.valueOf(proxyPort);
                }
                this.sock = this.createSocket(proxyHost, pport);
                if (this.sock == null) {
                    Object[] params = new Object[]{proxyHost, new Integer(pport)};
                    throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_PROXY_ERR, "", params);
                }
            } else {
                this.sock = this.createSocket(hName, hPort);
                if (this.sock == null) {
                    Object[] params = new Object[]{hName, new Integer(hPort)};
                    throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_SERVER_CONNECT_ERR, "", params);
                }
            }
            if (this.gTimeout > 0) {
                this.sock.setSoTimeout(this.gTimeout);
            }
            this.socketInputStream = new BufferedInputStream(this.sock.getInputStream());
            this.socketOutputStream = this.sock.getOutputStream();
            Object[] args1 = new Object[]{hName, new Integer(hPort)};
            JournalLogger.logDebugPlus(5, 21, 64, args1);
            int cd = this.getPrompt();
            if (cd >= 300) {
                throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_WELCOME_MSG_ERR, "", this.message);
            }
            this.ftpOut = new PrintWriter((Writer)new OutputStreamWriter(this.socketOutputStream, this.svrEncoding == null ? EncUtil.getNetEncoding() : this.svrEncoding), true);
            this.ftpIn = new InputStreamReader(this.socketInputStream, this.svrEncoding == null ? EncUtil.getNetEncoding() : this.svrEncoding);
            this.connected = true;
        }
        finally {
            this.update(false);
        }
    }

    Socket createSocket(String server, int port) throws IOException {
        Socket s = new Socket();
        InetSocketAddress sa = new InetSocketAddress(server, port);
        s.connect(sa, this.gTimeout);
        return s;
    }

    ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port);
    }

    Socket createClientSocket(String host, int port) throws IOException {
        return new Socket(host, port);
    }

    public void setPersonality(String host) {
        usingProxy = FTPSession.isProxyAllowed(host);
    }

    static final void setupProxyRules() {
        String skipList = Config.getProperty("localhost", "watt.net.proxySkipList");
        if (skipList == lastSkipList) {
            return;
        }
        lastSkipList = skipList;
        noProxyHosts.clear();
        noProxyWildcardHosts.clear();
        StringTokenizer st = new StringTokenizer(skipList, ", ");
        while (st.hasMoreTokens()) {
            FTPSession.setUseProxy(st.nextToken(), false);
        }
    }

    public static final boolean isProxyAllowed(String aHost) {
        if (proxyType != null) {
            try {
                type = Integer.parseInt(proxyType);
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else {
            return false;
        }
        if (type == 0) {
            return false;
        }
        if (aHost == null || aHost.length() == 0) {
            return true;
        }
        String host = aHost.toLowerCase();
        FTPSession.setupProxyRules();
        Enumeration e = noProxyWildcardHosts.elements();
        while (e.hasMoreElements()) {
            if (!new StringMatcher((String)e.nextElement()).match(host)) continue;
            return false;
        }
        return noProxyHosts.get(host) == null;
    }

    public static final void setUseProxy(String aHost, boolean use) {
        if (aHost == null || aHost.length() == 0) {
            return;
        }
        String host = aHost.toLowerCase();
        if (use) {
            noProxyHosts.remove(host);
            noProxyWildcardHosts.remove(host);
        } else if (host.indexOf(42) >= 0) {
            noProxyWildcardHosts.put(host, host);
        } else {
            noProxyHosts.put(host, host);
        }
    }

    private void proxyConnect(String hName, int hPort) throws Exception {
        this.rcvData = null;
        this.rc = 0;
        if (hName == null || hPort == 0) {
            Object[] params = new Object[]{hName, new Integer(hPort)};
            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_INVALID_HOST_PORT, "", params);
        }
        Object[] args = new Object[]{this.hostName, new Integer(this.port), this.userName};
        JournalLogger.logDebugPlus(5, 20, 64, args);
        this.sock = new Socket(hName, hPort);
        if (this.sock == null) {
            Object[] params = new Object[]{hName, new Integer(hPort)};
            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_CONNECT_ERROR, "", params);
        }
        if (this.gTimeout > 0) {
            this.sock.setSoTimeout(this.gTimeout);
        }
        this.ftpOut = new PrintWriter((Writer)new OutputStreamWriter(this.sock.getOutputStream(), this.svrEncoding == null ? EncUtil.getNetEncoding() : this.svrEncoding), true);
        this.ftpIn = new InputStreamReader(this.sock.getInputStream(), this.svrEncoding == null ? EncUtil.getNetEncoding() : this.svrEncoding);
        Object[] args1 = new Object[]{hName, new Integer(hPort)};
        JournalLogger.logDebugPlus(5, 21, 64, args1);
        int cd = this.getPrompt();
        if (cd >= 300) {
            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_WELCOME_MSG_ERR, "", this.message);
        }
        this.connected = true;
    }

    public void disconnect() throws IOException {
        if (this.signon) {
            this.ftpCmd("QUIT");
        }
        this.signon = false;
        if (this.connected) {
            this.sock.close();
        }
        if (this.ssock != null) {
            this.ssock.close();
            this.ssock = null;
        }
        this.connected = false;
    }

    protected void preLogin() throws ftpCException {
    }

    public void login() throws ftpCException, IOException {
        int result = 0;
        if (!this.connected && this.hostName != null && this.port > 0) {
            this.connect();
        }
        if (this.connected && !this.signon) {
            this.preLogin();
            result = this.ftpCmd("USER " + this.userName);
            if (result >= 400) {
                throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_LOGIN_FAILED, "", this.message);
            }
            if (result == 230) {
                this.signon = true;
                this.ftpCmd("TYPE A");
            } else {
                result = this.ftpCmd("PASS " + this.password);
                if (result >= 300 && result != 332) {
                    throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_LOGIN_FAILED, "", this.message);
                }
                if (result == 332 && this.account != null && this.ftpCmd("ACCT " + this.account) >= 300) {
                    throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_LOGIN_FAILED, "", this.message);
                }
                this.signon = true;
                this.ftpCmd("TYPE A");
            }
        }
        this.loginReturnCode = this.getReturnCode();
        this.loginReturnMsg = this.getMessage();
        this.loginLogMsg = this.log.toString();
    }

    void proxyLogin() throws ftpCException, IOException {
        ProxyInputs pi = new ProxyInputs();
        pi.setupProxyInputs();
        int result = 0;
        if (!this.connected && this.hostName != null && this.port > 0) {
            this.connect();
        }
        if (this.connected && !this.signon) {
            if (this.ftpCmd("USER " + pi.username1) >= 400 || (result = this.ftpCmd("PASS " + pi.password1)) >= 230) {
                if (result == 332 && this.account != null) {
                    result = this.ftpCmd("ACCT " + this.account);
                    if (result >= 300) {
                        throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_LOGIN_FAILED, "", this.message);
                    }
                } else {
                    if (pi.site != null && this.ftpCmd("SITE " + pi.site) >= 400) {
                        throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_SITE_FAILED, "", this.message);
                    }
                    if (pi.open != null && this.ftpCmd("OPEN " + pi.open) >= 400) {
                        throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_OPEN_FAILED, "", this.message);
                    }
                    if (pi.username2 != null && pi.password2 != null && (this.ftpCmd("USER " + pi.username2) >= 400 || (result = this.ftpCmd("PASS " + pi.password2)) >= 300)) {
                        if (result == 332 && this.account != null && this.ftpCmd("ACCT " + this.account) >= 300) {
                            result = 0;
                        } else {
                            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_LOGIN_FAILED, "", this.message);
                        }
                    }
                }
            }
            this.signon = true;
            this.ftpCmd("TYPE A");
        }
    }

    boolean hasServerSocket() throws ftpCException, IOException {
        if (this.ssock != null) {
            this.ssock.close();
            this.ssock = null;
        }
        this.ssock = this.createServerSocket(this.dataport);
        InetAddress localhost = this.sock.getLocalAddress();
        String portCmd = this.buildPortCmd(localhost, (short)this.ssock.getLocalPort());
        JournalLogger.logDebugPlus(5, 22, 64, portCmd);
        this.log.append("--> " + portCmd + "\n");
        if (this.ftpCmd(portCmd) > 300) {
            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_PORT_FAILED, "", this.message);
        }
        return true;
    }

    protected void acceptDataConnection() throws IOException {
        int tmout = 30000;
        try {
            tmout = Long.valueOf(Config.getProperty("30000", "watt.net.ftpClientDataConnTimeout")).intValue();
        }
        catch (Exception e) {
            tmout = 30000;
        }
        this.ssock.setSoTimeout(tmout);
        this.sk = this.ssock.accept();
    }

    protected void preDataChannelSetup() throws ftpCException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SvrConn(String cmd, String parm1, String parm2, long parm3) throws ftpCException, IOException {
        if (!this.activemode) {
            return this.SvrConnPassive(cmd, parm1, parm2, parm3);
        }
        if (!this.connected) {
            this.connect();
        }
        if (!this.signon) {
            this.login();
        }
        this.sk = null;
        this.preDataChannelSetup();
        if (!this.hasServerSocket()) {
            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_INVALID_DATA_CH, "");
        }
        String parm = parm2 == null || parm2.trim().length() == 0 ? parm1 : parm2;
        int cod = this.ftpCmd(cmd + " " + parm);
        if (this.aborted) {
            return false;
        }
        if (cod > 300) {
            if (this.ssock != null) {
                this.ssock.close();
                this.ssock = null;
            }
            return false;
        }
        if (cod == 202) {
            this.rc = 202;
            if (this.ssock != null) {
                this.ssock.close();
                this.ssock = null;
            }
            return false;
        }
        try {
            this.acceptDataConnection();
            if (this.gTimeout > 0) {
                this.sk.setSoTimeout(this.gTimeout);
            }
        }
        catch (Exception se) {
            if (this.ssock != null) {
                this.ssock.close();
            }
            this.ssock = null;
            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_ACCEPT_ERR, "", se.toString());
        }
        try {
            if (cmd.compareTo("STOR") == 0 || cmd.compareTo("STOU") == 0 || cmd.compareTo("APPE") == 0) {
                this.ftpSend();
            } else {
                this.ftpReceive("RETR".equals(cmd), parm3);
            }
        }
        finally {
            this.sk.close();
            this.ssock.close();
        }
        if (this.aborted) {
            this.message = "Command timed out";
            return false;
        }
        this.rc = this.getPrompt();
        return this.rc <= 300;
    }

    boolean SvrConnPassive(String cmd, String parm1, String parm2, long parm3) throws ftpCException, IOException {
        String pasvCmd = "PASV";
        if (!this.connected) {
            this.connect();
        }
        if (!this.signon) {
            this.login();
        }
        JournalLogger.logDebugPlus(5, 22, 64, pasvCmd);
        this.log.append("--> " + pasvCmd + "\n");
        this.preDataChannelSetup();
        if (this.ftpCmd(pasvCmd) > 300) {
            return false;
        }
        int indexe = this.message.lastIndexOf(41);
        int indexs = this.message.lastIndexOf(40, indexe);
        String str = this.message.substring(indexs + 1, indexe);
        StringTokenizer strTok = new StringTokenizer(str, ",");
        String strServerIP = strTok.nextToken() + "." + strTok.nextToken() + "." + strTok.nextToken() + "." + strTok.nextToken();
        int listenPort = Integer.parseInt(strTok.nextToken().trim()) * 256 + Integer.parseInt(strTok.nextToken().trim());
        try {
            boolean retry = true;
            try {
                if ("true".equals(Config.getProperty("false", "watt.server.ftp.usecommandip"))) {
                    JournalLogger.logDebugPlus(5, 28, 64, new Object[]{strServerIP, this.hostName});
                    retry = false;
                    this.sk = this.createClientSocket(this.hostName, listenPort);
                } else {
                    this.sk = this.createClientSocket(strServerIP, listenPort);
                }
            }
            catch (IOException originalException) {
                if (!retry) {
                    throw originalException;
                }
                try {
                    JournalLogger.logDebugPlus(5, 28, 64, new Object[]{strServerIP, this.hostName});
                    this.sk = this.createClientSocket(this.hostName, listenPort);
                }
                catch (IOException ioe) {
                    throw originalException;
                }
            }
            if (this.gTimeout > 0) {
                this.sk.setSoTimeout(this.gTimeout);
            }
        }
        catch (IOException ioe) {
            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_CONNECT_ERROR, "", ioe.getMessage());
        }
        String parm = parm2 == null || parm2.trim().length() == 0 ? parm1 : parm2;
        int cod = this.ftpCmd(cmd + " " + parm);
        if (cod > 300) {
            try {
                this.sk.close();
            }
            catch (IOException ioe2) {
                throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_SOCKET_CLOSE_ERR, "", ioe2.getMessage());
            }
            return false;
        }
        if (cod == 202) {
            this.rc = 202;
            try {
                this.sk.close();
            }
            catch (IOException e) {
                throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_SOCKET_CLOSE_ERR, "", e.getMessage());
            }
        }
        if (cmd.compareTo("STOR") == 0 || cmd.compareTo("STOU") == 0 || cmd.compareTo("APPE") == 0) {
            this.ftpSend();
        } else {
            this.ftpReceive("RETR".equals(cmd), parm3);
        }
        this.rc = this.getPrompt();
        return this.rc <= 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ftpSend() throws IOException, ftpCException {
        try {
            this.update(true);
            BufferedOutputStream outs = new BufferedOutputStream(this.sk.getOutputStream(), 1024);
            if (this.usrData instanceof byte[]) {
                this.sendBytes(outs, (byte[])this.usrData);
            } else if (this.usrData instanceof String) {
                if (this.encoding == null) {
                    this.sendBytes(outs, EncUtil.getNetBytes((String)this.usrData));
                } else {
                    this.sendBytes(outs, ((String)this.usrData).getBytes(this.encoding));
                }
            } else if (this.usrData instanceof InputStream) {
                InputStream instream = (InputStream)this.usrData;
                int prev = 0;
                if (this.mode == 'A') {
                    int c = -1;
                    try {
                        c = instream.read();
                    }
                    catch (EOFException eofe) {
                        JournalLogger.logDebugPlus(5, 9998, 64, eofe);
                        c = -1;
                    }
                    while (c >= 0) {
                        if (c == 10 && prev != 13) {
                            ((OutputStream)outs).write(13);
                        }
                        prev = c;
                        ((OutputStream)outs).write(c);
                        try {
                            c = instream.read();
                        }
                        catch (EOFException eofe) {
                            JournalLogger.logDebugPlus(5, 9998, 64, eofe);
                            c = -1;
                        }
                    }
                } else {
                    try {
                        byte[] buffer = new byte[1024];
                        int length = instream.read(buffer);
                        while (length > 0) {
                            ((OutputStream)outs).write(buffer, 0, length);
                            length = instream.read(buffer);
                        }
                    }
                    catch (EOFException eofe) {
                        JournalLogger.logDebugPlus(5, 9998, 64, eofe);
                    }
                }
                instream.close();
            } else {
                throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_FTP_SEND_ERR, "");
            }
            ((OutputStream)outs).close();
        }
        finally {
            this.update(false);
        }
    }

    private void sendBytes(OutputStream outstream, byte[] data) throws IOException {
        if (this.mode == 'A') {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == 10 && i > 1 && data[i - 1] != 13) {
                    outstream.write(13);
                }
                outstream.write(data[i]);
            }
        } else {
            outstream.write(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ftpReceive(boolean handleLargeFile, long largeFileThreshold) throws IOException {
        try {
            this.update(true);
            InputStream ins = this.sk.getInputStream();
            this.rcvData = null;
            if (this.mode == 'A' && this.cleanLineFeeds) {
                this.ftpReceiveAscii(ins, this.localfile, handleLargeFile, largeFileThreshold);
                return;
            }
            if (this.localfile != null && this.localfile.length() > 0) {
                BufferedOutputStream outstream = new BufferedOutputStream(new FileOutputStream(this.localfile), 1024);
                byte[] buffer = new byte[1024];
                try {
                    int length = ins.read(buffer);
                    while (length > 0) {
                        outstream.write(buffer, 0, length);
                        length = ins.read(buffer);
                    }
                }
                catch (EOFException eofe) {
                    JournalLogger.logDebugPlus(5, 9998, 64, eofe);
                }
                catch (InterruptedIOException timedout) {
                    this.abort();
                }
                outstream.close();
                this.localfile = null;
            } else {
                this.rcvData = handleLargeFile && largeFileThreshold > -1L ? FTPSession.streamToBytesOrReservationStream(ins, largeFileThreshold) : (Object)FTPSession.streamToBytes(ins);
            }
            ins.close();
        }
        finally {
            this.update(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ftpReceiveAscii(InputStream ins, String localPath, boolean handleLargeFile, long largeFileThreshold) throws IOException {
        block26: {
            try {
                if (localPath != null && localPath.length() > 0) {
                    File localFile = new File(localPath);
                    FileOutputStream out = new FileOutputStream(localFile);
                    BufferedReader in = new BufferedReader(new InputStreamReader(ins, "ISO-8859-1"));
                    try {
                        int ch = -1;
                        while ((ch = this.read(in)) != -1) {
                            if (ch == 10) {
                                byte[] bytes = lineSeparator.getBytes();
                                out.write(bytes, 0, bytes.length);
                                continue;
                            }
                            out.write(ch);
                        }
                        break block26;
                    }
                    catch (EOFException eofe) {
                        JournalLogger.logDebugPlus(5, 9998, 64, eofe);
                        break block26;
                    }
                    catch (IOException ex) {
                        if (localFile != null) {
                            localFile.delete();
                        }
                        throw ex;
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
                this.rcvData = handleLargeFile && largeFileThreshold > -1L ? this.streamToBytesOrReservationStreamAscii(ins, largeFileThreshold) : (Object)this.streamToBytesAscii(ins);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    protected int read(BufferedReader in) throws IOException {
        int c = -1;
        try {
            c = in.read();
        }
        catch (EOFException eofe) {
            JournalLogger.logDebugPlus(5, 9998, 64, eofe);
            c = -1;
        }
        if (this.skipLF) {
            try {
                if (c == 10) {
                    c = in.read();
                }
                this.skipLF = false;
            }
            catch (EOFException eofe) {
                this.skipLF = false;
                JournalLogger.logDebugPlus(5, 9998, 64, eofe);
                c = -1;
                try {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        switch (c) {
            case 13: {
                this.skipLF = true;
            }
            case 10: {
                return 10;
            }
        }
        return c;
    }

    public void setEncoding(String enc) {
        this.encoding = EncodingNames.getJavaName(enc);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setCleanLineFeeds(boolean val) {
        this.cleanLineFeeds = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPrompt() throws IOException {
        String msg = null;
        int code = -1;
        this.message = null;
        try {
            this.update(true);
            do {
                try {
                    msg = this.ftpIn != null ? this.readLine(this.ftpIn.getEncoding()) : this.readLine("8859_1");
                    if (!this.multiline) {
                        this.checkMultiline(msg);
                    }
                }
                catch (EOFException eofe) {
                    JournalLogger.logDebugPlus(5, 9998, 64, eofe);
                }
                catch (InterruptedIOException timedout) {
                    this.abort();
                }
                catch (SocketException se) {
                    this.message = "Lost connection to FTP Server";
                    msg = null;
                }
                catch (IOException eofe) {
                    JournalLogger.logDebugPlus(5, 9998, 64, eofe);
                }
                if (this.aborted) {
                    int eofe = 600;
                    return eofe;
                }
                if (msg == null) {
                    this.forceDisconnect();
                    int eofe = 600;
                    return eofe;
                }
                if (msg.length() == 0) continue;
                if (code == -1) {
                    try {
                        String str_code = msg.substring(0, 3);
                        if (str_code.trim().length() < 3) {
                            this.forceDisconnect();
                            this.message = "Invalid code returned from FTP server " + str_code.trim();
                            code = 600;
                            break;
                        }
                        code = Integer.parseInt(str_code.trim());
                    }
                    catch (NumberFormatException nfe) {
                        JournalLogger.logDebugPlus(1, 23, 64, nfe.toString());
                        this.forceDisconnect();
                        code = 600;
                        break;
                    }
                    catch (StringIndexOutOfBoundsException obe) {
                        JournalLogger.logDebugPlus(1, 23, 64, obe.toString());
                        this.forceDisconnect();
                        code = 600;
                        break;
                    }
                }
                this.message = this.message == null ? msg : this.message + "\n" + msg;
                JournalLogger.logDebugPlus(5, 24, 64, msg);
            } while (!this.endOfReply(msg, code));
            this.multiline = false;
            this.log.append("<-- " + this.message + "\n");
            int n = code;
            return n;
        }
        finally {
            this.update(false);
        }
    }

    private String readLine(String charset) throws IOException {
        String ret = null;
        if (this.socketInputStream != null) {
            boolean loop = true;
            boolean text = false;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int c = 0;
            while (loop) {
                try {
                    c = this.socketInputStream.read();
                }
                catch (EOFException eofe) {
                    JournalLogger.logDebugPlus(5, 9998, 64, eofe);
                    c = -1;
                }
                if (c == 10) {
                    text = true;
                    loop = false;
                    continue;
                }
                if (c == 13) {
                    text = true;
                    this.socketInputStream.mark(1);
                    try {
                        c = this.socketInputStream.read();
                    }
                    catch (EOFException eofe) {
                        JournalLogger.logDebugPlus(5, 9998, 64, eofe);
                        c = -1;
                    }
                    if (c != 10) {
                        this.socketInputStream.reset();
                    }
                    loop = false;
                    continue;
                }
                if (c == -1) {
                    loop = false;
                    continue;
                }
                text = true;
                bos.write(c);
            }
            if (bos.size() == 0) {
                ret = null;
            } else {
                ret = bos.toString(charset);
                if (ret != null && ret.length() == 0 && !text) {
                    ret = null;
                }
            }
            if (this.multiline && (ret == null || ret.length() == 0) && c != -1) {
                ret = " ";
            }
        } else {
            ret = new String();
        }
        return ret;
    }

    private void checkMultiline(String ret) {
        if (ret != null && ret.trim().length() >= 4 && Character.isDigit(ret.trim().charAt(0)) && Character.isDigit(ret.trim().charAt(1)) && Character.isDigit(ret.trim().charAt(2)) && ret.trim().charAt(3) == '-') {
            this.multiline = true;
        }
    }

    protected void forceDisconnect() {
        try {
            this.ftpIn.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ftpOut.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.ftpIn = null;
        this.ftpOut = null;
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.sock = null;
        }
        if (this.ssock != null) {
            try {
                this.ssock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ssock = null;
        }
        this.signon = false;
        this.connected = false;
    }

    private boolean endOfReply(String reply, int code) {
        int reply_code;
        boolean result = false;
        if (reply != null && reply.length() >= 4 && Character.isDigit(reply.charAt(0)) && Character.isDigit(reply.charAt(1)) && Character.isDigit(reply.charAt(2)) && reply.charAt(3) == ' ' && code == (reply_code = Integer.parseInt(reply.substring(0, 3)))) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ftpCmd(String cmd) throws IOException {
        try {
            this.update(true);
            this.lastCmd = cmd.substring(0, 4);
            if (!this.lastCmd.equals("ABOR")) {
                this.aborted = false;
            }
            if (cmd.indexOf("TYPE") == 0) {
                this.mode = cmd.charAt(5);
            }
            cmd = cmd.trim() + "\r\n";
            this.ftpOut.print(cmd);
            this.ftpOut.flush();
            if (cmd.substring(0, 4).toUpperCase().compareTo("PASS") == 0) {
                this.log.append("--> PASS XXXXXXXX\n");
                JournalLogger.logDebugPlus(5, 25, 64);
            } else {
                this.log.append("--> " + cmd + "\n");
                JournalLogger.logDebugPlus(5, 26, 64, cmd);
            }
            this.rc = this.getPrompt();
        }
        finally {
            this.update(false);
        }
        return this.rc;
    }

    public int quoteCmd(String cmd) throws IOException {
        cmd = cmd.trim() + "\r\n";
        this.ftpOut.print(cmd);
        this.ftpOut.flush();
        this.rc = this.getPrompt();
        return this.rc;
    }

    void resetFTPC() throws IOException {
        this.disconnect();
    }

    public void resetLoginCache() {
        this.log = new StringBuffer(1024);
        this.log.append(this.loginLogMsg);
        this.message = this.loginReturnMsg;
        this.rc = this.loginReturnCode;
    }

    public Object getRcvData() {
        return this.rcvData;
    }

    public String getLog() {
        String logString = this.log.toString();
        this.log = new StringBuffer(1024);
        return logString;
    }

    public int getReturnCode() {
        return this.rc;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isConnected() {
        if (!"1.3.0".equals(System.getProperty("java.version")) && this.connected) {
            try {
                if (this.ftpIn.ready() && this.getPrompt() == 421) {
                    this.connected = false;
                    this.signon = false;
                }
            }
            catch (IOException e) {
                this.connected = false;
                this.signon = false;
            }
        }
        return this.connected;
    }

    public boolean isSignedOn() {
        return this.signon;
    }

    public void setLocalFile(String fname) {
        this.localfile = fname;
    }

    private static byte[] streamToBytes(InputStream ins) throws IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int n = -1;
        try {
            n = ins.read(buffer);
            while (n > 0) {
                bo.write(buffer, 0, n);
                n = ins.read(buffer);
            }
        }
        catch (EOFException eofe) {
            JournalLogger.logDebugPlus(5, 9998, 64, eofe);
        }
        byte[] content = bo.toByteArray();
        bo.close();
        return content;
    }

    private static Object streamToBytesOrReservationStream(InputStream ins, long largeFileThreshold) throws IOException {
        byte[] bytes = new byte[1024];
        long totalBytes = 0L;
        int bytesRead = -1;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bytesRead = ins.read(bytes);
            while (bytesRead >= 0) {
                bos.write(bytes, 0, bytesRead);
                if ((totalBytes += (long)bytesRead) <= largeFileThreshold) {
                    bytesRead = -1;
                    bytesRead = ins.read(bytes);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eofe) {
            JournalLogger.logDebugPlus(5, 9998, 64, eofe);
        }
        if (totalBytes <= largeFileThreshold) {
            return bos.toByteArray();
        }
        OutputStream os = null;
        try {
            totalBytes = bos.size();
            ReservationAgent ra = ReservationAgent.current();
            Reservation r = ra.createReservation(totalBytes);
            os = r.getOutputStream();
            os.write(bos.toByteArray(), 0, bos.size());
            bytesRead = -1;
            try {
                bytesRead = ins.read(bytes);
                while (bytesRead >= 0) {
                    ra.resizeReservation(r, totalBytes += (long)bytesRead);
                    os.write(bytes, 0, bytesRead);
                    bytesRead = -1;
                    bytesRead = ins.read(bytes);
                }
            }
            catch (EOFException eofe) {
                JournalLogger.logDebugPlus(5, 9998, 64, eofe);
            }
            InputStream inputStream = r.getInputStream();
            return inputStream;
        }
        catch (ReservationException e) {
            if (e instanceof InsufficientSpaceException) {
                throw new IOException("Not enough storage space in tspace.");
            }
            if (e instanceof ReservationInitException) {
                throw new IOException("Not able to initialize tspace.");
            }
            throw new IOException(e.getMessage());
        }
        finally {
            ins.close();
            if (os != null) {
                os.flush();
                os.close();
            }
        }
    }

    private byte[] streamToBytesAscii(InputStream ins) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        BufferedReader in = new BufferedReader(new InputStreamReader(ins, "ISO-8859-1"));
        int ch = -1;
        try {
            while ((ch = this.read(in)) != -1) {
                if (ch == 10) {
                    byte[] bytes = lineSeparator.getBytes();
                    out.write(bytes, 0, bytes.length);
                    continue;
                }
                out.write(ch);
            }
        }
        catch (EOFException eofe) {
            JournalLogger.logDebugPlus(5, 9998, 64, eofe);
        }
        byte[] content = out.toByteArray();
        out.close();
        return content;
    }

    private Object streamToBytesOrReservationStreamAscii(InputStream ins, long largeFileThreshold) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        BufferedReader in = new BufferedReader(new InputStreamReader(ins, "iso8859_1"));
        long totalBytes = 0L;
        int ch = -1;
        try {
            while ((ch = this.read(in)) != -1) {
                if (ch == 10) {
                    byte[] bytes = lineSeparator.getBytes();
                    out.write(bytes, 0, bytes.length);
                    totalBytes += (long)bytes.length;
                } else {
                    out.write(ch);
                    ++totalBytes;
                }
                if (totalBytes <= largeFileThreshold) continue;
                break;
            }
        }
        catch (EOFException eofe) {
            JournalLogger.logDebugPlus(5, 9998, 64, eofe);
        }
        if (totalBytes <= largeFileThreshold) {
            return out.toByteArray();
        }
        try {
            totalBytes = out.size();
            ReservationAgent ra = ReservationAgent.current();
            Reservation r = ra.createReservation(totalBytes);
            OutputStream os = r.getOutputStream();
            os.write(out.toByteArray(), 0, out.size());
            try {
                while ((ch = this.read(in)) != -1) {
                    if (ch == 10) {
                        byte[] bytes = lineSeparator.getBytes();
                        ra.resizeReservation(r, totalBytes += (long)bytes.length);
                        os.write(bytes, 0, bytes.length);
                        continue;
                    }
                    ra.resizeReservation(r, ++totalBytes);
                    os.write(ch);
                }
            }
            catch (EOFException eofe) {
                JournalLogger.logDebugPlus(5, 9998, 64, eofe);
            }
            ins.close();
            out.close();
            os.flush();
            os.close();
            return r.getInputStream();
        }
        catch (ReservationException e) {
            if (e instanceof InsufficientSpaceException) {
                throw new IOException("Not enough storage space in tspace.");
            }
            if (e instanceof ReservationInitException) {
                throw new IOException("Not able to initialize tspace.");
            }
            throw new IOException(e.getMessage());
        }
    }

    public boolean cmdAborted() {
        return this.aborted;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long tmout) {
        this.idleTimeout = tmout;
    }

    public long getLast() {
        return this.lastCall;
    }

    public void setLast(long val) {
        if (val != this.lastCall) {
            this.lastCall = val;
        }
    }

    public int getCalls() {
        return this.calls;
    }

    public void setCalls(int val) {
        if (this.calls != val) {
            this.calls = val;
        }
    }

    public synchronized void update(boolean _busy) {
        ++this.calls;
        this.lastCall = System.currentTimeMillis();
        this.busy = _busy;
    }

    private void abort() {
        if (this.lastCmd.equals("ABOR")) {
            return;
        }
        if (this.isConnected()) {
            this.aborted = true;
            try {
                this.ftpCmd("ABOR");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private short toUnsignedShort(byte value) {
        return value < 0 ? (short)(value + 256) : (short)value;
    }

    private byte[] toByteArray(short value) {
        byte[] bytes = new byte[]{(byte)(value >> 8), (byte)(value & 0xFF)};
        return bytes;
    }

    private String buildPortCmd(InetAddress host, short portNo) throws IOException {
        byte[] hostBytes = host.getAddress();
        byte[] portBytes = this.toByteArray(portNo);
        String cmd = new StringBuffer("PORT ").append(this.toUnsignedShort(hostBytes[0])).append(",").append(this.toUnsignedShort(hostBytes[1])).append(",").append(this.toUnsignedShort(hostBytes[2])).append(",").append(this.toUnsignedShort(hostBytes[3])).append(",").append(this.toUnsignedShort(portBytes[0])).append(",").append(this.toUnsignedShort(portBytes[1])).toString();
        return cmd;
    }

    public int getDataport() {
        return this.dataport;
    }

    static {
        usingProxy = false;
        noProxyHosts = new Hashtable();
        noProxyWildcardHosts = new Hashtable();
        lastSkipList = null;
        noProxyHosts.put("localhost", "localhost");
    }

    class ProxyInputs {
        String username1;
        String password1;
        String username2;
        String password2;
        String site;
        String open;

        ProxyInputs() {
        }

        private void setupProxyInputs() {
            this.open = null;
            this.site = null;
            this.password2 = null;
            this.password1 = null;
            this.username2 = null;
            this.username1 = null;
            switch (type) {
                case 1: {
                    this.username1 = FTPSession.this.userName + "@" + FTPSession.this.hostName;
                    if (FTPSession.this.port != 21 || FTPSession.this.port == 0) {
                        this.username1 = this.username1 + ":" + FTPSession.this.port;
                    }
                    this.password1 = FTPSession.this.password;
                    break;
                }
                case 2: {
                    this.username1 = proxyUser;
                    this.password1 = proxyPass;
                    this.username2 = FTPSession.this.userName + "@" + FTPSession.this.hostName;
                    this.password2 = FTPSession.this.password;
                    break;
                }
                case 3: {
                    this.username1 = proxyUser;
                    this.password1 = proxyPass;
                    this.site = FTPSession.this.hostName;
                    this.username2 = FTPSession.this.userName;
                    this.password2 = FTPSession.this.password;
                    break;
                }
                case 4: {
                    this.username1 = proxyUser;
                    this.password1 = proxyPass;
                    this.open = FTPSession.this.hostName;
                    this.username2 = FTPSession.this.userName;
                    this.password2 = FTPSession.this.password;
                    break;
                }
                case 5: {
                    this.username1 = FTPSession.this.userName + "@" + proxyUser + "@" + FTPSession.this.hostName;
                    this.password1 = FTPSession.this.password + "@" + proxyPass;
                    break;
                }
                case 6: {
                    this.username1 = proxyUser + "@" + FTPSession.this.hostName;
                    this.password1 = proxyPass;
                    this.username2 = FTPSession.this.userName;
                    this.password2 = FTPSession.this.password;
                }
            }
        }
    }
}

