/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.ext.iaik.IaikSecureSocket;
import com.wm.net.FTPSession;
import com.wm.net.ftpCException;
import com.wm.net.resources.FtpExceptionBundle;
import com.wm.security.wmTrustDecider;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SSLSocket;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public final class FTPSSession
extends FTPSession {
    public static final String AUTH_SSL = "SSL";
    public static final String AUTH_TLS = "TLS";
    public static final String AUTH_TLSP = "TLS-P";
    boolean controlSecured = false;
    boolean secureDataChannel = false;
    boolean dataSecured = false;
    boolean sentProtCmdOnce = false;
    String authMechanism = "SSL";
    SSLServerContext context = null;
    wmTrustDecider trustDecider = null;
    IaikSecureSocket clientSockProv = null;
    static boolean sslDebug = false;

    public FTPSSession(String serverhost, int serverport, String username, String passwd, int dport, boolean active, int timeout, boolean secureDataChannel) throws ftpCException, IOException {
        this(serverhost, serverport, username, passwd, null, dport, active, timeout, null, null, secureDataChannel, AUTH_TLS);
    }

    public FTPSSession(String serverhost, int serverport, String username, String passwd, int dport, boolean active, int timeout, String enc, boolean secureDataChannel) throws ftpCException, IOException {
        this(serverhost, serverport, username, passwd, null, dport, active, timeout, enc, null, secureDataChannel, AUTH_TLS);
    }

    public FTPSSession(String serverhost, int serverport, String username, String passwd, String acct, int dport, boolean active, int timeout, String enc, boolean secureDataChannel) throws ftpCException, IOException {
        this(serverhost, serverport, username, passwd, acct, dport, active, timeout, enc, null, secureDataChannel, AUTH_TLS);
    }

    public FTPSSession(String serverhost, int serverport, String username, String passwd, String acct, int dport, boolean active, int timeout, String enc, String svrEnc, boolean secureDataChannel, String authMechanism) throws ftpCException, IOException {
        this.authMechanism = authMechanism;
        this.secureDataChannel = AUTH_TLSP.equals(authMechanism) ? true : secureDataChannel;
        this.setupSSL();
        this.init(serverhost, serverport, username, passwd, acct, dport, active, timeout, enc, svrEnc);
    }

    void setupProxy() {
        usingProxy = false;
    }

    Socket createSocket(String server, int port) throws IOException {
        return this.clientSockProv.newSocket(server, port);
    }

    ServerSocket createServerSocket(int port) throws IOException {
        if (!this.dataSecured) {
            return super.createServerSocket(port);
        }
        ServerSocket s = this.clientSockProv.newServerSocket(port);
        return s;
    }

    Socket createClientSocket(String host, int port) throws IOException {
        try {
            if (!this.dataSecured) {
                return super.createClientSocket(host, port);
            }
            Socket sslsock = this.clientSockProv.newSocket(host, port);
            ((SSLSocket)sslsock).setUseClientMode(true);
            ((SSLSocket)sslsock).setAutoHandshake(true);
            return sslsock;
        }
        catch (IOException ioe) {
            JournalLogger.logDebugPlus(5, 9998, 64, ioe);
            throw ioe;
        }
    }

    private void setupSSL() {
        this.clientSockProv = new IaikSecureSocket();
        this.clientSockProv.setup();
        this.clientSockProv.setRandomGenerator(this.clientSockProv.newRandomGenerator());
        this.clientSockProv.setAutoHandshake(false);
        this.context = new SSLServerContext();
        if (sslDebug) {
            this.context.setDebugStream((OutputStream)System.out);
        }
    }

    public void secureControlChannel() throws ftpCException {
        try {
            int returnCode = this.ftpCmd("AUTH " + this.authMechanism);
            if (returnCode != 234) {
                throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_AUTH_CMD_ERR, "", Integer.toString(returnCode));
            }
            ((SSLSocket)this.sock).startHandshake();
        }
        catch (IOException e) {
            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_SSL_SETUP_ERR, "", " : " + e.getMessage());
        }
        this.controlSecured = true;
    }

    public void secureDataChannel() throws ftpCException {
        if (this.dataSecured == this.secureDataChannel && this.sentProtCmdOnce) {
            return;
        }
        String protCmd = "PROT P";
        if (!this.secureDataChannel) {
            protCmd = "PROT C";
        }
        try {
            int returnCode = this.ftpCmd("PBSZ 0");
            if (returnCode >= 300) {
                throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_PBSZ_CMD_ERROR, "", Integer.toString(returnCode));
            }
            returnCode = this.ftpCmd(protCmd);
            if (returnCode >= 300) {
                throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_PROT_CMD_ERROR, "", Integer.toString(returnCode));
            }
            this.dataSecured = this.secureDataChannel;
            this.sentProtCmdOnce = true;
        }
        catch (IOException e) {
            throw new ftpCException(FtpExceptionBundle.class, FtpExceptionBundle.FTP_LOGIN_FAILED, "", "[PROT] " + e.getMessage());
        }
    }

    public void disconnect() throws IOException {
        super.disconnect();
        this.dataSecured = false;
        this.controlSecured = false;
    }

    protected void preLogin() throws ftpCException {
        this.secureControlChannel();
    }

    protected void acceptDataConnection() throws IOException {
        try {
            int tmout = 30000;
            try {
                tmout = Long.valueOf(Config.getProperty("30000", "watt.net.ftpClientDataConnTimeout")).intValue();
            }
            catch (Exception e) {
                tmout = 30000;
            }
            this.ssock.setSoTimeout(tmout);
            this.sk = this.ssock.accept();
            if (this.dataSecured) {
                ((SSLSocket)this.sk).setUseClientMode(true);
                ((SSLSocket)this.sk).setAutoHandshake(true);
                ((SSLSocket)this.sk).startHandshake();
            }
        }
        catch (IOException ioe) {
            JournalLogger.logDebugPlus(5, 9998, 64, ioe);
            throw ioe;
        }
    }

    protected void preDataChannelSetup() throws ftpCException {
        this.secureDataChannel();
    }

    protected void forceDisconnect() {
        super.forceDisconnect();
        this.controlSecured = false;
        this.dataSecured = false;
    }

    static {
        sslDebug = Boolean.getBoolean("watt.ssl.iaik.debug");
    }
}

