/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.util.Config;
import com.wm.util.EncUtil;
import com.wm.util.List;
import com.wm.util.Values;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class EncodeURL {
    static BitSet dontNeedEncoding;
    static boolean encodeToUpperCase;

    private EncodeURL() {
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static String encode(String s) {
        String ret = null;
        try {
            ret = EncodeURL.encode(s, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        return EncodeURL.encode(s, enc, false);
    }

    public static String encode(String s, String enc, boolean dontEncodeAscii) throws UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        for (int i = 0; i < s.length(); ++i) {
            int j;
            int c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                if (c == 32) {
                    c = 43;
                }
                out.write(c);
                continue;
            }
            if (dontEncodeAscii && c > 33 && c < 127) {
                out.write(c);
                continue;
            }
            String s1 = s.substring(i, i + 1);
            byte[] ba = enc == null || enc.length() == 0 ? EncUtil.getNetBytes(s1) : s1.getBytes(enc);
            if (encodeToUpperCase) {
                for (j = 0; j < ba.length; ++j) {
                    out.write(37);
                    out.write(Character.toUpperCase(Character.forDigit(ba[j] >> 4 & 0xF, 16)));
                    out.write(Character.toUpperCase(Character.forDigit(ba[j] & 0xF, 16)));
                }
                continue;
            }
            for (j = 0; j < ba.length; ++j) {
                out.write(37);
                out.write(Character.toLowerCase(Character.forDigit(ba[j] >> 4 & 0xF, 16)));
                out.write(Character.toLowerCase(Character.forDigit(ba[j] & 0xF, 16)));
            }
        }
        if (enc == null) {
            return out.toString(EncUtil.getURLEncoding());
        }
        return out.toString();
    }

    public static String decode(String s) {
        String ret = null;
        try {
            ret = EncodeURL.decode(s, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        byte[] b;
        String ret = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        if (enc != null) {
            b = s.getBytes(enc);
        } else {
            enc = EncUtil.getNetEncoding();
            b = s.getBytes(enc);
        }
        Object bout = null;
        ret = EncodeURL.unescape(b, enc);
        if (ret == null) {
            if (!EncUtil.getURLEncoding().equalsIgnoreCase(enc)) {
                enc = EncUtil.getURLEncoding();
                b = s.getBytes(enc);
                ret = EncodeURL.unescape(b, enc);
            }
            if (ret == null) {
                enc = null;
                b = s.getBytes();
                ret = EncodeURL.unescape(b);
                if (ret == null) {
                    enc = "8859_1";
                    b = s.getBytes(enc);
                    ret = EncodeURL.unescape(b, enc);
                }
            }
        }
        return ret;
    }

    public static String encode(String[][] nvpairs) {
        String ret = null;
        try {
            ret = EncodeURL.encode(nvpairs, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String encode(String[][] nvpairs, String enc) throws UnsupportedEncodingException {
        StringBuffer code = new StringBuffer();
        int numVals = 0;
        if (nvpairs != null) {
            for (int i = 0; i < nvpairs.length; ++i) {
                String[] arg = nvpairs[i];
                String key = arg[0];
                String val = arg[1];
                if (val == null) {
                    if (numVals++ > 0) {
                        code.append('&');
                    }
                    code.append(EncodeURL.encode(key));
                    continue;
                }
                if (key == null || key.length() == 0) {
                    if (numVals++ > 0) {
                        code.append('&');
                    }
                    code.append(EncodeURL.encode(val, enc));
                    continue;
                }
                if (numVals++ > 0) {
                    code.append('&');
                }
                code.append(EncodeURL.encode(key, enc) + '=' + EncodeURL.encode(val, enc));
            }
        }
        if (code.length() == 0) {
            return "";
        }
        return code.toString();
    }

    public static String encode(Values pairs) {
        String ret = null;
        try {
            ret = EncodeURL.encode(pairs, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String encode(Values pairs, String enc) throws UnsupportedEncodingException {
        StringBuffer code = new StringBuffer();
        int numVals = 0;
        if (pairs != null) {
            Enumeration e = pairs.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key == null) continue;
                numVals = EncodeURL.appendValue(code, numVals, key, pairs.get(key), enc);
            }
        }
        if (code.length() == 0) {
            return "";
        }
        return code.toString();
    }

    public static String encode(IData pairs, String enc) throws UnsupportedEncodingException {
        StringBuffer code = new StringBuffer();
        int numVals = 0;
        if (pairs != null) {
            IDataCursor cursor = pairs.getCursor();
            while (cursor.next()) {
                String key = cursor.getKey();
                if (key == null) continue;
                numVals = EncodeURL.appendValue(code, numVals, key, cursor.getValue(), enc);
            }
            cursor.destroy();
        }
        if (code.length() == 0) {
            return "";
        }
        return code.toString();
    }

    public static String encode(Values pairs, String[][] nvpairs, String urlString) {
        String ret = null;
        try {
            ret = EncodeURL.encode(pairs, nvpairs, urlString, null);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return ret;
    }

    public static String encode(Values pairs, String[][] nvpairs, String urlString, String enc) throws UnsupportedEncodingException {
        return EncodeURL.encode((IData)pairs, nvpairs, urlString, enc);
    }

    public static String encode(IData pairs, String[][] nvpairs, String urlString, String enc) throws UnsupportedEncodingException {
        return EncodeURL.encode(pairs, nvpairs, urlString, enc, false);
    }

    public static String encode(IData pairs, String[][] nvpairs, String urlString, String enc, boolean encodeUrlString) throws UnsupportedEncodingException {
        StringBuffer code = new StringBuffer();
        int numVals = 0;
        if (pairs != null) {
            IDataCursor id = pairs.getCursor();
            while (id.next()) {
                String key = id.getKey();
                if (key == null) continue;
                numVals = EncodeURL.appendValue(code, numVals, key, id.getValue(), enc);
            }
            id.destroy();
        }
        if (nvpairs != null) {
            for (int i = 0; i < nvpairs.length; ++i) {
                String[] arg = nvpairs[i];
                String key = arg[0];
                String val = arg[1];
                if (val == null) {
                    if (numVals++ > 0) {
                        code.append('&');
                    }
                    code.append(EncodeURL.encode(key));
                    continue;
                }
                if (key == null || key.length() == 0) {
                    if (numVals++ > 0) {
                        code.append('&');
                    }
                    code.append(EncodeURL.encode(val, enc));
                    continue;
                }
                if (numVals++ > 0) {
                    code.append('&');
                }
                code.append(EncodeURL.encode(key, enc) + '=' + EncodeURL.encode(val, enc));
            }
        }
        if (urlString != null && urlString.length() != 0) {
            if (numVals++ > 0) {
                code.append('&');
            }
            if (encodeUrlString) {
                code.append(EncodeURL.encode(urlString, enc, true));
            } else {
                code.append(urlString);
            }
        }
        if (code.length() == 0) {
            return "";
        }
        return code.toString();
    }

    public static String encode(List keys, List values) {
        String ret = null;
        try {
            ret = EncodeURL.encode(keys, values, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String encode(List keys, List values, String enc) throws UnsupportedEncodingException {
        StringBuffer code = new StringBuffer();
        int numVals = 0;
        if (keys != null && keys.size() > 0) {
            int kSize = keys.size();
            for (int i = 0; i < kSize; ++i) {
                String key = (String)keys.elementAt(i);
                if (key == null) continue;
                numVals = EncodeURL.appendValue(code, numVals, key, values.elementAt(i), enc);
            }
        }
        if (code.length() == 0) {
            return "";
        }
        return code.toString();
    }

    static int appendValue(StringBuffer code, int numVals, String key, Object val, String enc) throws UnsupportedEncodingException {
        if (val == null) {
            if (numVals++ > 0) {
                code.append('&');
            }
            code.append(EncodeURL.encode(key, enc));
            return numVals;
        }
        String[] v = null;
        if (val instanceof String) {
            v = new String[]{(String)val};
        } else if (val instanceof String[]) {
            v = (String[])val;
        } else if (val != null) {
            return numVals;
        }
        for (int i = 0; i < v.length; ++i) {
            if (numVals++ > 0) {
                code.append('&');
            }
            code.append(EncodeURL.encode(key, enc) + '=');
            if (v[i] == null) continue;
            code.append(EncodeURL.encode(v[i], enc));
        }
        return numVals;
    }

    public static Values decodePairs(String urlString) {
        return EncodeURL.decodePairs(urlString, new Values());
    }

    public static Values decodePairs(String urlString, Values pairs) {
        Values ret = null;
        try {
            ret = EncodeURL.decodePairs(urlString, pairs, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static Values decodePairs(String urlString, Values pairs, String enc) throws UnsupportedEncodingException {
        int idx;
        if (pairs == null) {
            pairs = new Values();
        }
        if ((idx = urlString.indexOf(63)) != 0) {
            urlString = urlString.substring(idx + 1, urlString.length());
        }
        StringTokenizer st = new StringTokenizer(urlString, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int div = token.indexOf(61);
            if (div <= 0) continue;
            String tname = EncodeURL.decode(token.substring(0, div), enc);
            String tval = EncodeURL.decode(token.substring(div + 1), enc);
            pairs.put(tname, tval);
        }
        return pairs;
    }

    public static String unescape(byte[] inBytes) throws UnsupportedEncodingException {
        return EncodeURL.unescape(inBytes, null, -1);
    }

    public static String unescape(byte[] inBytes, int upto) throws UnsupportedEncodingException {
        return EncodeURL.unescape(inBytes, null, upto);
    }

    public static String unescape(byte[] inBytes, String enc) throws UnsupportedEncodingException {
        return EncodeURL.unescape(inBytes, enc, -1);
    }

    public static String unescape(byte[] inBytes, String enc, int upto) throws UnsupportedEncodingException {
        if (inBytes == null) {
            return null;
        }
        int len = -1;
        if (upto != -1) {
            String tmp = EncUtil.getString(inBytes, enc);
            if (tmp == null) {
                return null;
            }
            int ndx = tmp.indexOf(upto);
            if (ndx != -1) {
                tmp = tmp.substring(0, ndx);
                len = tmp.getBytes(enc).length;
            }
        }
        if (len == -1) {
            len = inBytes.length;
        }
        byte[] tmpBytes = new byte[inBytes.length];
        int outCount = 0;
        int i = 0;
        while (i < len) {
            char ch = (char)inBytes[i];
            switch (ch) {
                case '%': {
                    try {
                        byte escChar;
                        String hexStr = enc != null ? new String(inBytes, ++i, 2, enc) : new String(inBytes, ++i, 2);
                        ++i;
                        tmpBytes[outCount] = escChar = (byte)Integer.valueOf(hexStr, 16).intValue();
                        break;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                case '+': {
                    tmpBytes[outCount] = 32;
                    break;
                }
                default: {
                    tmpBytes[outCount] = inBytes[i];
                }
            }
            ++i;
            ++outCount;
        }
        if (len != inBytes.length) {
            i = len;
            while (i < inBytes.length) {
                tmpBytes[outCount] = inBytes[i];
                ++i;
                ++outCount;
            }
        }
        byte[] outBytes = new byte[outCount];
        System.arraycopy(tmpBytes, 0, outBytes, 0, outBytes.length);
        return EncUtil.getString(outBytes, enc);
    }

    static {
        int i;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dontNeedEncoding.set(64);
        encodeToUpperCase = Config.getProperty("true", "watt.net.encodeToUpperCase").equals("true");
    }
}

