/*
 * Decompiled with CFR 0.152.
 */
package com.wm.net;

import com.wm.net.NetException;
import com.wm.net.resources.NetExceptionBundle;
import com.wm.util.Config;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailMessage {
    private String smtp_server = null;
    private MimeMessage msg = null;
    private Multipart mp = null;
    private Session rsession = null;

    public EmailMessage(String[] sendto, String from, String subject) throws Exception {
        Properties props = System.getProperties();
        this.smtp_server = Config.getProperty(null, "watt.server.smtpServer");
        if (this.smtp_server == null) {
            this.smtp_server = Config.getProperty(null, "mail.smtp.host");
        } else {
            props.put("mail.smtp.host", this.smtp_server);
        }
        this.rsession = Session.getDefaultInstance((Properties)props, null);
        this.msg = new MimeMessage(this.rsession);
        if (sendto == null || sendto.length == 0) {
            throw new NetException(NetExceptionBundle.class, NetExceptionBundle.EMAIL_NO_RECPT, "");
        }
        InternetAddress[] recipients = new InternetAddress[sendto.length];
        for (int i = 0; i < sendto.length; ++i) {
            if (sendto[i] == null || sendto[i].length() <= 0) continue;
            recipients[i] = new InternetAddress(sendto[i]);
        }
        this.msg.setRecipients(Message.RecipientType.TO, (Address[])recipients);
        if (from != null) {
            InternetAddress addr = new InternetAddress(from);
            this.msg.setFrom((Address)addr);
        } else {
            this.msg.setFrom();
        }
        this.msg.setSubject(subject);
        this.msg.setSentDate(new Date());
    }

    public void addBody(String body) {
        try {
            this.msg.setContent((Object)body, "text/plain");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addAttachment(byte[] bob, String filename) {
        this.addAttachment(bob, filename, null);
    }

    public void addAttachment(Object content, String filename, String contenttype, String encoding) {
        try {
            if (this.mp == null) {
                this.mp = new MimeMultipart();
            }
            if (content == null) {
                return;
            }
            MimeBodyPart mbp = new MimeBodyPart();
            mbp.setContent(content, contenttype);
            if (filename != null) {
                mbp.setFileName(filename);
            }
            if (encoding != null) {
                mbp.setHeader("Content-Transfer-Encoding", encoding);
            }
            this.mp.addBodyPart((BodyPart)mbp);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void addAttachment(byte[] bob, String filename, String contenttype) {
        try {
            if (this.mp == null) {
                this.mp = new MimeMultipart();
            }
            InternetHeaders hdrs = new InternetHeaders();
            if (contenttype != null) {
                String hdr = contenttype + "; name=" + filename;
                hdrs.setHeader("Content-Type", contenttype);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bob);
            MimeBodyPart mbp = new MimeBodyPart(hdrs, bob);
            if (filename != null) {
                mbp.setFileName(filename);
                if (contenttype != null) {
                    // empty if block
                }
            }
            this.mp.addBodyPart((BodyPart)mbp);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void send() throws MessagingException {
        if (this.msg == null) {
            return;
        }
        if (this.mp != null) {
            this.msg.setContent(this.mp);
        }
        Transport.send((Message)this.msg);
    }
}

