/*
 * Decompiled with CFR 0.152.
 */
package com.wm.msg;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.g11n.util.iContext;
import com.wm.lang.ns.NSName;
import com.wm.msg.Filter;
import com.wm.msg.ICondition;
import com.wm.msg.IMessage;
import com.wm.msg.MessageTypeFilterPair;
import com.wm.util.Values;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class SimpleCondition
implements ICondition {
    protected String conditionName;
    protected MessageTypeFilterPair mesgTypeFilterPair;
    protected NSName serviceName;
    public static final String KEY_MSG_TYPE_FILTER_PAIR = "messageTypeFilterPair";
    public static final String KEY_SERVICE_NAME = "serviceName";
    public static final String KEY_CONDITION_NAME = "conditionName";

    public boolean isSatisfied(IMessage msg) {
        return this.isSatisfied(msg, null);
    }

    public boolean isSatisfied(IMessage msg, Locale locale) {
        if (this.mesgTypeFilterPair != null) {
            if (this.mesgTypeFilterPair.getFilter() != null) {
                return this.mesgTypeFilterPair.getMessageType().equals(msg.getType()) && this.mesgTypeFilterPair.getFilter().selects(msg, locale);
            }
            return this.mesgTypeFilterPair.getMessageType().equals(msg.getType());
        }
        return false;
    }

    public String getName() {
        return this.conditionName;
    }

    public void setName(String name) {
        this.conditionName = name;
    }

    public String getType() {
        return "simple";
    }

    public NSName resolveServiceName(IMessage msg) {
        return this.serviceName;
    }

    public List getMessageTypes() {
        return this.getSubscriptionEntries();
    }

    public List getSubscriptionEntries() {
        ArrayList<String> l = new ArrayList<String>(1);
        if (this.mesgTypeFilterPair != null) {
            l.add(this.mesgTypeFilterPair.getMessageType());
        }
        return l;
    }

    public NSName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.serviceName = NSName.create(name);
    }

    public List getMessageTypeFilterPairs() {
        return this.getSubscriptionEntryFilterPairs();
    }

    public List getSubscriptionEntryFilterPairs() {
        ArrayList<MessageTypeFilterPair> l = new ArrayList<MessageTypeFilterPair>(1);
        if (this.mesgTypeFilterPair != null) {
            l.add(this.mesgTypeFilterPair);
        }
        return l;
    }

    public void setMessageTypeFilterPairs(List newMessageTypeFilterPair) {
        this.setSubscriptionEntryFilterPairs(newMessageTypeFilterPair);
    }

    public void setSubscriptionEntryFilterPairs(List newMessageTypeFilterPair) {
        Iterator iter = newMessageTypeFilterPair.iterator();
        this.mesgTypeFilterPair = (MessageTypeFilterPair)iter.next();
    }

    public void updateReferences(NSName oldName, NSName newName) {
        if (this.mesgTypeFilterPair != null) {
            if (oldName.equals(NSName.create(this.mesgTypeFilterPair.getMessageType()))) {
                String messageType = newName.toString();
                Filter filter = this.mesgTypeFilterPair.getFilter();
                this.mesgTypeFilterPair = new MessageTypeFilterPair(messageType, filter);
            } else if (oldName.equals(this.serviceName)) {
                this.serviceName = newName;
            }
        } else if (oldName.equals(this.serviceName)) {
            this.serviceName = newName;
        }
    }

    public IData getAsData() {
        IData data = IDataFactory.create();
        IDataCursor dc = data.getCursor();
        if (this.mesgTypeFilterPair != null) {
            dc.insertAfter(KEY_MSG_TYPE_FILTER_PAIR, this.mesgTypeFilterPair.getValues());
        } else {
            dc.insertAfter(KEY_MSG_TYPE_FILTER_PAIR, null);
        }
        dc.insertAfter(KEY_SERVICE_NAME, this.serviceName == null ? null : this.serviceName.getFullName());
        dc.insertAfter(KEY_CONDITION_NAME, this.conditionName);
        dc.destroy();
        return data;
    }

    public void setFromData(IData data) {
        IDataCursor dc = data.getCursor();
        if (dc.first(KEY_MSG_TYPE_FILTER_PAIR)) {
            if (dc.getValue() != null) {
                this.mesgTypeFilterPair = new MessageTypeFilterPair();
                this.mesgTypeFilterPair.setFromData((IData)dc.getValue());
            } else {
                this.mesgTypeFilterPair = null;
            }
        }
        if (dc.first(KEY_SERVICE_NAME)) {
            this.serviceName = NSName.create((String)dc.getValue());
        }
        if (dc.first(KEY_CONDITION_NAME)) {
            this.conditionName = (String)dc.getValue();
        }
        dc.destroy();
    }

    public Values getValues() {
        return Values.use(this.getAsData());
    }

    public void setValues(Values vals) {
        this.setFromData(vals.getIData());
    }

    public iContext getIContextPolicy() {
        return new iContext();
    }
}

