/*
 * Decompiled with CFR 0.152.
 */
package com.wm.msg;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.msg.Filter;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;

public class MessageTypeFilterPair
implements IDataPortable,
ValuesCodable {
    protected String messageType;
    protected Filter filter;
    public static final String KEY_MSG_TYPE = "messageType";
    public static final String KEY_FILTER = "filter";

    public MessageTypeFilterPair() {
    }

    public MessageTypeFilterPair(String messageType, Filter filter) {
        this.messageType = messageType;
        this.filter = filter;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public IData getAsData() {
        IData data = IDataFactory.create();
        IDataCursor dc = data.getCursor();
        dc.insertAfter(KEY_MSG_TYPE, this.messageType);
        String filterString = this.filter != null ? this.filter.getSource() : null;
        dc.insertAfter(KEY_FILTER, filterString);
        dc.destroy();
        return data;
    }

    public void setFromData(IData data) {
        IDataCursor dc = data.getCursor();
        if (dc.first(KEY_MSG_TYPE)) {
            this.messageType = (String)dc.getValue();
        }
        String filterString = null;
        if (dc.first(KEY_FILTER)) {
            filterString = (String)dc.getValue();
        }
        this.filter = new Filter(filterString);
        dc.destroy();
    }

    public Values getValues() {
        return Values.use(this.getAsData());
    }

    public void setValues(Values vals) {
        if (vals != null) {
            this.setFromData(vals.getIData());
        }
    }
}

