/*
 * Decompiled with CFR 0.152.
 */
package com.wm.msg;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.g11n.util.iContext;
import com.wm.lang.ns.NSName;
import com.wm.msg.Filter;
import com.wm.msg.ICondition;
import com.wm.msg.IMessage;
import com.wm.msg.MessageTypeFilterPair;
import com.wm.util.LocalizedException;
import com.wm.util.Values;
import com.wm.util.resources.UtilExceptionBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class JoinCondition
implements ICondition {
    public static final int AND = 1;
    public static final int XOR = 2;
    public static final int OR = 3;
    protected int joinType;
    protected String name;
    protected NSName serviceName;
    protected List mesgTypeFilterPairs;
    public static final String KEY_MSG_TYPE_FILTER_PAIRS = "messageTypeFilterPairs";
    public static final String KEY_SERVICE_NAME = "serviceName";
    public static final String KEY_CONDITION_NAME = "conditionName";
    public static final String KEY_JOIN_TYPE = "joinType";
    public static final String KEY_JOIN_TIMEOUT = "joinTimeout";

    public JoinCondition() {
    }

    private JoinCondition(int joinType, NSName service, String name, String[] mesgTypes) {
    }

    public String getType() {
        return "join";
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinType) throws Exception {
        if (joinType != 1 && joinType != 3 && joinType != 2) {
            throw new LocalizedException(UtilExceptionBundle.class, UtilExceptionBundle.INVALID_JOIN_TYPE, "");
        }
        this.joinType = joinType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getDocumentArray() {
        int size = this.mesgTypeFilterPairs.size();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            MessageTypeFilterPair pair = (MessageTypeFilterPair)this.mesgTypeFilterPairs.get(i);
            result[i] = pair.getMessageType();
        }
        return result;
    }

    public List getMessageTypes() {
        return this.getSubscriptionEntries();
    }

    public List getSubscriptionEntries() {
        ArrayList<String> l = new ArrayList<String>();
        for (MessageTypeFilterPair pair : this.mesgTypeFilterPairs) {
            l.add(pair.getMessageType());
        }
        return l;
    }

    public boolean isSatisfied(IMessage mesg) {
        return this.isSatisfied(mesg, null);
    }

    public boolean isSatisfied(IMessage mesg, Locale locale) {
        boolean result = false;
        for (MessageTypeFilterPair pair : this.mesgTypeFilterPairs) {
            if (!pair.getMessageType().equals(mesg.getType())) continue;
            Filter filter = pair.getFilter();
            if (filter == null) {
                result = true;
                break;
            }
            result = filter.selects(mesg, locale);
            break;
        }
        return result;
    }

    public NSName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String name) {
        this.serviceName = NSName.create(name);
    }

    public List getMessageTypeFilterPairs() {
        return this.getSubscriptionEntryFilterPairs();
    }

    public List getSubscriptionEntryFilterPairs() {
        return this.mesgTypeFilterPairs;
    }

    public void setMessageTypeFilterPairs(List mesgTypeFilterPairs) {
        this.setSubscriptionEntryFilterPairs(mesgTypeFilterPairs);
    }

    public void setSubscriptionEntryFilterPairs(List mesgTypeFilterPairs) {
        this.mesgTypeFilterPairs = mesgTypeFilterPairs;
    }

    public void updateReferences(NSName oldName, NSName newName) {
        MessageTypeFilterPair mesgTypeFilterPair = null;
        for (int i = 0; i < this.mesgTypeFilterPairs.size(); ++i) {
            mesgTypeFilterPair = (MessageTypeFilterPair)this.mesgTypeFilterPairs.get(i);
            if (mesgTypeFilterPair != null) {
                if (oldName.equals(NSName.create(mesgTypeFilterPair.getMessageType()))) {
                    String messageType = newName.toString();
                    Filter filter = mesgTypeFilterPair.getFilter();
                    mesgTypeFilterPair = new MessageTypeFilterPair(messageType, filter);
                    this.mesgTypeFilterPairs.remove(i);
                    this.mesgTypeFilterPairs.add(i, mesgTypeFilterPair);
                    continue;
                }
                if (!oldName.equals(this.serviceName)) continue;
                this.serviceName = newName;
                continue;
            }
            if (!oldName.equals(this.serviceName)) continue;
            this.serviceName = newName;
        }
    }

    public Values getValues() {
        return Values.use(this.getAsData());
    }

    public void setValues(Values vals) {
        this.setFromData(vals.getIData());
    }

    public void setFromData(IData data) {
        IDataCursor dc = data.getCursor();
        if (dc.first(KEY_MSG_TYPE_FILTER_PAIRS)) {
            this.mesgTypeFilterPairs = new ArrayList();
            IData[] pairData = (IData[])dc.getValue();
            if (pairData != null) {
                for (int i = 0; i < pairData.length; ++i) {
                    MessageTypeFilterPair pair = new MessageTypeFilterPair();
                    pair.setFromData(pairData[i]);
                    this.mesgTypeFilterPairs.add(pair);
                }
            }
        }
        if (dc.first(KEY_SERVICE_NAME)) {
            this.serviceName = NSName.create((String)dc.getValue());
        }
        if (dc.first(KEY_CONDITION_NAME)) {
            this.name = (String)dc.getValue();
        }
        if (dc.first(KEY_JOIN_TYPE)) {
            Integer temp = (Integer)dc.getValue();
            this.joinType = temp;
        }
        dc.destroy();
    }

    public IData getAsData() {
        IData data = IDataFactory.create();
        IDataCursor dc = data.getCursor();
        IData[] pairData = new IData[this.mesgTypeFilterPairs.size()];
        for (int i = 0; i < this.mesgTypeFilterPairs.size(); ++i) {
            MessageTypeFilterPair pair = (MessageTypeFilterPair)this.mesgTypeFilterPairs.get(i);
            pairData[i] = pair.getAsData();
        }
        dc.insertAfter(KEY_MSG_TYPE_FILTER_PAIRS, pairData);
        dc.insertAfter(KEY_SERVICE_NAME, this.serviceName != null ? this.serviceName.getFullName() : null);
        dc.insertAfter(KEY_CONDITION_NAME, this.name);
        Integer temp = new Integer(this.joinType);
        dc.insertAfter(KEY_JOIN_TYPE, temp);
        dc.destroy();
        return data;
    }

    public iContext getIContextPolicy() {
        return new iContext();
    }
}

