/*
 * Decompiled with CFR 0.152.
 */
package com.wm.msg;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.ns.NSName;
import com.wm.msg.Filter;
import com.wm.msg.IMessage;
import java.util.Locale;

public class JMSRoutingRule {
    private static final String KEY_RULE_NAME = "ruleName";
    private static final String KEY_SERVICE_NAME = "serviceName";
    private static final String KEY_FILTER = "filter";
    private String name;
    private NSName serviceName;
    private Filter filter;

    public JMSRoutingRule() {
    }

    public JMSRoutingRule(IData data) {
        this.setFromData(data);
    }

    public JMSRoutingRule(String name, NSName serviceName, Filter filter) {
        this.name = name;
        this.serviceName = serviceName;
        this.filter = filter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public NSName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(NSName serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isSatisfied(IMessage mesg, Locale locale) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.selects(mesg, locale);
    }

    public void setFromData(IData data) {
        IDataCursor dc = data.getCursor();
        if (dc.first(KEY_RULE_NAME)) {
            this.name = (String)dc.getValue();
        }
        if (dc.first(KEY_SERVICE_NAME)) {
            this.serviceName = NSName.create((String)dc.getValue());
        }
        String filterString = null;
        if (dc.first(KEY_FILTER)) {
            filterString = (String)dc.getValue();
        }
        this.filter = new Filter(filterString);
        dc.destroy();
    }

    public IData getAsData() {
        IData data = IDataFactory.create();
        IDataCursor dc = data.getCursor();
        dc.insertAfter(KEY_RULE_NAME, this.name);
        dc.insertAfter(KEY_SERVICE_NAME, this.serviceName != null ? this.serviceName.getFullName() : null);
        dc.insertAfter(KEY_FILTER, this.filter != null ? this.filter.getSource() : null);
        dc.destroy();
        return data;
    }

    public JMSRoutingRule deepClone() {
        return new JMSRoutingRule(this.getName(), this.getServiceName(), new Filter(this.filter != null ? this.filter.getSource() : null));
    }
}

