/*
 * Decompiled with CFR 0.152.
 */
package com.wm.msg;

import com.wm.data.IData;
import com.wm.data.IDataFactory;
import com.wm.lang.flow.ExpressionEvaluator;
import com.wm.lang.flow.MalformedExpressionException;
import com.wm.msg.IMessage;
import com.wm.util.coder.IDataBinCoder;
import java.io.ByteArrayInputStream;
import java.util.Locale;

public class Filter {
    protected String filterSource;

    public Filter(String source) {
        this.filterSource = source;
    }

    public boolean selects(IMessage msg) {
        return this.selects(msg, null);
    }

    public boolean selects(IMessage msg, Locale locale) {
        boolean selected = false;
        if (this.filterSource == null || this.filterSource.length() == 0) {
            return true;
        }
        try {
            Object storedData = msg.getData();
            IData documentData = null;
            if (storedData == null) {
                documentData = IDataFactory.create();
            } else if (storedData instanceof byte[]) {
                try {
                    byte[] b = (byte[])storedData;
                    IDataBinCoder coder = new IDataBinCoder();
                    ByteArrayInputStream bis = new ByteArrayInputStream(b);
                    documentData = coder.decode(bis);
                    b = null;
                    bis.close();
                    bis = null;
                }
                catch (Exception e) {}
            } else if (storedData instanceof IData) {
                documentData = (IData)storedData;
            }
            if (documentData != null) {
                selected = ExpressionEvaluator.evalToBoolean(this.filterSource, documentData, locale);
            }
        }
        catch (MalformedExpressionException meep) {
            // empty catch block
        }
        return selected;
    }

    public String getSource() {
        return this.filterSource;
    }

    public void setSource(String filter) {
        this.filterSource = filter;
    }

    public boolean equals(Filter other) {
        return this.filterSource.equals(other.filterSource);
    }
}

