/*
 * Decompiled with CFR 0.152.
 */
package com.wm.msg;

import com.wm.data.IData;
import com.wm.msg.ICondition;
import com.wm.msg.JoinConditionFactory;
import com.wm.msg.SimpleConditionFactory;
import java.util.HashMap;

public abstract class ConditionFactory {
    public static final String SIMPLE = "simple";
    public static final String COMPLEX = "join";
    static HashMap Factories;
    static boolean initialized;

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        Factories = new HashMap();
        ConditionFactory.register(SIMPLE, new SimpleConditionFactory());
        ConditionFactory.register(COMPLEX, new JoinConditionFactory());
        initialized = true;
    }

    public static void register(String name, ConditionFactory fac) {
        Factories.put(name, fac);
    }

    public static void unregister(String name, ConditionFactory fac) {
        Factories.remove(name);
    }

    public static ConditionFactory getInstance(String name) {
        return (ConditionFactory)Factories.get(name);
    }

    public abstract ICondition create(IData var1);

    static {
        ConditionFactory.initialize();
    }
}

