/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.CharacterBuffer;
import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.FloatToken;
import com.wm.lang.flow.IntegerToken;
import com.wm.lang.flow.StringToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;

class XqlTokenBuffer
extends TokenBuffer {
    static final String MSG_FLOAT_DOT_ERROR = "Floating point numbers must begin with a digit";
    static final int TEXT_ESCAPE_CHAR = 92;
    static final int TOKEN_ALL = 100;
    static final int TOKEN_ANY = 101;
    static final int TOKEN_AT = 102;
    static final int TOKEN_COMMA = 103;
    static final int TOKEN_NAME = 104;
    static final int TOKEN_WILDCARD = 105;
    static final int TOKEN_TO = 106;
    static final int TOKEN_DOT = 200;
    static final int TOKEN_FLOAT = 201;
    static final int TOKEN_INTEGER = 202;
    static final int TOKEN_TEXT = 203;
    static final int TOKEN_OR = 301;
    static final int TOKEN_AND = 302;
    static final int TOKEN_NOT = 303;
    static final int TOKEN_UNION = 304;
    static final int TOKEN_INTERSECT = 305;
    static final int TOKEN_BANG = 306;
    static final int TOKEN_SLASH = 307;
    static final int TOKEN_SLASH_SLASH = 308;
    static final int TOKEN_L_PAREN = 309;
    static final int TOKEN_R_PAREN = 310;
    static final int TOKEN_L_BRACKET = 311;
    static final int TOKEN_R_BRACKET = 312;
    static final int TOKEN_COLON = 313;
    static final int TOKEN_1ST_COMP = 400;
    static final int TOKEN_EQ = 400;
    static final int TOKEN_NE = 401;
    static final int TOKEN_LT = 402;
    static final int TOKEN_LE = 403;
    static final int TOKEN_GT = 404;
    static final int TOKEN_GE = 405;
    static final int TOKEN_IEQ = 406;
    static final int TOKEN_INE = 407;
    static final int TOKEN_ILT = 408;
    static final int TOKEN_ILE = 409;
    static final int TOKEN_IGT = 410;
    static final int TOKEN_IGE = 411;
    static final int TOKEN_LAST_COMP = 411;
    CharacterBuffer buf;

    public XqlTokenBuffer(String expression) throws WattExpressionException {
        int ch;
        this.buf = new CharacterBuffer(expression);
        block21: while ((ch = this.buf.getCurrent()) != -1) {
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.buf.advance();
                    continue block21;
                }
                case 47: {
                    this.readSlashToken();
                    continue block21;
                }
                case 36: {
                    this.readOperatorToken();
                    continue block21;
                }
                case 64: {
                    this.readToken(102);
                    continue block21;
                }
                case 42: {
                    this.readToken(105);
                    continue block21;
                }
                case 34: 
                case 39: {
                    this.readTextToken();
                    continue block21;
                }
                case 46: {
                    this.readDotToken();
                    continue block21;
                }
                case 45: {
                    this.readNumberToken();
                    continue block21;
                }
                case 91: {
                    this.readToken(311);
                    continue block21;
                }
                case 93: {
                    this.readToken(312);
                    continue block21;
                }
                case 40: {
                    this.readToken(309);
                    continue block21;
                }
                case 41: {
                    this.readToken(310);
                    continue block21;
                }
                case 44: {
                    this.readToken(103);
                    continue block21;
                }
                case 58: {
                    this.readToken(313);
                    continue block21;
                }
                case 124: {
                    this.readToken(304);
                    continue block21;
                }
                case 61: {
                    this.readToken(400);
                    continue block21;
                }
                case 33: {
                    this.readBangOrNeToken();
                    continue block21;
                }
                case 60: {
                    this.readLtOrLeToken();
                    continue block21;
                }
                case 62: {
                    this.readGtOrGeToken();
                    continue block21;
                }
            }
            if (XqlTokenBuffer.isXmlNameStartChar(ch)) {
                this.readNameToken();
                continue;
            }
            if (Character.isDigit((char)ch)) {
                this.readNumberToken();
                continue;
            }
            this.throwCharacterException("Character not valid in XQL", ch);
        }
    }

    static boolean isXmlNameStartChar(int ch) {
        return Character.isLetter((char)ch) || ch == 95;
    }

    static boolean isXmlNameChar(int ch) {
        return Character.isLetterOrDigit((char)ch) || ch == 46 || ch == 45 || ch == 95;
    }

    static boolean isXqlNameStartChar(int ch) {
        return XqlTokenBuffer.isXmlNameStartChar(ch);
    }

    static boolean isXqlNameChar(int ch) {
        return XqlTokenBuffer.isXmlNameChar(ch);
    }

    boolean isWhitespace(int ch) {
        return ch == 32 || ch == 10 || ch == 13 || ch == 9;
    }

    void throwInvalidOperatorException() throws WattExpressionException {
        this.buf.advanceTo(36);
        throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TB_UNRECOGNIZED_OPERATOR, "", this.buf.getSelection(0));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        List tokens = this.getTokens();
        if (tokens.size() == 0) {
            return "#EMPTY#";
        }
        Enumeration enumvar = tokens.elements();
        while (enumvar.hasMoreElements()) {
            ExpressionToken token = (ExpressionToken)enumvar.nextElement();
            sb.append(XqlTokenBuffer.toString(token) + " ");
        }
        return sb.toString();
    }

    static String toString(ExpressionToken token) {
        String s;
        try {
            switch (token.getType()) {
                case 100: {
                    s = "$all$";
                    break;
                }
                case 101: {
                    s = "$any$";
                    break;
                }
                case 102: {
                    s = "@";
                    break;
                }
                case 103: {
                    s = ",";
                    break;
                }
                case 313: {
                    s = ":";
                    break;
                }
                case 104: {
                    s = token.getString();
                    break;
                }
                case 105: {
                    s = "*";
                    break;
                }
                case 200: {
                    s = ".";
                    break;
                }
                case 201: {
                    s = "" + token.getFloat();
                    break;
                }
                case 202: {
                    s = "" + token.getInteger();
                    break;
                }
                case 203: {
                    s = "\"" + token.getString() + "\"";
                    break;
                }
                case 301: {
                    s = "$or$";
                    break;
                }
                case 302: {
                    s = "$and$";
                    break;
                }
                case 303: {
                    s = "$not$";
                    break;
                }
                case 304: {
                    s = "$union$";
                    break;
                }
                case 305: {
                    s = "$intersect$";
                    break;
                }
                case 306: {
                    s = "!";
                    break;
                }
                case 307: {
                    s = "/";
                    break;
                }
                case 308: {
                    s = "//";
                    break;
                }
                case 309: {
                    s = "(";
                    break;
                }
                case 310: {
                    s = ")";
                    break;
                }
                case 311: {
                    s = "[";
                    break;
                }
                case 312: {
                    s = "]";
                    break;
                }
                case 400: {
                    s = "=";
                    break;
                }
                case 401: {
                    s = "!=";
                    break;
                }
                case 402: {
                    s = "<";
                    break;
                }
                case 403: {
                    s = "<=";
                    break;
                }
                case 404: {
                    s = ">";
                    break;
                }
                case 405: {
                    s = ">=";
                    break;
                }
                case 406: {
                    s = "$ieq$";
                    break;
                }
                case 407: {
                    s = "$ine$";
                    break;
                }
                case 408: {
                    s = "$ilt$";
                    break;
                }
                case 409: {
                    s = "$ile$";
                    break;
                }
                case 410: {
                    s = "$igt$";
                    break;
                }
                case 411: {
                    s = "$ige$";
                    break;
                }
                case 106: {
                    s = "$to$";
                    break;
                }
                default: {
                    s = "#UNKNOWN(" + token.getType() + ")#";
                    break;
                }
            }
        }
        catch (WattExpressionException x) {
            s = "#EXCEPTION(\"" + x.getMessage() + "\", " + token.getType() + ")#";
        }
        return s;
    }

    static int stringToOperatorToken(String opName) {
        int opType = -1;
        if (opName.equalsIgnoreCase("OR")) {
            opType = 301;
        } else if (opName.equalsIgnoreCase("AND")) {
            opType = 302;
        } else if (opName.equalsIgnoreCase("NOT")) {
            opType = 303;
        } else if (opName.equalsIgnoreCase("UNION")) {
            opType = 304;
        } else if (opName.equalsIgnoreCase("INTERSECT")) {
            opType = 305;
        } else if (opName.equalsIgnoreCase("ANY")) {
            opType = 101;
        } else if (opName.equalsIgnoreCase("ALL")) {
            opType = 100;
        } else if (opName.equalsIgnoreCase("EQ")) {
            opType = 400;
        } else if (opName.equalsIgnoreCase("NE")) {
            opType = 401;
        } else if (opName.equalsIgnoreCase("LT")) {
            opType = 402;
        } else if (opName.equalsIgnoreCase("LE")) {
            opType = 403;
        } else if (opName.equalsIgnoreCase("GT")) {
            opType = 404;
        } else if (opName.equalsIgnoreCase("GE")) {
            opType = 405;
        } else if (opName.equalsIgnoreCase("IEQ")) {
            opType = 406;
        } else if (opName.equalsIgnoreCase("INE")) {
            opType = 407;
        } else if (opName.equalsIgnoreCase("ILT")) {
            opType = 408;
        } else if (opName.equalsIgnoreCase("ILE")) {
            opType = 409;
        } else if (opName.equalsIgnoreCase("IGT")) {
            opType = 410;
        } else if (opName.equalsIgnoreCase("IGE")) {
            opType = 411;
        } else if (opName.equalsIgnoreCase("TO")) {
            opType = 106;
        }
        return opType;
    }

    static boolean isValidName(String name) {
        if (!XqlTokenBuffer.isXqlNameStartChar(name.charAt(0))) {
            return false;
        }
        int iLen = name.length();
        for (int iCtr = 1; iCtr < iLen; ++iCtr) {
            char ch = name.charAt(iCtr);
            if (XqlTokenBuffer.isXqlNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    void readBangOrNeToken() {
        if (this.buf.next() == 61) {
            this.addToken(new ExpressionToken(401));
            this.buf.advance();
        } else {
            this.addToken(new ExpressionToken(306));
        }
    }

    void readDotToken() throws WattExpressionException {
        if (Character.isDigit((char)this.buf.next())) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_FLOAT_DOT_ERROR, "");
        }
        this.addToken(new ExpressionToken(200));
    }

    void readGtOrGeToken() {
        if (this.buf.next() == 61) {
            this.addToken(new ExpressionToken(405));
            this.buf.advance();
        } else {
            this.addToken(new ExpressionToken(404));
        }
    }

    void readLtOrLeToken() {
        if (this.buf.next() == 61) {
            this.addToken(new ExpressionToken(403));
            this.buf.advance();
        } else {
            this.addToken(new ExpressionToken(402));
        }
    }

    void readNameToken() {
        this.buf.mark();
        int ch = this.buf.next();
        while (ch != -1 && XqlTokenBuffer.isXmlNameChar(ch)) {
            ch = this.buf.next();
        }
        this.addToken(new StringToken(104, this.buf.getSelection(-1)));
    }

    void readNumberToken() throws WattExpressionException {
        int ch = this.buf.getCurrent();
        this.buf.mark();
        while (ch != -1 && !Character.isDigit((char)ch)) {
            if (ch == 46) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_FLOAT_DOT_ERROR, "");
            }
            ch = this.buf.next();
        }
        boolean isFloat = false;
        boolean atEnd = false;
        block6: while (!atEnd) {
            ch = this.buf.next();
            switch (ch) {
                case 43: 
                case 45: 
                case 46: 
                case 69: 
                case 101: {
                    isFloat = true;
                    continue block6;
                }
            }
            if (Character.isDigit((char)ch)) continue;
            atEnd = true;
        }
        String numberString = this.buf.getSelection(-1);
        try {
            if (isFloat) {
                this.addToken(new FloatToken(201, Float.valueOf(numberString).floatValue()));
            } else {
                this.addToken(new IntegerToken(202, Integer.parseInt(numberString)));
            }
        }
        catch (NumberFormatException x) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TB_INVALID_NUMBER, "", numberString);
        }
    }

    void readOperatorToken() throws WattExpressionException {
        String opName;
        int opType;
        int ch = this.buf.next();
        this.buf.mark();
        if (!XqlTokenBuffer.isXqlNameStartChar(ch)) {
            this.throwInvalidOperatorException();
        }
        ch = this.buf.next();
        while (ch != -1 && XqlTokenBuffer.isXqlNameChar(ch)) {
            ch = this.buf.next();
        }
        if (ch != 36) {
            this.throwInvalidOperatorException();
        }
        if ((opType = XqlTokenBuffer.stringToOperatorToken(opName = this.buf.getSelection(-1))) == -1) {
            this.throwInvalidOperatorException();
        }
        this.addToken(new ExpressionToken(opType));
        this.buf.advance();
    }

    void readSlashToken() {
        if (this.buf.next() == 47) {
            this.addToken(new ExpressionToken(308));
            this.buf.advance();
        } else {
            this.addToken(new ExpressionToken(307));
        }
    }

    void readTextToken() throws WattExpressionException {
        int quoteChar = this.buf.getCurrent();
        int ch = this.buf.next();
        boolean containsQuote = false;
        if (ch == quoteChar) {
            this.addToken(new StringToken(203, ""));
        } else {
            this.buf.mark();
            ch = this.buf.next();
            while (ch != -1 && ch != quoteChar) {
                if (ch == 92 && this.buf.next() == quoteChar) {
                    containsQuote = true;
                }
                ch = this.buf.next();
            }
            if (ch == -1) {
                Character c = new Character((char)quoteChar);
                Object[] sArray = new String[]{c.toString(), this.buf.getSelection(0)};
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TB_MISSING_TERMINAL_QUOTE, "", sArray);
            }
            if (!containsQuote) {
                this.addToken(new StringToken(203, this.buf.getSelection(-1)));
            } else {
                StringBuffer sb = new StringBuffer();
                String text = this.buf.getSelection(-1);
                int start = 0;
                int end = 0;
                int length = text.length();
                while (end < length) {
                    if (text.charAt(end++) != '\\' || text.charAt(end++) != quoteChar) continue;
                    if (start != end) {
                        sb.append(text.substring(start, end - 2) + (char)quoteChar);
                    } else {
                        sb.append((char)quoteChar);
                    }
                    start = end;
                }
                this.addToken(new StringToken(203, sb.toString()));
            }
        }
        this.buf.advance();
    }

    void readToken(int type) {
        this.addToken(new ExpressionToken(type));
        this.buf.advance();
    }

    static void usage() {
        System.out.println("XqlTokenBuffer requires the following arguments:");
        System.out.println();
        System.out.println("  <filename> name of file containing XQL expressions");
        System.out.println("      to tokenize at one expression per line");
    }

    public static void main(String[] argv) throws IOException, FileNotFoundException, WattExpressionException {
        String expression;
        if (argv.length != 1) {
            XqlTokenBuffer.usage();
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(argv[0]));
        while ((expression = reader.readLine()) != null) {
            XqlTokenBuffer tokenBuffer = new XqlTokenBuffer(expression);
            System.out.println("========");
            System.out.println("Source: " + expression);
            System.out.println("Tokens: " + tokenBuffer.toString());
        }
    }
}

