/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.widl.WattException;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ElementModel;
import com.wm.lang.xql.IDataModel;
import com.wm.lang.xql.LineIterator;
import com.wm.lang.xql.ObjectModel;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.TreeExpression;
import com.wm.lang.xql.VariableUtils;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.EncUtil;
import com.wm.util.Name;
import com.wm.util.Values;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class XqlQuery
extends TreeExpression {
    static final String STRING_TRUE = "true";
    static final String STRING_FALSE = "false";
    private static final boolean DEBUG = false;
    String expression;
    boolean hasVariables;
    ParsedQuery parse;
    Object identities;
    String bestResultType;
    QueryContext cx;

    public XqlQuery(String expression, Values namespaceHash) throws WattException {
        if (expression == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_EMPTY_EXPRESSION, "");
        }
        if ((expression = expression.trim()).length() == 0) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_EMPTY_EXPRESSION, "");
        }
        this.hasVariables = VariableUtils.hasVariables(expression);
        this.expression = expression;
        this.parse = new ParsedQuery("XQL", expression, namespaceHash);
    }

    public XqlQuery(Node node, Values namespaceHash) throws WattException, WMDocumentException {
        this(node.getText(), namespaceHash);
    }

    public XqlQuery(Object node, Values namespaceHash) throws WattException, WMDocumentException {
        this(node.toString(), namespaceHash);
    }

    public int getResultType() {
        return this.parse.getResultType();
    }

    public String getExpression() {
        return this.expression;
    }

    public TreeExpression getSubstitution(Values variables, Values namespaceHash) throws WattException {
        if (!this.hasVariables) {
            return this;
        }
        String expansion = VariableUtils.substitute(this.expression, variables);
        if (expansion == this.expression) {
            return this;
        }
        return new XqlQuery(expansion, namespaceHash);
    }

    public Object getIdentities() {
        return this.identities;
    }

    public String getStringWithIdentities(Object tree) throws WattException {
        try {
            String string = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                int type = this.parse.getResultType();
                this.bestResultType = type == 5 ? (arraySize > 1 ? "Object[]" : "Object") : (arraySize > 1 ? "String[]" : "String");
                Object value = results.getValue(0);
                switch (type) {
                    case 3: {
                        string = (String)value;
                        break;
                    }
                    case 1: {
                        string = ((Integer)value).toString();
                        break;
                    }
                    case 2: {
                        string = ((Float)value).toString();
                        break;
                    }
                    case 0: {
                        if (value == null) break;
                        if (((Boolean)value).booleanValue()) {
                            string = STRING_TRUE;
                            break;
                        }
                        string = STRING_FALSE;
                        break;
                    }
                    case 6: {
                        if (value == null) break;
                        string = this.cx.getModel().getAttributeText(value);
                        break;
                    }
                    case 5: {
                        if (value == null) break;
                        string = this.cx.getModel().getNodeText(value);
                        break;
                    }
                    default: {
                        Object[] sArray = new String[]{this.expression, Integer.toString(this.getResultType())};
                        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_STRING_IDEN_NO_STRING, "", sArray);
                    }
                }
            }
            String pos = new String(Integer.toString(results.getPosition(0)));
            this.identities = pos;
            return string;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public String getString(Object tree) throws WattException {
        try {
            String string = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (results.getSize() > 0) {
                int type = this.parse.getResultType();
                this.bestResultType = type == 5 ? (arraySize > 1 ? "Object[]" : "Object") : (arraySize > 1 ? "String[]" : "String");
                Object value = results.getValue(0);
                switch (type) {
                    case 3: {
                        string = (String)value;
                        break;
                    }
                    case 1: {
                        string = ((Integer)value).toString();
                        break;
                    }
                    case 2: {
                        string = ((Float)value).toString();
                        break;
                    }
                    case 0: {
                        if (value == null) break;
                        if (((Boolean)value).booleanValue()) {
                            string = STRING_TRUE;
                            break;
                        }
                        string = STRING_FALSE;
                        break;
                    }
                    case 6: {
                        if (value == null) break;
                        string = this.cx.getModel().getAttributeText(value);
                        break;
                    }
                    case 5: {
                        if (value == null) break;
                        string = this.cx.getModel().getNodeText(value);
                        break;
                    }
                    default: {
                        Object[] sArray = new String[]{this.expression, Integer.toString(this.getResultType())};
                        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_STRING_NO_STRING, "", sArray);
                    }
                }
            }
            return string;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public String[] getStringArrayWithIdentities(Object tree) throws WattException {
        try {
            int i;
            String[] stringArray = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                stringArray = new String[arraySize];
                int type = this.parse.getResultType();
                this.bestResultType = type == 5 ? (arraySize > 1 ? "Object[]" : "Object") : (arraySize > 1 ? "String[]" : "String");
                switch (type) {
                    case 3: {
                        for (i = 0; i < arraySize; ++i) {
                            stringArray[i] = (String)results.getValue(i);
                        }
                        break;
                    }
                    case 1: {
                        Object tmpObj;
                        for (i = 0; i < arraySize; ++i) {
                            tmpObj = results.getValue(i);
                            if (tmpObj == null) continue;
                            stringArray[i] = ((Integer)tmpObj).toString();
                        }
                        break;
                    }
                    case 2: {
                        Object tmpObj;
                        for (i = 0; i < arraySize; ++i) {
                            tmpObj = results.getValue(i);
                            if (tmpObj == null) continue;
                            stringArray[i] = ((Float)tmpObj).toString();
                        }
                        break;
                    }
                    case 0: {
                        Object tmpObj;
                        for (i = 0; i < arraySize; ++i) {
                            tmpObj = results.getValue(i);
                            if (tmpObj == null) continue;
                            stringArray[i] = (Boolean)results.getValue(i) == true ? STRING_TRUE : STRING_FALSE;
                        }
                        break;
                    }
                    case 6: {
                        Object tmpObj;
                        for (i = 0; i < arraySize; ++i) {
                            tmpObj = results.getValue(i);
                            if (tmpObj == null) continue;
                            stringArray[i] = this.cx.getModel().getAttributeText(tmpObj);
                        }
                        break;
                    }
                    case 5: {
                        Object tmpObj;
                        for (i = 0; i < arraySize; ++i) {
                            tmpObj = results.getValue(i);
                            if (tmpObj == null) continue;
                            stringArray[i] = this.cx.getModel().getNodeText(tmpObj);
                        }
                        break;
                    }
                    default: {
                        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_UNKOWN_TYPE, "");
                    }
                }
            }
            String[] pos = new String[arraySize];
            for (i = 0; i < arraySize; ++i) {
                pos[i] = new String(Integer.toString(results.getPosition(i)));
            }
            this.identities = pos;
            return stringArray;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public String[] getStringArray(Object tree) throws WattException {
        try {
            String[] stringArray = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                stringArray = new String[arraySize];
                int type = this.parse.getResultType();
                this.bestResultType = type == 5 ? (arraySize > 1 ? "Object[]" : "Object") : (arraySize > 1 ? "String[]" : "String");
                switch (type) {
                    case 3: {
                        for (int i = 0; i < arraySize; ++i) {
                            stringArray[i] = (String)results.getValue(i);
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < arraySize; ++i) {
                            Object tmpObj = results.getValue(i);
                            if (tmpObj == null) continue;
                            stringArray[i] = ((Integer)tmpObj).toString();
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < arraySize; ++i) {
                            Object tmpObj = results.getValue(i);
                            if (tmpObj == null) continue;
                            stringArray[i] = ((Float)tmpObj).toString();
                        }
                        break;
                    }
                    case 0: {
                        for (int i = 0; i < arraySize; ++i) {
                            Object tmpObj = results.getValue(i);
                            if (tmpObj == null) continue;
                            stringArray[i] = (Boolean)tmpObj == true ? STRING_TRUE : STRING_FALSE;
                        }
                        break;
                    }
                    case 6: {
                        for (int i = 0; i < arraySize; ++i) {
                            Object tmpObj = results.getValue(i);
                            if (tmpObj == null) continue;
                            stringArray[i] = this.cx.getModel().getAttributeText(tmpObj);
                        }
                        break;
                    }
                    case 5: {
                        for (int i = 0; i < arraySize; ++i) {
                            Object tmpObj = results.getValue(i);
                            if (tmpObj == null) continue;
                            stringArray[i] = this.cx.getModel().getNodeText(tmpObj);
                        }
                        break;
                    }
                    default: {
                        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_UNKOWN_TYPE, "");
                    }
                }
            }
            return stringArray;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public Node getNodeWithIdentities(Object tree) throws WattException {
        try {
            Node node = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                if (this.parse.getResultType() != 5) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODE_IDEN_NO_NODE, "", this.expression);
                }
                if (!(tree instanceof Node)) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODE_TREE, "", this.expression);
                }
                this.bestResultType = arraySize > 1 ? "Object[]" : "Object";
                Node tmp = (Node)results.getValue(0);
                if (tmp != null) {
                    node = tmp.isXML() ? tmp : tmp.getReferenceNode();
                }
            }
            String pos = new String(Integer.toString(results.getPosition(0)));
            this.identities = pos;
            return node;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public IData getIDataWithIdentities(Object tree) throws WattException {
        try {
            IData node = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                if (this.parse.getResultType() != 5) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODE_IDEN_NO_NODE, "", this.expression);
                }
                this.bestResultType = arraySize > 1 ? "IData[]" : "IData";
                Object tmp = results.getValue(0);
                if (tmp != null) {
                    if (tmp instanceof IData[]) {
                        node = ((IData[])tmp)[0];
                    } else if (tmp instanceof IData) {
                        node = (IData)tmp;
                    }
                }
            }
            String pos = new String(Integer.toString(results.getPosition(0)));
            this.identities = pos;
            return node;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public Node getNode(Object tree) throws WattException {
        try {
            Node node = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                if (this.parse.getResultType() != 5) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODE_NO_NODE, "", this.expression);
                }
                if (!(tree instanceof Node)) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODE_TREE, "", this.expression);
                }
                this.bestResultType = arraySize > 1 ? "Object[]" : "Object";
                Node tmp = (Node)results.getValue(0);
                if (tmp != null) {
                    node = tmp.isXML() ? tmp : tmp.getReferenceNode();
                }
            }
            return node;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public Node[] getNodeArrayWithIdentities(Object tree) throws WattException {
        try {
            Node[] nodeArray = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                if (this.parse.getResultType() != 5) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODEARRAY_IDEN_NO_NODE, "", this.expression);
                }
                if (!(tree instanceof Node)) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODE_TREE, "", this.expression);
                }
                this.bestResultType = arraySize > 1 ? "Object[]" : "Object";
                nodeArray = new Node[arraySize];
                boolean isXML = ((Node)tree).isXML();
                for (int i = 0; i < arraySize; ++i) {
                    Node tmp = (Node)results.getValue(i);
                    if (isXML) {
                        nodeArray[i] = tmp;
                        continue;
                    }
                    if (tmp == null) continue;
                    nodeArray[i] = tmp.getReferenceNode();
                }
            }
            String[] pos = new String[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                if (nodeArray[i] == null) continue;
                pos[i] = new String(Integer.toString(nodeArray[i].getPosition()));
            }
            this.identities = pos;
            return nodeArray;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public IData[] getIDataArrayWithIdentities(Object tree) throws WattException {
        try {
            IData[] dataArray = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                if (this.parse.getResultType() != 5) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODEARRAY_IDEN_NO_NODE, "", this.expression);
                }
                this.bestResultType = arraySize > 1 ? "IData[]" : "IData";
                dataArray = new IData[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    Object obj = results.getValue(i);
                    if (!(obj instanceof IData)) {
                        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_ONLY_IDATA, "", this.expression);
                    }
                    dataArray[i] = (IData)obj;
                }
            }
            String[] pos = new String[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                pos[i] = new String(Integer.toString(results.getPosition(i)));
            }
            this.identities = pos;
            return dataArray;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public Node[] getNodeArray(Object tree) throws WattException {
        try {
            Node[] nodeArray = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                if (this.parse.getResultType() != 5) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODEARRAY_NO_NODE, "", this.expression);
                }
                if (!(tree instanceof Node)) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NODE_TREE, "", this.expression);
                }
                this.bestResultType = arraySize > 1 ? "Object[]" : "Object";
                nodeArray = new Node[arraySize];
                boolean isXML = ((Node)tree).isXML();
                for (int i = 0; i < arraySize; ++i) {
                    Node tmp = (Node)results.getValue(i);
                    if (isXML) {
                        nodeArray[i] = tmp;
                        continue;
                    }
                    if (tmp == null) continue;
                    nodeArray[i] = tmp.getReferenceNode();
                }
            }
            return nodeArray;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public IData getIData(Object tree) throws WattException {
        try {
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                if (this.parse.getResultType() != 5) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_IDATA_NO_NODE, "", this.expression);
                }
                Object obj = results.getValue(0);
                this.bestResultType = arraySize > 1 ? "IData[]" : "IData";
                if (obj instanceof IData[]) {
                    this.bestResultType = "IData[]";
                    obj = ((IData[])obj)[0];
                }
                if (!(obj instanceof IData)) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_NO_IDATA_INSTANCE, "");
                }
                return (IData)obj;
            }
            return null;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public IData[] getIDataArray(Object tree) throws WattException {
        try {
            IData[] dataArray = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                if (this.parse.getResultType() != 5) {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_IDATAARRAY_NO_NODE, "", this.expression);
                }
                this.bestResultType = arraySize > 1 ? "IData[]" : "IData";
                dataArray = new IData[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    Object obj = results.getValue(i);
                    if (!(obj instanceof IData)) {
                        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_ONLY_IDATA, "", this.expression);
                    }
                    dataArray[i] = (IData)obj;
                }
            }
            return dataArray;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public Object getObject(Object tree) throws WattException {
        try {
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                this.bestResultType = arraySize > 1 ? "Object[]" : "Object";
                return results.getValue(0);
            }
            return null;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public Object[] getObjectArray(Object tree) throws WattException {
        try {
            Object[] objArray = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                this.bestResultType = arraySize > 1 ? "Object[]" : "Object";
                objArray = new Object[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    objArray[i] = results.getValue(i);
                }
            }
            return objArray;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public Object getObjectWithIdentities(Object tree) throws WattException {
        try {
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                this.bestResultType = arraySize > 1 ? "Object[]" : "Object";
                String pos = new String(Integer.toString(results.getPosition(0)));
                this.identities = pos;
                return results.getValue(0);
            }
            return null;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public Object[] getObjectArrayWithIdentities(Object tree) throws WattException {
        try {
            Object[] objArray = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                this.bestResultType = arraySize > 1 ? "Object[]" : "Object";
                objArray = new Object[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    objArray[i] = results.getValue(i);
                }
            }
            String[] pos = new String[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                pos[i] = new String(Integer.toString(results.getPosition(i)));
            }
            this.identities = pos;
            return objArray;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public Object getBestResultsWithIdentities(Object tree) throws WattException {
        try {
            Object bestResults = null;
            ResultSet results = this.getResults(tree);
            int arraySize = results.getSize();
            if (arraySize > 0) {
                switch (this.parse.getResultType()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: {
                        if (arraySize > 1 || results.getValue(0) instanceof String[]) {
                            bestResults = this.getStringArrayWithIdentities(tree);
                            this.bestResultType = "String[]";
                            break;
                        }
                        bestResults = this.getStringWithIdentities(tree);
                        this.bestResultType = "String";
                        break;
                    }
                    case 5: {
                        if (tree instanceof Node) {
                            if (arraySize > 1) {
                                bestResults = this.getNodeArrayWithIdentities(tree);
                                this.bestResultType = "Object[]";
                                break;
                            }
                            bestResults = this.getNodeWithIdentities(tree);
                            this.bestResultType = "Object";
                            break;
                        }
                        if (arraySize > 1 || results.getValue(0) instanceof IData[]) {
                            try {
                                bestResults = this.getIDataArrayWithIdentities(tree);
                                this.bestResultType = "IData[]";
                            }
                            catch (WattEvaluationException wmde) {
                                try {
                                    bestResults = this.getStringArrayWithIdentities(tree);
                                    this.bestResultType = "String[]";
                                }
                                catch (WattEvaluationException wee) {
                                    bestResults = this.getObjectArrayWithIdentities(tree);
                                    this.bestResultType = "Object[]";
                                }
                            }
                            break;
                        }
                        try {
                            bestResults = this.getIDataWithIdentities(tree);
                            this.bestResultType = "IData";
                        }
                        catch (WattEvaluationException wmde) {
                            try {
                                bestResults = this.getStringWithIdentities(tree);
                                this.bestResultType = "String";
                            }
                            catch (WattEvaluationException wee) {
                                bestResults = this.getObjectWithIdentities(tree);
                                this.bestResultType = "Object";
                            }
                        }
                        break;
                    }
                    default: {
                        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.XQ_UNKOWN_TYPE, "");
                    }
                }
            }
            return bestResults;
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    public String getBestResultType() {
        return this.bestResultType;
    }

    ResultSet getResults(Object tree) throws WattException, WMDocumentException {
        try {
            Object target = tree;
            ObjectModel model = null;
            if (tree instanceof Node) {
                model = ElementModel.getObjectModel((Node)tree);
            } else if (tree instanceof IData) {
                model = IDataModel.getObjectModel((IData)tree);
            } else {
                throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TREE_UNSUPPORTED, "");
            }
            this.cx = new QueryContext(model, this.parse, target);
            ResultSet querySet = new ResultSet();
            querySet.addValue(target, 0);
            return this.parse.getResults(this.cx, new ReferenceNode(querySet, 0));
        }
        catch (WMDocumentException e) {
            throw new WattEvaluationException(e.toString());
        }
    }

    String parseToXql() {
        return this.parse.toXqlString();
    }

    static void usage() {
        System.out.println("To parse queries from stdin:");
        System.out.println("  -p [<query-file>]");
        System.out.println("To execute queries from stdin:");
        System.out.println("  -e <xmlfile> [<query-file>]");
        System.out.println("To execute queries on IData object:");
        System.out.println("  -i <xmlfile> [<query-file>]");
    }

    public static void main(String[] argv) throws IOException, FileNotFoundException, WattException, WMDocumentException {
        if (argv.length < 1) {
            XqlQuery.usage();
        } else if (argv[0].equalsIgnoreCase("-p")) {
            XqlQuery.parseStream(argv);
        } else if (argv[0].equalsIgnoreCase("-e")) {
            XqlQuery.queryStream(argv);
        } else if (argv[0].equalsIgnoreCase("-i")) {
            XqlQuery.queryIData(argv);
        } else {
            XqlQuery.usage();
        }
    }

    static void parseStream(String[] argv) throws IOException, FileNotFoundException, WattException {
        String expression;
        InputStreamReader reader = argv.length == 2 ? new InputStreamReader((InputStream)new FileInputStream(argv[1]), EncUtil.getFileEncoding()) : new InputStreamReader(System.in, EncUtil.getFileEncoding());
        LineIterator iterator = new LineIterator(reader);
        while ((expression = iterator.getNextLine()) != null) {
            XqlQuery query = new XqlQuery(expression, null);
            System.out.println("--");
            System.out.println("Source: " + expression);
            System.out.println(" Parse: " + query.parseToXql());
        }
        System.out.println("--");
    }

    static void queryStream(String[] argv) throws IOException, FileNotFoundException, WattException, WMDocumentException {
        String expression;
        if (argv.length < 2) {
            XqlQuery.usage();
            return;
        }
        InputStreamReader reader = argv.length == 3 ? new InputStreamReader((InputStream)new FileInputStream(argv[2]), EncUtil.getFileEncoding()) : new InputStreamReader(System.in, EncUtil.getFileEncoding());
        Document document = new Document((InputStream)new FileInputStream(argv[1]), "", EncUtil.getFileEncoding(), false);
        LineIterator iterator = new LineIterator(reader);
        Values namespaceHash = null;
        System.out.println("<xql:batchtest>");
        System.out.println();
        while ((expression = iterator.getNextLine()) != null) {
            if (iterator.isNamespaceDecl()) {
                namespaceHash = new Values();
                while (iterator.isNamespaceDecl()) {
                    String ref = iterator.getNextLine();
                    if (!iterator.isNamespaceDecl()) break;
                    if (ref == null) {
                        System.out.println(XqlQuery.tab(1) + "<xql:exception>Badly formed namespace section in XQL file</xql:exception>");
                        break;
                    }
                    String uri = iterator.getNextLine();
                    if (uri == null) {
                        System.out.println(XqlQuery.tab(1) + "<xql:exception>Badly formed namespace section in XQL file</xql:exception>");
                        break;
                    }
                    Name uriName = Name.create(uri.trim());
                    namespaceHash.put(ref.trim(), uriName);
                }
            } else {
                System.out.println(XqlQuery.tab(1) + "<xql:query>" + expression + "</xql:query>");
                System.out.println(XqlQuery.tab(1) + "<xql:result>");
                try {
                    XqlQuery query = new XqlQuery(expression, namespaceHash);
                    if (query.getResultType() == 5) {
                        Node[] nodearray = query.getNodeArray(document);
                        if (nodearray == null) {
                            System.out.println(XqlQuery.tab(2) + "<xql:null/>");
                        } else if (nodearray.length == 0) {
                            System.out.println(XqlQuery.tab(2) + "<xql:empty-set/>");
                        } else {
                            for (int i = 0; i < nodearray.length; ++i) {
                                XqlQuery.printNode(nodearray[i]);
                            }
                        }
                    } else {
                        String[] strarray = query.getStringArray(document);
                        if (strarray == null) {
                            System.out.println(XqlQuery.tab(2) + "<xql:null/>");
                        } else if (strarray.length == 0) {
                            System.out.println(XqlQuery.tab(2) + "<xql:empty-set/>");
                        } else {
                            for (int i = 0; i < strarray.length; ++i) {
                                XqlQuery.printString(strarray[i]);
                            }
                        }
                    }
                    System.out.println(XqlQuery.tab(1) + "</xql:result>");
                }
                catch (WattException we) {
                    System.out.println(XqlQuery.tab(2) + "<xql:exception>" + we + "</xql:exception>");
                    System.out.println(XqlQuery.tab(1) + "</xql:result>");
                }
            }
            System.out.println();
        }
        System.out.println("</xql:batchtest>");
    }

    static void queryIData(String[] argv) throws IOException, FileNotFoundException, WattException, WMDocumentException {
        String expression;
        Object ret;
        if (argv.length < 2) {
            XqlQuery.usage();
            return;
        }
        InputStreamReader reader = argv.length == 3 ? new InputStreamReader((InputStream)new FileInputStream(argv[2]), EncUtil.getFileEncoding()) : new InputStreamReader(System.in, EncUtil.getFileEncoding());
        Document doc = new Document((InputStream)new FileInputStream(argv[1]), "", null, false);
        IData idata = IDataFactory.create();
        IDataCursor cursor = idata.getCursor();
        cursor.insertAfter("node", doc);
        Object val = null;
        if (cursor.first("node")) {
            val = cursor.getValue();
        }
        if ((ret = null) != null && ret instanceof IData) {
            if (cursor.first("boundNode")) {
                cursor.setValue(ret);
            } else {
                cursor.last();
                cursor.insertAfter("boundNode", ret);
            }
        }
        cursor.destroy();
        LineIterator iterator = new LineIterator(reader);
        Object namespaceHash = null;
        System.out.println("<xql:batchtest>");
        System.out.println();
        while ((expression = iterator.getNextLine()) != null) {
            if (iterator.isNamespaceDecl()) {
                System.out.println("All IData nodes belong to empty/default namespace ");
            } else {
                System.out.println(XqlQuery.tab(1) + "<xql:query>" + expression + "</xql:query>");
                System.out.println(XqlQuery.tab(1) + "<xql:result>");
                try {
                    int i;
                    XqlQuery query = new XqlQuery(expression, null);
                    if (query.getResultType() == 5) {
                        IData[] idataArray = query.getIDataArray(idata);
                        if (idataArray == null) {
                            System.out.println(XqlQuery.tab(2) + "<xql:null/>");
                        } else if (idataArray.length == 0) {
                            System.out.println(XqlQuery.tab(2) + "<xql:empty-set/>");
                        } else {
                            for (i = 0; i < idataArray.length; ++i) {
                                System.out.println(idataArray[i].toString());
                            }
                        }
                    } else {
                        String[] strarray = query.getStringArray(idata);
                        if (strarray == null) {
                            System.out.println(XqlQuery.tab(2) + "<xql:null/>");
                        } else if (strarray.length == 0) {
                            System.out.println(XqlQuery.tab(2) + "<xql:empty-set/>");
                        } else {
                            for (i = 0; i < strarray.length; ++i) {
                                XqlQuery.printString(strarray[i]);
                            }
                        }
                        System.out.println(XqlQuery.tab(1) + "</xql:result>");
                    }
                }
                catch (WattException we) {
                    System.out.println(XqlQuery.tab(2) + "<xql:exception>" + we + "</xql:exception>");
                    System.out.println(XqlQuery.tab(1) + "</xql:result>");
                }
            }
            System.out.println();
        }
        System.out.println("</xql:batchtest>");
    }

    static void printString(String str) {
        System.out.println(XqlQuery.tab(2) + "<xql:str>" + str + "</xql:str>");
    }

    static void printNode(Node node) throws WMDocumentException {
        if (node == null) {
            System.out.println(XqlQuery.tab(2) + "<xql:null/>");
        } else {
            StringBuffer sb = new StringBuffer();
            node.appendGeneratedMarkup(sb);
            System.out.println(sb);
        }
    }
}

