/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.widl.WattException;
import com.wm.lang.xql.TreeExpression;
import com.wm.lang.xql.VariableUtils;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.Values;

public class VarNameExpression
extends TreeExpression {
    String expression;

    public VarNameExpression(String expression) throws WattException {
        if (expression == null || expression.length() == 0) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_EMPTY_EXPRESSION, "");
        }
        this.expression = expression.trim();
    }

    public String getExpression() {
        return this.expression;
    }

    private Object getValue(Object tree) throws WattEvaluationException {
        if (!(tree instanceof Values)) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TREE_UNSUPPORTED, "");
        }
        return ((Values)tree).get(this.expression);
    }

    public TreeExpression getSubstitution(Values variables) throws WattException {
        String expansion = VariableUtils.substitute(this.expression, variables);
        if (expansion == null || expansion == this.expression) {
            return this;
        }
        return new VarNameExpression(expansion);
    }

    public String getString(Object tree) throws WattException {
        Object value = this.getValue(tree);
        if (value != null && !(value instanceof String)) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (String)value;
    }

    public String[] getStringArray(Object tree) throws WattException {
        Object value = this.getValue(tree);
        if (value != null && !(value instanceof String[])) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (String[])value;
    }

    public String[][] getStringTable(Object tree) throws WattException {
        Object value = this.getValue(tree);
        if (value != null && !(value instanceof String[][])) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (String[][])value;
    }

    public Values getValues(Object tree) throws WattException {
        Object value = this.getValue(tree);
        if (value != null && !(value instanceof Values)) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (Values)value;
    }

    public Values[] getValuesArray(Object tree) throws WattException {
        Object value = this.getValue(tree);
        if (value != null && !(value instanceof Values[])) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (Values[])value;
    }

    public Values[][] getValuesTable(Object tree) throws WattException {
        Object value = this.getValue(tree);
        if (value != null && !(value instanceof Values[][])) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
        }
        return (Values[][])value;
    }
}

