/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

public final class TypedValue {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_BOOLEAN = 0;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_NODE = 5;
    public static final int TYPE_ATTRIBUTE = 6;
    public static final int NUM_PRIMITIVES = 5;
    public static final int NUM_TYPES = 7;
    public static final String[] typeStrings = new String[]{new String("BOOLEAN"), new String("INTEGER"), new String("FLOAT"), new String("LONG"), new String("STRING"), new String("NODE"), new String("ATTRIBUTE")};
    boolean booleanValue;
    int integerValue;
    float floatValue;
    long longValue;
    String stringValue;
    Object nodeValue;

    static String getTypeString(int type) {
        if (type >= 0 && type < typeStrings.length) {
            return typeStrings[type];
        }
        return "UNKNOWN";
    }

    boolean getBoolean() {
        return this.booleanValue;
    }

    int getInteger() {
        return this.integerValue;
    }

    float getFloat() {
        return this.floatValue;
    }

    String getString() {
        return this.stringValue;
    }

    long getLong() {
        return this.longValue;
    }

    Object getNode() {
        return this.nodeValue;
    }

    void setBoolean(boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    void setInteger(int integerValue) {
        this.integerValue = integerValue;
    }

    void setFloat(float floatValue) {
        this.floatValue = floatValue;
    }

    void setString(String stringValue) {
        this.stringValue = stringValue;
    }

    void setLong(long longValue) {
        this.longValue = longValue;
    }

    void setNode(Object nodeValue) {
        this.nodeValue = nodeValue;
    }

    void setValue(int type, Object value) {
        switch (type) {
            case 0: {
                this.booleanValue = (Boolean)value;
                break;
            }
            case 1: {
                this.integerValue = (Integer)value;
                break;
            }
            case 2: {
                this.floatValue = ((Float)value).floatValue();
                break;
            }
            case 3: {
                this.stringValue = (String)value;
                break;
            }
            case 4: {
                this.longValue = (Long)value;
                break;
            }
            case 5: 
            case 6: {
                this.nodeValue = value;
            }
        }
    }
}

