/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.data.IData;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.widl.GenerateORNQueryString;
import com.wm.lang.widl.ORNReference;
import com.wm.lang.widl.WattException;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ConstantExpression;
import com.wm.lang.xql.ExpressionDefaults;
import com.wm.lang.xql.GenerateXQLQueryString;
import com.wm.lang.xql.VarNameExpression;
import com.wm.lang.xql.VariableUtils;
import com.wm.lang.xql.XqlQuery;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.LocalizedRuntimeException;
import com.wm.util.Values;
import com.wm.xml.CharDefs;

public abstract class TreeExpression {
    public static final String TYPE_CONSTANT = "CONSTANT";
    public static final String TYPE_ORN = "WQL";
    public static final String TYPE_WQL = "WQL";
    public static final String TYPE_VARNAME = "VARNAME";
    public static final String TYPE_XQL = "XQL";
    public static final int RESULT_UNKNOWN = -1;
    public static final int RESULT_STRING = 0;
    public static final int RESULT_VALUES = 1;
    public static final int RESULT_ELEMENT = 2;
    public static final int RESULT_COUNT = 3;
    public static final String MSG_TYPE_UNAVAILABLE = "Requested type not available";
    public static final String MSG_TREE_UNSUPPORTED = "Tree type not supported";
    public static final String MSG_EMPTY_EXPRESSION = "Expression is empty";

    public static TreeExpression create(String typeName, String expression, ExpressionDefaults defaults) throws WattException {
        TreeExpression expr;
        if (typeName.equalsIgnoreCase(TYPE_CONSTANT)) {
            expr = new ConstantExpression(expression);
        } else if (typeName.equalsIgnoreCase("WQL")) {
            expr = new ORNReference(expression);
        } else if (typeName.equalsIgnoreCase(TYPE_VARNAME)) {
            expr = new VarNameExpression(expression);
        } else if (typeName.equalsIgnoreCase(TYPE_XQL)) {
            expr = new XqlQuery(expression, defaults.getNamespaceHash());
        } else {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TE_UNRECOGNIZED_TYPE, "", typeName);
        }
        return expr;
    }

    public static TreeExpression create(String typeName, String expression, Values nsDecls) throws WattException {
        TreeExpression expr;
        if (typeName.equalsIgnoreCase(TYPE_CONSTANT)) {
            expr = new ConstantExpression(expression);
        } else if (typeName.equalsIgnoreCase("WQL")) {
            expr = new ORNReference(expression);
        } else if (typeName.equalsIgnoreCase(TYPE_VARNAME)) {
            expr = new VarNameExpression(expression);
        } else if (typeName.equalsIgnoreCase(TYPE_XQL)) {
            expr = new XqlQuery(expression, nsDecls);
        } else {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TE_UNRECOGNIZED_TYPE, "", typeName);
        }
        return expr;
    }

    public static TreeExpression create(String typeName, Object node, ExpressionDefaults defaults) throws WattException, WMDocumentException {
        TreeExpression expr;
        if (typeName.equalsIgnoreCase("WQL")) {
            expr = new ORNReference((Node)node);
        } else if (typeName.equalsIgnoreCase(TYPE_XQL)) {
            expr = new XqlQuery(node, defaults.getNamespaceHash());
        } else {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TE_UNRECOGNIZED_TYPE, "", typeName);
        }
        return expr;
    }

    public static TreeExpression create(String typeName, Object node, Values nsDecls) throws WattException, WMDocumentException {
        TreeExpression expr;
        if (typeName.equalsIgnoreCase("WQL")) {
            expr = new ORNReference((Node)node);
        } else if (typeName.equalsIgnoreCase(TYPE_XQL)) {
            expr = new XqlQuery(node, nsDecls);
        } else {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TE_UNRECOGNIZED_TYPE, "", typeName);
        }
        return expr;
    }

    public static String tab(int tabDepth) {
        return VariableUtils.tab(tabDepth);
    }

    public static String generateQueryString(String queryType, Object doc, int nodeId, String attribute, boolean textQuery, Values nsDecls) throws WattException {
        String query;
        if (doc == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TE_NULL_NODE_PARA, "");
        }
        if (queryType == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TE_NULL_STRING_PARA, "");
        }
        if (queryType.equalsIgnoreCase("WQL")) {
            GenerateORNQueryString gr = new GenerateORNQueryString((Node)doc, nodeId, attribute, textQuery);
            query = gr.getQuery();
        } else if (queryType.equalsIgnoreCase(TYPE_XQL)) {
            GenerateXQLQueryString gr = new GenerateXQLQueryString(doc, nodeId, attribute, textQuery, nsDecls);
            query = gr.getQuery();
        } else {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TE_UNSUPPORTED_TYPE, "", queryType);
        }
        return query;
    }

    public static String generateQueryString(String queryType, Object doc, Object nodeId, String attribute, boolean textQuery, Values nsDecls) throws WattException {
        if (doc == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TE_NULL_NODE_PARA, "");
        }
        if (queryType == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TE_NULL_STRING_PARA, "");
        }
        if (!queryType.equalsIgnoreCase(TYPE_XQL)) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TE_UNSUPPORTED_TYPE, "", queryType);
        }
        GenerateXQLQueryString gr = new GenerateXQLQueryString(doc, nodeId, attribute, textQuery, nsDecls);
        String query = gr.getQuery();
        return query;
    }

    public String getType() {
        if (this instanceof ConstantExpression) {
            return TYPE_CONSTANT;
        }
        if (this instanceof ORNReference) {
            return "WQL";
        }
        if (this instanceof VarNameExpression) {
            return TYPE_VARNAME;
        }
        if (this instanceof XqlQuery) {
            return TYPE_XQL;
        }
        throw new LocalizedRuntimeException(XqlExceptionBundle.class, XqlExceptionBundle.TE_UNKNOWN_TYPE, "");
    }

    public abstract String getExpression();

    public boolean appendXmlExpression(StringBuffer sb, int tabLevel) {
        sb.append(CharDefs.getXmlContent(this.getExpression()));
        return false;
    }

    public void setNamespace(String namespace) {
    }

    public String getNamespace() {
        return null;
    }

    public TreeExpression getSubstitution(Values variables) throws WattException {
        return this;
    }

    public String toString() {
        return "<TreeExpression: type='" + this.getType() + "', expression='" + this.getExpression() + "'>";
    }

    public String getString(Object tree) throws WattException, WMDocumentException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public String[] getStringArray(Object tree) throws WattException, WMDocumentException {
        throw new WattEvaluationException(MSG_TYPE_UNAVAILABLE);
    }

    public String[][] getStringTable(Object tree) throws WattException, WMDocumentException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public String getStringWithIdentities(Object tree) throws WattException, WMDocumentException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public String[] getStringArrayWithIdentities(Object tree) throws WattException, WMDocumentException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public String[][] getStringTableWithIdentities(Object tree) throws WattException, WMDocumentException {
        throw new WattEvaluationException(MSG_TYPE_UNAVAILABLE);
    }

    public Values getValues(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Values[] getValuesArray(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Values[][] getValuesTable(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Node getNode(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Node[] getNodeArray(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Node[][] getNodeTable(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Node getNodeWithIdentities(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Node[] getNodeArrayWithIdentities(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Node[][] getNodeTableWithIdentities(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public IData getIData(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public IData[] getIDataArray(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public IData getIDataWithIdentities(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public IData[] getIDataArrayWithIdentities(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Object getObject(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Object getObjectWithIdentities(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Object[] getObjectArray(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Object[] getObjectArrayWithIdentities(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Object getBestResultsWithIdentities(Object tree) throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public String getBestResultType() throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }

    public Object getIdentities() throws WattException {
        throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TYPE_UNAVAILABLE, "");
    }
}

