/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.util.IntegerList;
import com.wm.util.List;

public final class ResultSet {
    int valueCount;
    int dimensions;
    List values;
    IntegerList positions;
    boolean pooled;

    static ResultSet mergeRemoveDups(ResultSet setA, ResultSet setB, boolean usePositionDups) {
        int sizeA = setA.getSize();
        if (sizeA == 0) {
            return setB;
        }
        int sizeB = setB.getSize();
        if (sizeB == 0) {
            return setA;
        }
        ResultSet mergedSet = new ResultSet(sizeA + sizeB + 1);
        int indexA = 0;
        int indexB = 0;
        int posA = setA.getPosition(0);
        int posB = setB.getPosition(0);
        boolean oneSetCompletelyCopied = false;
        while (!oneSetCompletelyCopied) {
            if (posA < posB) {
                mergedSet.addValue(setA.getValue(indexA++), posA);
                if (indexA < sizeA) {
                    posA = setA.getPosition(indexA);
                    continue;
                }
                oneSetCompletelyCopied = true;
                continue;
            }
            if (posB < posA) {
                mergedSet.addValue(setB.getValue(indexB++), posB);
                if (indexB < sizeB) {
                    posB = setB.getPosition(indexB);
                    continue;
                }
                oneSetCompletelyCopied = true;
                continue;
            }
            if (usePositionDups) {
                mergedSet.addValue(setA.getValue(indexA++), posA);
                if (indexA < sizeA) {
                    posA = setA.getPosition(indexA);
                } else {
                    oneSetCompletelyCopied = true;
                }
                if (++indexB < sizeB) {
                    posB = setB.getPosition(indexB);
                    continue;
                }
                oneSetCompletelyCopied = true;
                continue;
            }
            int samePosition = posA;
            int startOfSamePosition = mergedSet.getSize();
            do {
                mergedSet.addValue(setA.getValue(indexA++), samePosition);
            } while (indexA < sizeA && (posA = setA.getPosition(indexA)) == samePosition);
            int pastEndOfSamePosition = indexA;
            do {
                Object value = setB.getValue(indexB);
                indexA = startOfSamePosition;
                boolean duplicateFound = false;
                do {
                    if (setA.getValue(indexA++) != value) continue;
                    duplicateFound = true;
                } while (indexA != pastEndOfSamePosition && !duplicateFound);
                if (duplicateFound) continue;
                mergedSet.addValue(value, samePosition);
            } while (++indexB < sizeB && (posB = setB.getPosition(indexB)) == samePosition);
            if (indexA == sizeA || indexB == sizeB) {
                oneSetCompletelyCopied = true;
            }
            indexA = pastEndOfSamePosition;
        }
        while (indexA < sizeA) {
            mergedSet.addValue(setA, indexA++);
        }
        while (indexB < sizeB) {
            mergedSet.addValue(setB, indexB++);
        }
        return mergedSet;
    }

    static ResultSet mergeKeepDups(ResultSet setA, ResultSet setB) {
        int sizeA = setA.getSize();
        if (sizeA == 0) {
            return setB;
        }
        int sizeB = setB.getSize();
        if (sizeB == 0) {
            return setA;
        }
        ResultSet mergedSet = new ResultSet(sizeA + sizeB + 1);
        int indexA = 0;
        int indexB = 0;
        int posA = setA.getPosition(0);
        int posB = setB.getPosition(0);
        boolean oneSetCompletelyCopied = false;
        while (!oneSetCompletelyCopied) {
            if (posA <= posB) {
                mergedSet.addValue(setA.getValue(indexA++), posA);
                if (indexA < sizeA) {
                    posA = setA.getPosition(indexA);
                    continue;
                }
                oneSetCompletelyCopied = true;
                continue;
            }
            mergedSet.addValue(setB.getValue(indexB++), posB);
            if (indexB < sizeB) {
                posB = setB.getPosition(indexB);
                continue;
            }
            oneSetCompletelyCopied = true;
        }
        while (indexA < sizeA) {
            mergedSet.addValue(setA, indexA++);
        }
        while (indexB < sizeB) {
            mergedSet.addValue(setB, indexB++);
        }
        return mergedSet;
    }

    public ResultSet() {
        this.values = new List();
        this.positions = new IntegerList();
    }

    public ResultSet(int initialSize) {
        this.values = new List(initialSize);
        this.positions = new IntegerList(initialSize);
    }

    public int getSize() {
        return this.values.size();
    }

    public Object getValue(int index) {
        return this.values.elementAt(index);
    }

    public int getPosition(int index) {
        return this.positions.integerAt(index);
    }

    public void addValue(Object value, int position) {
        this.values.addElement(value);
        this.positions.addInteger(position);
    }

    public void addValue(ResultSet sourceSet, int index) {
        if (index < sourceSet.getSize()) {
            this.values.addElement(sourceSet.getValue(index));
            this.positions.addInteger(sourceSet.getPosition(index));
        } else {
            this.values.addElement(null);
            this.positions.addInteger(-1);
        }
    }

    public void addValues(ResultSet sourceSet) {
        int numValues = sourceSet.getSize();
        for (int index = 0; index < numValues; ++index) {
            this.values.addElement(sourceSet.getValue(index));
            this.positions.addInteger(sourceSet.getPosition(index));
        }
    }

    public boolean isPooled() {
        return this.pooled;
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public void reset() {
        this.values.reset();
        this.positions.reset();
    }
}

