/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xql.ObjectModel;
import com.wm.lang.xql.Relation;
import com.wm.lang.xql.Typecaster;
import com.wm.lang.xql.TypedValue;
import com.wm.lang.xql.resources.XqlExceptionBundle;

final class RelationSpec {
    boolean isModelSpecific;
    int leftType;
    Typecaster leftCaster;
    int relationType;
    Relation sourceRelation;
    int rightType;
    Typecaster rightCaster;

    RelationSpec(int leftType, int relationType, int rightType) throws WattExpressionException {
        this.leftType = leftType;
        this.relationType = relationType;
        this.rightType = rightType;
        if (leftType == 5 || leftType == 6) {
            this.isModelSpecific = true;
            leftType = 3;
        }
        if (rightType == 5 || rightType == 6) {
            this.isModelSpecific = true;
            rightType = 3;
        }
        this.leftCaster = Typecaster.getTypecaster(leftType, rightType);
        this.rightCaster = Typecaster.getTypecaster(rightType, leftType);
        if (this.leftCaster == null || this.rightCaster == null) {
            Object[] sArray = new String[]{TypedValue.getTypeString(leftType), TypedValue.getTypeString(rightType)};
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.RSPEC_TYPE_NOT_COMPARABLE, "", sArray);
        }
        this.sourceRelation = Relation.getRelation(relationType, this.leftCaster.getResultType());
        if (this.sourceRelation == null) {
            Object[] sArray = new String[]{Relation.getTypeString(relationType), TypedValue.getTypeString(this.leftCaster.getResultType())};
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.RSPEC_RELATION_NOT_DEFINED, "", sArray);
        }
    }

    Relation getRelation(ObjectModel model) {
        if (this.isModelSpecific) {
            return model.getRelation(this);
        }
        Relation r = this.sourceRelation.getClone();
        r.setLCaster(this.leftCaster);
        r.setRCaster(this.rightCaster);
        return r;
    }
}

