/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ObjectModel;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.Relation;
import com.wm.lang.xql.RelationSpec;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.SubscriptArgument;
import com.wm.util.List;

final class QueryContext {
    ObjectModel model;
    Object rootNode;
    boolean rootNodeIsHtml;
    ResultSet rootResultSet;
    int[][] integerArrays;
    Relation[] relations;
    SubscriptArgument[][] subscriptArgArrays;
    List resultSets = new List();
    List referenceNodes = new List();

    QueryContext(ObjectModel model, ParsedQuery parse, Object rootNode) throws WMDocumentException {
        RelationSpec[] relationSpecs;
        this.model = model;
        int[] arraySizes = parse.getIntegerArraySizes();
        int index = arraySizes.length;
        if (index > 0) {
            this.integerArrays = new int[index][];
            while (index-- != 0) {
                this.integerArrays[index] = new int[arraySizes[index]];
            }
        }
        if ((index = (relationSpecs = parse.getRelationSpecs()).length) > 0) {
            this.relations = new Relation[index];
            while (index-- != 0) {
                this.relations[index] = relationSpecs[index].getRelation(model);
            }
        }
        if ((index = (arraySizes = parse.getSubscriptArgArraySizes()).length) > 0) {
            this.subscriptArgArrays = new SubscriptArgument[index][];
            while (index-- != 0) {
                this.subscriptArgArrays[index] = new SubscriptArgument[arraySizes[index]];
            }
        }
        this.rootNode = rootNode;
        this.rootResultSet = new ResultSet(2);
        this.rootResultSet.addValue(rootNode, 0);
        this.rootNodeIsHtml = model.isHtml(rootNode);
    }

    ObjectModel getModel() {
        return this.model;
    }

    boolean queryingHtml() {
        return this.rootNodeIsHtml;
    }

    int[] getIntegerArray(int arrayIndex) {
        return this.integerArrays[arrayIndex];
    }

    Relation getRelation(int relationIndex) {
        return this.relations[relationIndex];
    }

    SubscriptArgument[] getSubscriptArgumentArray(int arrayIndex) {
        return this.subscriptArgArrays[arrayIndex];
    }

    Object getRootNode() {
        return this.rootNode;
    }

    ResultSet getResultSet() {
        ResultSet resultSet;
        if (this.resultSets.size() == 0) {
            resultSet = new ResultSet();
            resultSet.setPooled(true);
        } else {
            resultSet = (ResultSet)this.resultSets.removeLastElement();
            resultSet.reset();
        }
        return resultSet;
    }

    ReferenceNode getReferenceNode() {
        ReferenceNode refNode;
        if (this.referenceNodes.size() == 0) {
            refNode = new ReferenceNode();
            refNode.setPooled(true);
        } else {
            refNode = (ReferenceNode)this.referenceNodes.removeLastElement();
        }
        return refNode;
    }

    ReferenceNode getRootReferenceNode() {
        ReferenceNode rootRefNode = this.getReferenceNode();
        rootRefNode.assign(this.rootResultSet, 0);
        return rootRefNode;
    }

    void putResultSet(ResultSet resultSet) {
        if (resultSet.isPooled()) {
            this.resultSets.addElement(resultSet);
        }
    }

    void putReferenceNode(ReferenceNode refNode) {
        if (refNode.isPooled()) {
            this.referenceNodes.addElement(refNode);
        }
    }
}

