/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedComparison;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.XqlTokenBuffer;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;
import com.wm.util.Values;

class ParsedUnion
extends ParsedExpression {
    boolean removeDuplicates;
    boolean usePositionDups;
    ParsedExpression[] operands;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ParsedExpression parse = ParsedComparison.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
        ExpressionToken token = tokens.getCurrent();
        if (ParsedUnion.checkForUnionToken(token)) {
            List parseList = new List();
            parseList.addElement(parse);
            int resultType = parse.getResultType();
            do {
                tokens.advance();
                parse = ParsedComparison.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
                parseList.addElement(parse);
            } while (ParsedUnion.checkForUnionToken(token = tokens.getCurrent()));
            int iLen = parseList.size();
            for (int i = 0; i < iLen; ++i) {
                parse = (ParsedExpression)parseList.elementAt(i);
                if (parse.getResultType() == resultType) continue;
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.UNION_SAME_TYPE, "");
            }
            parse = new ParsedUnion(parseList, resultType);
            parsedQuery.needNodePositions();
        }
        return parse;
    }

    private static boolean checkForUnionToken(ExpressionToken token) throws WattExpressionException {
        return token != null && (token.getType() == 304 || token.getType() == 104 && XqlTokenBuffer.stringToOperatorToken(token.getString()) == 304);
    }

    ParsedUnion(List parseList, int resultType) {
        this.operands = new ParsedExpression[parseList.size()];
        int iLength = this.operands.length;
        for (int i = 0; i < iLength; ++i) {
            this.operands[i] = (ParsedExpression)parseList.elementAt(i);
        }
        if (resultType == 5 || resultType == 6) {
            this.removeDuplicates = true;
        }
        if (resultType == 6) {
            this.usePositionDups = true;
        }
    }

    int getResultType() {
        return this.operands[0].getResultType();
    }

    boolean isRelative() {
        int opIndex = this.operands.length;
        while (opIndex-- != 0) {
            if (this.operands[opIndex].isRelative()) continue;
            return false;
        }
        return true;
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        results.addValues(this.getResults(cx, refNode));
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        int i = this.operands.length;
        ReferenceNode saveRefNode = cx.getReferenceNode();
        refNode.getMembers(saveRefNode);
        while (i-- != 0) {
            if (this.operands[i].getBoolean(cx, refNode)) {
                cx.putReferenceNode(saveRefNode);
                return true;
            }
            refNode.setMembers(saveRefNode);
        }
        cx.putReferenceNode(saveRefNode);
        return false;
    }

    ResultSet getResults(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ResultSet firstOperandResults;
        ReferenceNode saveRefNode = cx.getReferenceNode();
        refNode.getMembers(saveRefNode);
        ResultSet mergeResults = firstOperandResults = this.operands[0].getResults(cx, refNode);
        int iLength = this.operands.length;
        for (int i = 1; i < iLength; ++i) {
            refNode.setMembers(saveRefNode);
            ResultSet operandResults = this.operands[i].getResults(cx, refNode);
            mergeResults = this.removeDuplicates ? ResultSet.mergeRemoveDups(mergeResults, operandResults, this.usePositionDups) : ResultSet.mergeKeepDups(mergeResults, operandResults);
            cx.putResultSet(operandResults);
        }
        cx.putResultSet(firstOperandResults);
        cx.putReferenceNode(saveRefNode);
        return mergeResults;
    }

    String toXmlString(int t) {
        StringBuffer sb = new StringBuffer();
        sb.append(ParsedUnion.tab(t) + "<UNION>\n");
        for (int i = 0; i < this.operands.length; ++i) {
            sb.append(this.operands[i].toXmlString(t + 1));
        }
        sb.append(ParsedUnion.tab(t) + "</UNION>\n");
        return sb.toString();
    }

    String toXqlString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.operands[0].toXqlString());
        for (int i = 1; i < this.operands.length; ++i) {
            sb.append(" | " + this.operands[i].toXqlString());
        }
        sb.append(')');
        return sb.toString();
    }
}

