/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.StringToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;

class ParsedText
extends ParsedExpression {
    ResultSet constantResult = new ResultSet(2);
    String stringObject;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery) throws WattExpressionException {
        StringToken token = (StringToken)tokens.getCurrent();
        tokens.advance();
        return new ParsedText(token.getString());
    }

    ParsedText(String stringValue) {
        this.stringObject = stringValue;
        this.constantResult.addValue(this.stringObject, 0);
    }

    String getText() {
        return this.stringObject;
    }

    int getResultType() {
        return 3;
    }

    boolean isRelative() {
        return true;
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException {
        results.addValue(this.stringObject, 0);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException {
        return true;
    }

    ResultSet getResults(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException {
        return this.constantResult;
    }

    String toXmlString(int t) {
        return ParsedText.tab(t) + "<text>" + this.stringObject + "</text>\n";
    }

    String toXqlString() {
        if (this.stringObject.indexOf(34) >= 0) {
            return "'" + this.stringObject + "'";
        }
        return "\"" + this.stringObject + "\"";
    }
}

