/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.IndexRange;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedFilter;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.SingleIndex;
import com.wm.lang.xql.SubscriptArgument;
import com.wm.lang.xql.XqlTokenBuffer;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;
import com.wm.util.Values;

class ParsedSubscript
extends ParsedExpression {
    ParsedExpression leftOperand;
    boolean mixesPositiveAndNegativeArgs;
    SubscriptArgument[] positiveArgs;
    SubscriptArgument[] negativeArgs;
    int[] positiveFirstIndexes;
    int[] negativeFirstIndexes;
    int negativeIndexesArrayIndex;
    int sortedArgsArrayIndex;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ParsedExpression parse = ParsedFilter.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
        ExpressionToken token = tokens.getCurrent();
        if (token != null && token.getType() == 311) {
            token = tokens.next();
            if (token != null && token.getType() == 312) {
                tokens.advance();
            } else {
                List argumentList = new List();
                argumentList.addElement(ParsedSubscript.getNextArgument(tokens));
                token = tokens.getCurrent();
                while (token != null && token.getType() == 103) {
                    tokens.advance();
                    argumentList.addElement(ParsedSubscript.getNextArgument(tokens));
                    token = tokens.getCurrent();
                }
                if (token == null || token.getType() != 312) {
                    throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.BRACET_NOT_MATCH, "");
                }
                tokens.advance();
                parse = new ParsedSubscript(parsedQuery, parse, argumentList);
            }
        }
        return parse;
    }

    static boolean checkForToToken(ExpressionToken token) throws WattExpressionException {
        return token != null && (token.getType() == 106 || token.getType() == 104 && XqlTokenBuffer.stringToOperatorToken(token.getString()) == 106);
    }

    static SubscriptArgument getNextArgument(TokenBuffer tokens) throws WattExpressionException {
        SubscriptArgument argument;
        ExpressionToken token = tokens.getCurrent();
        if (token == null || token.getType() != 202) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.SUBSCRIPT_INVALID_ARGUMENT, "");
        }
        int firstIndex = token.getInteger();
        token = tokens.next();
        if (ParsedSubscript.checkForToToken(token)) {
            token = tokens.next();
            if (token == null || token.getType() != 202) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.SUBSCRIPT_INVALID_ARGUMENT, "");
            }
            argument = new IndexRange(firstIndex, token.getInteger());
            tokens.advance();
        } else {
            argument = new SingleIndex(firstIndex);
        }
        return argument;
    }

    static SubscriptArgument[] getSortedArgArray(List argList) {
        int i;
        SubscriptArgument[] argArray = new SubscriptArgument[argList.size()];
        int length = argArray.length;
        for (i = 0; i < length; ++i) {
            argArray[i] = (SubscriptArgument)argList.elementAt(i);
        }
        if (argArray.length > 1) {
            for (int bubbleTo = argArray.length - 2; bubbleTo >= 0; --bubbleTo) {
                for (i = 0; i <= bubbleTo; ++i) {
                    if (argArray[i + 1].getFirstIndex() >= argArray[i].getFirstIndex()) continue;
                    SubscriptArgument tempArg = argArray[i + 1];
                    argArray[i + 1] = argArray[i];
                    argArray[i] = tempArg;
                }
            }
        }
        return argArray;
    }

    ParsedSubscript(ParsedQuery parsedQuery, ParsedExpression leftOperand, List argumentList) {
        int length;
        int argNum;
        this.leftOperand = leftOperand;
        List positiveArgList = new List();
        List negativeArgList = new List();
        int size = argumentList.size();
        for (argNum = 0; argNum < size; ++argNum) {
            SubscriptArgument argument = (SubscriptArgument)argumentList.elementAt(argNum);
            if (argument.getFirstIndex() >= 0) {
                positiveArgList.addElement(argument);
                continue;
            }
            negativeArgList.addElement(argument);
        }
        if (positiveArgList.size() > 0) {
            this.positiveArgs = ParsedSubscript.getSortedArgArray(positiveArgList);
            length = this.positiveArgs.length;
            this.positiveFirstIndexes = new int[length];
            for (argNum = 0; argNum < length; ++argNum) {
                this.positiveFirstIndexes[argNum] = this.positiveArgs[argNum].getFirstIndex();
            }
        }
        if (negativeArgList.size() > 0) {
            this.negativeArgs = ParsedSubscript.getSortedArgArray(negativeArgList);
            length = this.negativeArgs.length;
            this.negativeFirstIndexes = new int[length];
            for (argNum = 0; argNum < length; ++argNum) {
                this.negativeFirstIndexes[argNum] = this.negativeArgs[argNum].getFirstIndex();
            }
            if (this.positiveArgs != null) {
                this.mixesPositiveAndNegativeArgs = true;
                this.negativeIndexesArrayIndex = parsedQuery.addIntegerArray(length);
                this.sortedArgsArrayIndex = parsedQuery.addSubscriptArgumentArray(this.positiveArgs.length + length);
            }
        }
    }

    int getResultType() {
        return this.leftOperand.getResultType();
    }

    boolean isRelative() {
        return this.leftOperand.isRelative();
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        ResultSet leftSet = this.leftOperand.getResults(cx, refNode);
        int leftSetSize = leftSet.getSize();
        if (leftSetSize != 0) {
            int argNum;
            SubscriptArgument[] arguments;
            if (this.mixesPositiveAndNegativeArgs) {
                arguments = cx.getSubscriptArgumentArray(this.sortedArgsArrayIndex);
                int[] negativeActualIndexes = cx.getIntegerArray(this.negativeIndexesArrayIndex);
                argNum = this.negativeArgs.length;
                while (argNum != 0) {
                    negativeActualIndexes[--argNum] = this.negativeFirstIndexes[argNum] + leftSetSize;
                }
                int posArgNum = 0;
                int negArgNum = 0;
                int pLength = this.positiveArgs.length;
                int nLength = this.negativeArgs.length;
                while (posArgNum < pLength && negArgNum < nLength) {
                    if (this.positiveFirstIndexes[posArgNum] <= negativeActualIndexes[negArgNum]) {
                        arguments[argNum++] = this.positiveArgs[posArgNum++];
                        continue;
                    }
                    arguments[argNum++] = this.negativeArgs[negArgNum++];
                }
                while (posArgNum < pLength) {
                    arguments[argNum++] = this.positiveArgs[posArgNum++];
                }
                while (negArgNum < nLength) {
                    arguments[argNum++] = this.negativeArgs[negArgNum++];
                }
            } else {
                arguments = this.positiveArgs != null ? this.positiveArgs : this.negativeArgs;
            }
            int prevMaxIndex = Integer.MIN_VALUE;
            for (argNum = 0; argNum < arguments.length; ++argNum) {
                prevMaxIndex = arguments[argNum].addToResults(prevMaxIndex, leftSet, results);
            }
        }
        cx.putResultSet(leftSet);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ResultSet leftSet = this.getResults(cx, refNode);
        if (leftSet.getSize() != 0) {
            int argNum;
            int length = this.positiveArgs.length;
            for (argNum = 0; argNum < length; ++argNum) {
                if (!this.positiveArgs[argNum].getBoolean(leftSet)) continue;
                cx.putResultSet(leftSet);
                return true;
            }
            if (this.negativeArgs != null) {
                int nLength = this.negativeArgs.length;
                for (argNum = 0; argNum < nLength; ++argNum) {
                    if (!this.negativeArgs[argNum].getBoolean(leftSet)) continue;
                    cx.putResultSet(leftSet);
                    return true;
                }
            }
        }
        cx.putResultSet(leftSet);
        return false;
    }

    String toXmlString(int t) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(ParsedSubscript.tab(t) + "<SUBSCRIPT>\n");
        sb.append(this.leftOperand.toXmlString(t + 1));
        for (i = 0; i < this.positiveArgs.length; ++i) {
            sb.append(ParsedSubscript.tab(t + 1) + this.positiveArgs[i].toXmlString());
        }
        for (i = 0; i < this.negativeArgs.length; ++i) {
            sb.append(ParsedSubscript.tab(t + 1) + this.negativeArgs[i].toXmlString());
        }
        sb.append(ParsedSubscript.tab(t) + "</SUBSCRIPT>\n");
        return sb.toString();
    }

    String toXqlString() {
        int i;
        int length;
        StringBuffer sb = new StringBuffer();
        boolean firstArg = true;
        sb.append(this.leftOperand.toXqlString() + "[");
        if (this.positiveArgs != null) {
            length = this.positiveArgs.length;
            for (i = 0; i < length; ++i) {
                if (!firstArg) {
                    sb.append(',');
                }
                sb.append(this.positiveArgs[i].toXqlString());
                firstArg = false;
            }
        }
        if (this.negativeArgs != null) {
            length = this.negativeArgs.length;
            for (i = 0; i < length; ++i) {
                if (!firstArg) {
                    sb.append(',');
                }
                sb.append(this.negativeArgs[i].toXqlString());
                firstArg = false;
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

