/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.ParsedRecursiveDescender;
import com.wm.lang.xql.ParsedRelativeChildPath;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;
import com.wm.util.Values;

class ParsedRelativeDescendantPath
extends ParsedRecursiveDescender {
    ParsedExpression leftOperand;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ParsedExpression parse = ParsedRelativeChildPath.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
        ExpressionToken token = tokens.getCurrent();
        if (token != null && token.getType() == 308) {
            if (parse.getResultType() != 5) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.RDPATH_NODE, "");
            }
            tokens.advance();
            parse = new ParsedRelativeDescendantPath(parse, ParsedRelativeDescendantPath.createXql(tokens, parsedQuery, parse.getResultType(), namespaceHash));
            if (!parse.isRelative()) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.RCPATH_ONLY_RELATIVE, "");
            }
            parsedQuery.needNodePositions();
        }
        return parse;
    }

    ParsedRelativeDescendantPath(ParsedExpression leftOperand, ParsedExpression rightOperand) {
        super(rightOperand);
        this.leftOperand = leftOperand;
    }

    int getResultType() {
        return this.descentOperand.getResultType();
    }

    boolean isRelative() {
        return this.descentOperand.isRelative();
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        ResultSet subset = this.getResults(cx, refNode);
        results.addValues(subset);
        cx.putResultSet(subset);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ResultSet leftSet = this.leftOperand.getResults(cx, refNode);
        int leftResultSize = leftSet.getSize();
        if (leftResultSize == 0) {
            cx.putResultSet(leftSet);
            return false;
        }
        for (int iCtr = 0; iCtr < leftResultSize; ++iCtr) {
            refNode.assign(leftSet, iCtr);
            if (!this.descendForBoolean(cx, refNode)) continue;
            cx.putResultSet(leftSet);
            return true;
        }
        cx.putResultSet(leftSet);
        return false;
    }

    ResultSet getResults(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ResultSet leftSet = this.leftOperand.getResults(cx, refNode);
        int leftResultSize = leftSet.getSize();
        if (leftResultSize == 0) {
            return this.emptySet;
        }
        List resultSubsets = new List();
        ResultSet subset = cx.getResultSet();
        resultSubsets.addElement(subset);
        ReferenceNode saveRefNode = cx.getReferenceNode();
        for (int iCtr = 0; iCtr < leftResultSize; ++iCtr) {
            refNode.assign(leftSet, iCtr);
            if (refNode.getNode() == null) continue;
            refNode.getMembers(saveRefNode);
            this.descentOperand.addToResults(cx, refNode, subset);
            refNode.setMembers(saveRefNode);
            this.descendForSubsets(cx, refNode, resultSubsets, 1);
            refNode.setMembers(saveRefNode);
        }
        cx.putResultSet(leftSet);
        cx.putReferenceNode(saveRefNode);
        ResultSet results = this.mergeSubsets(resultSubsets);
        this.freeSubsets(cx, resultSubsets);
        return results;
    }

    String toXmlString(int t) {
        StringBuffer sb = new StringBuffer();
        sb.append(ParsedRelativeDescendantPath.tab(t) + "<DESCENDANT>\n");
        sb.append(this.leftOperand.toXmlString(t + 1));
        sb.append(this.descentOperand.toXmlString(t + 1));
        sb.append(ParsedRelativeDescendantPath.tab(t) + "</DESCENDANT>\n");
        return sb.toString();
    }

    String toXqlString() {
        return this.leftOperand.toXqlString() + "//" + this.descentOperand.toXqlString();
    }
}

