/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedMethod;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.Values;

class ParsedRelativeChildPath
extends ParsedExpression {
    ParsedExpression leftOperand;
    ParsedExpression rightOperand;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ParsedExpression parse = ParsedMethod.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
        ExpressionToken token = tokens.getCurrent();
        if (token != null && token.getType() == 307) {
            if (parse.getResultType() != 5 && parse.getResultType() != 6) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.RCPATH_NODE_ATTRI, "");
            }
            tokens.advance();
            parse = new ParsedRelativeChildPath(parse, ParsedRelativeChildPath.createXql(tokens, parsedQuery, parse.getResultType(), namespaceHash));
            if (!parse.isRelative()) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.RCPATH_ONLY_RELATIVE, "");
            }
        }
        return parse;
    }

    ParsedRelativeChildPath(ParsedExpression leftOperand, ParsedExpression rightOperand) {
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
    }

    int getResultType() {
        return this.rightOperand.getResultType();
    }

    boolean isRelative() {
        return this.rightOperand.isRelative();
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        ResultSet subset = this.getResults(cx, refNode);
        results.addValues(subset);
        cx.putResultSet(subset);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ResultSet leftSet = this.leftOperand.getResults(cx, refNode);
        int leftResultSize = leftSet.getSize();
        if (leftResultSize == 0) {
            cx.putResultSet(leftSet);
            return false;
        }
        for (int iCtr = 0; iCtr < leftResultSize; ++iCtr) {
            refNode.assign(leftSet, iCtr);
            if (!this.rightOperand.getBoolean(cx, refNode)) continue;
            cx.putResultSet(leftSet);
            return true;
        }
        cx.putResultSet(leftSet);
        return false;
    }

    ResultSet getResults(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ResultSet leftSet = this.leftOperand.getResults(cx, refNode);
        int leftResultSize = leftSet.getSize();
        if (leftResultSize == 0) {
            return this.emptySet;
        }
        ResultSet results = cx.getResultSet();
        for (int iCtr = 0; iCtr < leftResultSize; ++iCtr) {
            refNode.assign(leftSet, iCtr);
            if (refNode.getNode() == null) continue;
            this.rightOperand.addToResults(cx, refNode, results);
        }
        cx.putResultSet(leftSet);
        return results;
    }

    String toXmlString(int t) {
        StringBuffer sb = new StringBuffer();
        sb.append(ParsedRelativeChildPath.tab(t) + "<CHILD>\n");
        sb.append(this.leftOperand.toXmlString(t + 1));
        sb.append(this.rightOperand.toXmlString(t + 1));
        sb.append(ParsedRelativeChildPath.tab(t) + "</CHILD>\n");
        return sb.toString();
    }

    String toXqlString() {
        return this.leftOperand.toXqlString() + "/" + this.rightOperand.toXqlString();
    }
}

