/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ObjectModel;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.util.List;

abstract class ParsedRecursiveDescender
extends ParsedExpression {
    int resultType;
    ParsedExpression descentOperand;

    ParsedRecursiveDescender(ParsedExpression descentOperand) {
        this.descentOperand = descentOperand;
        this.resultType = this.getResultType();
    }

    boolean descendForBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ObjectModel model = cx.getModel();
        ResultSet children = cx.getResultSet();
        model.addChildren(refNode.getNode(), children);
        if (children != null) {
            ParsedExpression operand = this.descentOperand;
            int childCount = children.getSize();
            for (int index = 0; index < childCount; ++index) {
                refNode.assign(children, index);
                if (operand.getBoolean(cx, refNode)) {
                    cx.putResultSet(children);
                    return true;
                }
                if (!this.descendForBoolean(cx, refNode)) continue;
                cx.putResultSet(children);
                return true;
            }
            cx.putResultSet(children);
        }
        return false;
    }

    void descendForSubsets(QueryContext cx, ReferenceNode refNode, List subsets, int depthOfRefNode) throws WattEvaluationException, WMDocumentException {
        ObjectModel model = cx.getModel();
        ResultSet children = cx.getResultSet();
        model.addChildren(refNode.getNode(), children);
        int childCount = children.getSize();
        if (children != null && childCount > 0) {
            ResultSet subset;
            ParsedExpression operand = this.descentOperand;
            if (depthOfRefNode == subsets.size()) {
                subset = cx.getResultSet();
                subsets.addElement(subset);
            } else {
                subset = (ResultSet)subsets.elementAt(depthOfRefNode);
            }
            ReferenceNode saveRefNode = cx.getReferenceNode();
            for (int index = 0; index < childCount; ++index) {
                refNode.assign(children, index);
                refNode.getMembers(saveRefNode);
                operand.addToResults(cx, refNode, subset);
                refNode.setMembers(saveRefNode);
                this.descendForSubsets(cx, refNode, subsets, depthOfRefNode + 1);
                refNode.setMembers(saveRefNode);
            }
            cx.putReferenceNode(saveRefNode);
            cx.putResultSet(children);
        }
    }

    void freeSubsets(QueryContext cx, List subsets) {
        int index = subsets.size();
        while (index-- != 0) {
            cx.putResultSet((ResultSet)subsets.elementAt(index));
        }
    }

    ResultSet mergeSubsets(List resultSubsets) {
        int listIndex = resultSubsets.size();
        if (listIndex == 0) {
            return this.emptySet;
        }
        ResultSet results = (ResultSet)resultSubsets.elementAt(--listIndex);
        while (--listIndex >= 0) {
            results = ResultSet.mergeKeepDups(results, (ResultSet)resultSubsets.elementAt(listIndex));
        }
        resultSubsets.removeElement(results);
        return results;
    }
}

