/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedDisjunction;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.RelationSpec;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.XqlTokenBuffer;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;
import com.wm.util.Values;

final class ParsedQuery
extends ParsedExpression {
    ParsedExpression operand;
    int[] integerArraySizes;
    RelationSpec[] relationSpecArray;
    int[] subscriptArgArraySizes;
    List integerArraySizeList = new List();
    List relationSpecList = new List();
    List subscriptArgArraySizeList = new List();
    int resultType;
    boolean needNodePositions;

    ParsedQuery(String queryType, String query, Values namespaceHash) throws WattExpressionException {
        int i;
        if (queryType == "XQL") {
            XqlTokenBuffer tokens = new XqlTokenBuffer(query);
            this.operand = ParsedDisjunction.createXql(tokens, this, 5, namespaceHash);
            if (tokens.getCurrent() != null) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.PQ_CONTAIN_EX_TERMS, "");
            }
        } else {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.PQ_INVALID_TYPE, "", queryType);
        }
        this.resultType = this.operand.getResultType();
        this.integerArraySizes = new int[this.integerArraySizeList.size()];
        int length = this.integerArraySizes.length;
        for (i = 0; i < length; ++i) {
            this.integerArraySizes[i] = (Integer)this.integerArraySizeList.elementAt(i);
        }
        this.integerArraySizeList = null;
        this.relationSpecArray = new RelationSpec[this.relationSpecList.size()];
        length = this.relationSpecArray.length;
        for (i = 0; i < length; ++i) {
            this.relationSpecArray[i] = (RelationSpec)this.relationSpecList.elementAt(i);
        }
        this.relationSpecList = null;
        this.subscriptArgArraySizes = new int[this.subscriptArgArraySizeList.size()];
        length = this.subscriptArgArraySizes.length;
        for (i = 0; i < length; ++i) {
            this.subscriptArgArraySizes[i] = (Integer)this.subscriptArgArraySizeList.elementAt(i);
        }
        this.subscriptArgArraySizeList = null;
    }

    int addIntegerArray(int arraySize) {
        this.integerArraySizeList.addElement(new Integer(arraySize));
        return this.integerArraySizeList.size() - 1;
    }

    int addRelationSpec(RelationSpec relationSpec) {
        this.relationSpecList.addElement(relationSpec);
        return this.relationSpecList.size() - 1;
    }

    int addSubscriptArgumentArray(int arraySize) {
        this.subscriptArgArraySizeList.addElement(new Integer(arraySize));
        return this.subscriptArgArraySizeList.size() - 1;
    }

    int[] getIntegerArraySizes() {
        return this.integerArraySizes;
    }

    RelationSpec[] getRelationSpecs() {
        return this.relationSpecArray;
    }

    int[] getSubscriptArgArraySizes() {
        return this.subscriptArgArraySizes;
    }

    int getResultType() {
        return this.resultType;
    }

    boolean isRelative() {
        return this.operand.isRelative();
    }

    void needNodePositions() {
        this.needNodePositions = true;
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        if (this.needNodePositions) {
            cx.getModel().needNodePositions();
        }
        this.operand.addToResults(cx, refNode, results);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        if (this.needNodePositions) {
            cx.getModel().needNodePositions();
        }
        return this.operand.getBoolean(cx, refNode);
    }

    public String toXmlString() {
        return this.toXmlString(0);
    }

    String toXmlString(int t) {
        return this.operand.toXmlString(t);
    }

    String toXqlString() {
        return this.operand.toXqlString();
    }
}

