/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.ParsedUnion;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.util.Values;

class ParsedNegation
extends ParsedExpression {
    ParsedExpression operand;
    boolean negate;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ExpressionToken token = tokens.getCurrent();
        boolean negate = false;
        boolean castToBoolean = false;
        while (token != null && token.getType() == 303) {
            castToBoolean = true;
            negate = !negate;
            token = tokens.next();
        }
        ParsedExpression parse = ParsedUnion.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
        if (castToBoolean) {
            parse = new ParsedNegation(negate, parse);
        }
        return parse;
    }

    ParsedNegation(boolean negate, ParsedExpression operand) {
        this.negate = negate;
        this.operand = operand;
    }

    int getResultType() {
        return 0;
    }

    boolean isRelative() {
        return this.operand.isRelative();
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        results.addValue(new Boolean(this.getBoolean(cx, refNode)), refNode.getPosition());
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        if (this.negate) {
            return !this.operand.getBoolean(cx, refNode);
        }
        return this.operand.getBoolean(cx, refNode);
    }

    String toXmlString(int t) {
        StringBuffer sb = new StringBuffer();
        sb.append(ParsedNegation.tab(t) + "<NOT negate='" + this.negate + "'>\n");
        sb.append(this.operand.toXmlString(t + 1));
        sb.append(ParsedNegation.tab(t) + "</NOT>\n");
        return sb.toString();
    }

    String toXqlString() {
        return "$NOT$ (" + this.operand.toXqlString() + ")";
    }
}

