/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xql.ParsedDisjunction;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedFloat;
import com.wm.lang.xql.ParsedFunction;
import com.wm.lang.xql.ParsedInteger;
import com.wm.lang.xql.ParsedMethod;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.ParsedText;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;
import com.wm.util.Values;

abstract class ParsedInvocation
extends ParsedExpression {
    ParsedInvocation() {
    }

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        List paramList;
        String name = ParsedInvocation.getName(tokens);
        ParsedInvocation parse = ParsedFunction.getParsedFunction(name, paramList = ParsedInvocation.getParameterList(tokens, parsedQuery, dotResultType, namespaceHash), dotResultType, namespaceHash);
        if (parse == null) {
            parse = ParsedMethod.getParsedMethod(name, paramList, dotResultType, namespaceHash);
        }
        if (parse == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.NAME_NOT_RECOGNIZED, "", name);
        }
        return parse;
    }

    static String getName(TokenBuffer tokens) throws WattExpressionException {
        ExpressionToken token = tokens.getCurrent();
        if (token == null || token.getType() != 104) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.NAME_EXPECTED, "");
        }
        tokens.advance();
        return token.getString();
    }

    static List getParameterList(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ExpressionToken token = tokens.getCurrent();
        if (token == null || token.getType() != 309) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.INVOKE_PARATHE_MISSING, "");
        }
        List paramList = null;
        token = tokens.next();
        if (token == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.INVOKE_TRUNCATED_INVOKE, "");
        }
        if (token.getType() == 310) {
            tokens.advance();
        } else {
            ParsedExpression param = ParsedInvocation.getParameter(tokens, parsedQuery, dotResultType, namespaceHash);
            paramList = new List();
            paramList.addElement(param);
            token = tokens.getCurrent();
            while (token != null && token.getType() == 103) {
                tokens.advance();
                param = ParsedInvocation.getParameter(tokens, parsedQuery, dotResultType, namespaceHash);
                paramList.addElement(param);
                token = tokens.getCurrent();
            }
            token = tokens.getCurrent();
            if (token == null || token.getType() != 310) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.PARATHE_TERMINATE_LIST, "");
            }
            tokens.advance();
        }
        return paramList;
    }

    static ParsedExpression getParameter(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ParsedExpression param;
        ExpressionToken token = tokens.getCurrent();
        if (token == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.INVOKE_MISSING_PARAMETER, "");
        }
        switch (token.getType()) {
            case 203: {
                param = ParsedText.createXql(tokens, parsedQuery);
                break;
            }
            case 202: {
                param = ParsedInteger.createXql(tokens, parsedQuery);
                break;
            }
            case 201: {
                param = ParsedFloat.createXql(tokens, parsedQuery);
                break;
            }
            default: {
                param = ParsedDisjunction.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
            }
        }
        return param;
    }

    static String reportInvalidParamCount(String name) throws WattExpressionException {
        throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.INVOKE_WRONG_PARA_NUMBER, "", name);
    }
}

