/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.IntegerToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;

class ParsedInteger
extends ParsedExpression {
    ResultSet constantResult = new ResultSet(2);
    Integer integerObject;
    int integerValue;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery) throws WattExpressionException {
        IntegerToken token = (IntegerToken)tokens.getCurrent();
        tokens.advance();
        return new ParsedInteger(token.getInteger());
    }

    ParsedInteger(int integerValue) {
        this.integerObject = new Integer(integerValue);
        this.constantResult.addValue(this.integerObject, 0);
        this.integerValue = integerValue;
    }

    int getInteger() {
        return this.integerValue;
    }

    int getResultType() {
        return 1;
    }

    boolean isRelative() {
        return true;
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException {
        results.addValue(this.integerObject, 0);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException {
        return true;
    }

    ResultSet getResults(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException {
        return this.constantResult;
    }

    String toXmlString(int t) {
        return ParsedInteger.tab(t) + "<integer>" + this.integerObject + "</integer>\n";
    }

    String toXqlString() {
        return this.integerObject.toString();
    }
}

