/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedFunction;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;

class ParsedFunction_region
extends ParsedFunction {
    ParsedExpression start;
    ParsedExpression includeStart;
    ParsedExpression end;
    ParsedExpression includeEnd;

    ParsedFunction_region(List paramList, int dotResultType) throws WattExpressionException {
        if (paramList == null) {
            ParsedFunction_region.reportInvalidParamCount("region");
        }
        if (paramList.size() == 2) {
            this.start = (ParsedExpression)paramList.elementAt(0);
            this.end = (ParsedExpression)paramList.elementAt(1);
        } else if (paramList.size() == 4) {
            this.start = (ParsedExpression)paramList.elementAt(0);
            this.includeStart = (ParsedExpression)paramList.elementAt(1);
            this.end = (ParsedExpression)paramList.elementAt(2);
            this.includeEnd = (ParsedExpression)paramList.elementAt(3);
        } else {
            ParsedFunction_region.reportInvalidParamCount("region");
        }
        if (dotResultType != 5) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.REGION_RELATIVE_TO_NODE, "");
        }
        if (this.start.getResultType() != 5 || this.end.getResultType() != 5) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.REGION_MUST_RETURN_NODE, "");
        }
    }

    int getResultType() {
        return 5;
    }

    boolean isRelative() {
        return this.start.isRelative() && this.end.isRelative();
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        ReferenceNode savedRefNode = cx.getReferenceNode();
        refNode.getMembers(savedRefNode);
        ResultSet startResults = this.start.getResults(cx, refNode);
        refNode.setMembers(savedRefNode);
        ResultSet endResults = this.end.getResults(cx, refNode);
        if (startResults.getSize() != 0 && endResults.getSize() != 0) {
            this.verifyResults(startResults, endResults);
            if (this.includeStart == null || this.includeEnd == null) {
                cx.getModel().addRegionNode(refNode.getNode(), startResults.getValue(0), true, endResults.getValue(0), true, results);
            } else {
                refNode.setMembers(savedRefNode);
                boolean startIncluded = this.includeStart.getBoolean(cx, refNode);
                refNode.setMembers(savedRefNode);
                boolean endIncluded = this.includeEnd.getBoolean(cx, refNode);
                cx.getModel().addRegionNode(refNode.getNode(), startResults.getValue(0), startIncluded, endResults.getValue(0), endIncluded, results);
            }
        }
        cx.putReferenceNode(savedRefNode);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ReferenceNode savedRefNode = cx.getReferenceNode();
        refNode.getMembers(savedRefNode);
        ResultSet startResults = this.start.getResults(cx, refNode);
        refNode.setMembers(savedRefNode);
        ResultSet endResults = this.end.getResults(cx, refNode);
        boolean found = false;
        if (startResults.getSize() != 0 && endResults.getSize() != 0) {
            this.verifyResults(startResults, endResults);
            if (this.includeStart == null || this.includeEnd == null) {
                found = cx.getModel().containsRegion(refNode.getNode(), startResults.getValue(0), true, endResults.getValue(0), true);
            } else {
                refNode.setMembers(savedRefNode);
                boolean startIncluded = this.includeStart.getBoolean(cx, refNode);
                refNode.setMembers(savedRefNode);
                boolean endIncluded = this.includeEnd.getBoolean(cx, refNode);
                found = cx.getModel().containsRegion(refNode.getNode(), startResults.getValue(0), startIncluded, endResults.getValue(0), endIncluded);
            }
        }
        cx.putReferenceNode(savedRefNode);
        return found;
    }

    void verifyResults(ResultSet startResults, ResultSet endResults) throws WattEvaluationException {
        if (startResults.getSize() > 1) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.REGION_NO_MUPTIPLE_START, "");
        }
        if (endResults.getSize() > 1) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.REGION_NO_MUPTIPLE_END, "");
        }
    }

    String toXmlString(int t) {
        StringBuffer sb = new StringBuffer();
        sb.append(ParsedFunction_region.tab(t) + "<REGION>\n");
        sb.append(ParsedFunction_region.tab(t + 1) + "<START>\n");
        sb.append(this.start.toXmlString(t + 2));
        sb.append(ParsedFunction_region.tab(t + 1) + "</START>\n");
        if (this.includeStart != null) {
            sb.append(ParsedFunction_region.tab(t + 1) + "<INCLUDE-START>\n");
            sb.append(this.includeStart.toXmlString(t + 2));
            sb.append(ParsedFunction_region.tab(t + 1) + "</INCLUDE-START>\n");
        }
        sb.append(ParsedFunction_region.tab(t + 1) + "<END>\n");
        sb.append(this.end.toXmlString(t + 2));
        sb.append(ParsedFunction_region.tab(t + 1) + "</END>\n");
        if (this.includeEnd != null) {
            sb.append(ParsedFunction_region.tab(t + 1) + "<INCLUDE-END>\n");
            sb.append(this.includeEnd.toXmlString(t + 2));
            sb.append(ParsedFunction_region.tab(t + 1) + "</INCLUDE-END>\n");
        }
        sb.append(ParsedFunction_region.tab(t) + "</REGION>\n");
        return sb.toString();
    }

    String toXqlString() {
        if (this.includeStart == null) {
            return "region(" + this.start.toXqlString() + ", " + this.end.toXqlString() + ")";
        }
        return "region(" + this.start.toXqlString() + ", " + this.includeStart.toXqlString() + ", " + this.end.toXqlString() + ", " + this.includeEnd.toXqlString() + ")";
    }
}

