/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedFunction;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class ParsedFunction_date
extends ParsedFunction {
    ParsedExpression parameter;

    ParsedFunction_date(List paramList, int dotResultType) throws WattExpressionException {
        if (paramList == null || paramList.size() != 1) {
            ParsedFunction_date.reportInvalidParamCount("date");
        }
        this.parameter = (ParsedExpression)paramList.elementAt(0);
    }

    int getResultType() {
        return 4;
    }

    boolean isRelative() {
        return this.parameter.isRelative();
    }

    private Long dateStringToLong(String sValue) throws NumberFormatException, ParseException {
        SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
        Date dateOut = myFormatter.parse(sValue.trim());
        long l = dateOut.getTime();
        Long lDate = new Long(l);
        return lDate;
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        ResultSet myResults = this.parameter.getResults(cx, refNode);
        int iResultSize = myResults.getSize();
        for (int index = 0; index < iResultSize; ++index) {
            Long lDate;
            String sValue;
            Object value = myResults.getValue(index);
            if (value == null) continue;
            switch (this.parameter.getResultType()) {
                case 3: {
                    sValue = ((String)value).toString();
                    break;
                }
                case 6: {
                    sValue = cx.getModel().getAttributeText(value);
                    break;
                }
                case 5: {
                    sValue = cx.getModel().getNodeText(value);
                    break;
                }
                default: {
                    throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.DATE_INVALID_TYPE, "", Integer.toString(this.parameter.getResultType()));
                }
            }
            try {
                lDate = this.dateStringToLong(sValue);
            }
            catch (NumberFormatException nfe) {
                Object[] sArray = new String[]{sValue, nfe.toString()};
                throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.DATE_INVALID_VALUE, "", sArray);
            }
            catch (ParseException pe) {
                Object[] sArray = new String[]{pe.toString(), Integer.toString(pe.getErrorOffset())};
                throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.DATE_ERROR_OFFSET, "", sArray);
            }
            results.addValue(lDate, refNode.getPosition());
        }
        cx.putResultSet(myResults);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException {
        return true;
    }

    String toXmlString(int t) {
        return ParsedFunction_date.tab(t) + "<DATE>\n" + this.parameter.toXmlString(t + 1) + ParsedFunction_date.tab(t) + "</DATE>\n";
    }

    String toXqlString() {
        return "date(" + this.parameter.toXqlString() + ")";
    }
}

