/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.FloatToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;

class ParsedFloat
extends ParsedExpression {
    ResultSet constantResult = new ResultSet(2);
    Float floatObject;
    float floatValue;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery) throws WattExpressionException {
        FloatToken token = (FloatToken)tokens.getCurrent();
        tokens.advance();
        return new ParsedFloat(token.getFloat());
    }

    ParsedFloat(float floatValue) {
        this.floatObject = new Float(floatValue);
        this.constantResult.addValue(this.floatObject, 0);
        this.floatValue = floatValue;
    }

    float getFloat() {
        return this.floatValue;
    }

    int getResultType() {
        return 2;
    }

    boolean isRelative() {
        return true;
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException {
        results.addValue(this.floatObject, 0);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException {
        return true;
    }

    ResultSet getResults(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException {
        return this.constantResult;
    }

    String toXmlString(int t) {
        return ParsedFloat.tab(t) + "<float>" + this.floatObject + "</float>\n";
    }

    String toXqlString() {
        String floatString = this.floatObject.toString();
        if (floatString.indexOf(46) < 0) {
            floatString = floatString + ".0";
        }
        return floatString;
    }
}

