/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedDisjunction;
import com.wm.lang.xql.ParsedDot;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedFunction_attribute;
import com.wm.lang.xql.ParsedFunction_element;
import com.wm.lang.xql.ParsedInvocation;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.List;
import com.wm.util.Values;

class ParsedFilter
extends ParsedExpression {
    ParsedExpression leftOperand;
    ParsedExpression[] subqueries;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        boolean endOfFilter;
        ParsedExpression parse = ParsedFilter.getTerm(tokens, parsedQuery, dotResultType, namespaceHash);
        ExpressionToken token = tokens.getCurrent();
        List subqueryList = new List();
        boolean bl = endOfFilter = token == null;
        while (!endOfFilter) {
            if (token.getType() != 311) {
                endOfFilter = true;
                continue;
            }
            token = tokens.next();
            if (token == null) {
                endOfFilter = true;
                continue;
            }
            if (token.getType() == 202 || token.getType() == 312) {
                tokens.retreat();
                endOfFilter = true;
                continue;
            }
            ParsedExpression tmpParse = ParsedDisjunction.createXql(tokens, parsedQuery, parse.getResultType(), namespaceHash);
            if (!tmpParse.isRelative()) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.ALLOW_ONLY_RELATIVE_QUERY, "");
            }
            subqueryList.addElement(tmpParse);
            token = tokens.getCurrent();
            if (token == null || token.getType() != 312) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.BRACET_NOT_MATCH, "");
            }
            token = tokens.next();
            if (token != null) continue;
            endOfFilter = true;
        }
        if (subqueryList.size() != 0) {
            if (parse.getResultType() != 5 && parse.getResultType() != 6) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.SELECT_NODE_OR_ATTRIBUTE, "");
            }
            parse = new ParsedFilter(parse, subqueryList);
        }
        return parse;
    }

    static ParsedExpression getTerm(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ParsedExpression parse;
        ExpressionToken token = tokens.getCurrent();
        if (token == null) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TERM_MISSING_OR_INVALID, "");
        }
        switch (token.getType()) {
            case 104: {
                token = tokens.next();
                tokens.retreat();
                if (token != null && token.getType() == 309) {
                    parse = ParsedInvocation.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
                    break;
                }
                parse = new ParsedFunction_element(tokens, dotResultType, namespaceHash);
                break;
            }
            case 105: {
                parse = new ParsedFunction_element(tokens, dotResultType, namespaceHash);
                break;
            }
            case 102: {
                tokens.advance();
                parse = new ParsedFunction_attribute(tokens, dotResultType, namespaceHash);
                break;
            }
            case 309: {
                tokens.advance();
                parse = ParsedDisjunction.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
                token = tokens.getCurrent();
                if (token != null) {
                    if (token.getType() != 310) {
                        throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.PARATHE_NOT_MATCH_TOKEN, "", token.toString());
                    }
                } else {
                    throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.PARATHE_NOT_MATCH_TOKEN_END, "");
                }
                tokens.advance();
                break;
            }
            case 200: {
                parse = new ParsedDot(dotResultType);
                tokens.advance();
                break;
            }
            default: {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.TERM_MISSPLACE_OR_INVALID, "", token.toString());
            }
        }
        return parse;
    }

    ParsedFilter(ParsedExpression leftOperand, List subqueryList) {
        this.leftOperand = leftOperand;
        this.subqueries = new ParsedExpression[subqueryList.size()];
        int length = this.subqueries.length;
        for (int i = 0; i < length; ++i) {
            this.subqueries[i] = (ParsedExpression)subqueryList.elementAt(i);
        }
    }

    int getResultType() {
        return this.leftOperand.getResultType();
    }

    boolean isRelative() {
        return this.leftOperand.isRelative();
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        ResultSet leftSet = this.leftOperand.getResults(cx, refNode);
        int leftSetSize = leftSet.getSize();
        int length = this.subqueries.length;
        for (int nodeIndex = 0; nodeIndex < leftSetSize; ++nodeIndex) {
            boolean matches;
            int subqueryIndex = 0;
            do {
                refNode.assign(leftSet, nodeIndex);
            } while ((matches = this.subqueries[subqueryIndex].getBoolean(cx, refNode)) && ++subqueryIndex < length);
            if (!matches) continue;
            results.addValue(leftSet, nodeIndex);
        }
        cx.putResultSet(leftSet);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ResultSet leftSet = this.getResults(cx, refNode);
        int leftSetSize = leftSet.getSize();
        int length = this.subqueries.length;
        for (int nodeIndex = 0; nodeIndex < leftSetSize; ++nodeIndex) {
            boolean matches;
            int subqueryIndex = 0;
            do {
                refNode.assign(leftSet, nodeIndex);
            } while ((matches = this.subqueries[subqueryIndex].getBoolean(cx, refNode)) && ++subqueryIndex < length);
            if (!matches) continue;
            cx.putResultSet(leftSet);
            return true;
        }
        cx.putResultSet(leftSet);
        return false;
    }

    String toXmlString(int t) {
        StringBuffer sb = new StringBuffer();
        sb.append(ParsedFilter.tab(t) + "<FILTER>\n");
        sb.append(this.leftOperand.toXmlString(t + 1));
        int length = this.subqueries.length;
        for (int i = 0; i < length; ++i) {
            sb.append(ParsedFilter.tab(t + 1) + "<SUBQUERY>\n");
            sb.append(this.subqueries[i].toXmlString(t + 2));
            sb.append(ParsedFilter.tab(t + 1) + "</SUBQUERY>\n");
        }
        sb.append(ParsedFilter.tab(t) + "</FILTER>\n");
        return sb.toString();
    }

    String toXqlString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.leftOperand.toXqlString());
        int length = this.subqueries.length;
        for (int i = 0; i < length; ++i) {
            sb.append("[" + this.subqueries[i].toXqlString() + "]");
        }
        return sb.toString();
    }
}

