/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedConjunction;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.XqlTokenBuffer;
import com.wm.util.List;
import com.wm.util.Values;

class ParsedDisjunction
extends ParsedExpression {
    ParsedExpression[] operands;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ParsedExpression parse = ParsedConjunction.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
        ExpressionToken token = tokens.getCurrent();
        if (ParsedDisjunction.checkForOrToken(token)) {
            List parseList = new List();
            parseList.addElement(parse);
            do {
                tokens.advance();
                parse = ParsedConjunction.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
                parseList.addElement(parse);
            } while (ParsedDisjunction.checkForOrToken(token = tokens.getCurrent()));
            parse = new ParsedDisjunction(parseList);
        }
        return parse;
    }

    private static boolean checkForOrToken(ExpressionToken token) throws WattExpressionException {
        return token != null && (token.getType() == 301 || token.getType() == 104 && XqlTokenBuffer.stringToOperatorToken(token.getString()) == 301);
    }

    ParsedDisjunction(List parseList) {
        this.operands = new ParsedExpression[parseList.size()];
        int length = this.operands.length;
        for (int i = 0; i < length; ++i) {
            this.operands[i] = (ParsedExpression)parseList.elementAt(i);
        }
    }

    int getResultType() {
        return 0;
    }

    boolean isRelative() {
        int opIndex = this.operands.length;
        while (opIndex-- != 0) {
            if (this.operands[opIndex].isRelative()) continue;
            return false;
        }
        return true;
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        results.addValue(new Boolean(this.getBoolean(cx, refNode)), refNode.getPosition());
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        int opIndex = this.operands.length;
        ReferenceNode saveRefNode = cx.getReferenceNode();
        refNode.getMembers(saveRefNode);
        while (opIndex-- != 0) {
            if (this.operands[opIndex].getBoolean(cx, refNode)) {
                cx.putReferenceNode(saveRefNode);
                return true;
            }
            refNode.setMembers(saveRefNode);
        }
        cx.putReferenceNode(saveRefNode);
        return false;
    }

    String toXmlString(int t) {
        StringBuffer sb = new StringBuffer();
        sb.append(ParsedDisjunction.tab(t) + "<OR>\n");
        int length = this.operands.length;
        for (int i = 0; i < length; ++i) {
            sb.append(this.operands[i].toXmlString(t + 1));
        }
        sb.append(ParsedDisjunction.tab(t) + "</OR>\n");
        return sb.toString();
    }

    String toXqlString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.operands[0].toXqlString());
        int length = this.operands.length;
        for (int i = 0; i < length; ++i) {
            sb.append(" $OR$ " + this.operands[i].toXqlString());
        }
        sb.append(')');
        return sb.toString();
    }
}

