/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedNegation;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.XqlTokenBuffer;
import com.wm.util.List;
import com.wm.util.Values;

class ParsedConjunction
extends ParsedExpression {
    ParsedExpression[] operands;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        ParsedExpression parse = ParsedNegation.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
        ExpressionToken token = tokens.getCurrent();
        if (ParsedConjunction.checkForAndToken(token)) {
            List parseList = new List();
            parseList.addElement(parse);
            do {
                tokens.advance();
                parse = ParsedNegation.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
                parseList.addElement(parse);
            } while (ParsedConjunction.checkForAndToken(token = tokens.getCurrent()));
            parse = new ParsedConjunction(parseList);
        }
        return parse;
    }

    static boolean checkForAndToken(ExpressionToken token) throws WattExpressionException {
        return token != null && (token.getType() == 302 || token.getType() == 104 && XqlTokenBuffer.stringToOperatorToken(token.getString()) == 302);
    }

    ParsedConjunction(List parseList) {
        this.operands = new ParsedExpression[parseList.size()];
        int length = this.operands.length;
        for (int i = 0; i < length; ++i) {
            this.operands[i] = (ParsedExpression)parseList.elementAt(i);
        }
    }

    int getResultType() {
        return 0;
    }

    boolean isRelative() {
        int opIndex = this.operands.length;
        while (opIndex-- != 0) {
            if (this.operands[opIndex].isRelative()) continue;
            return false;
        }
        return true;
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        results.addValue(new Boolean(this.getBoolean(cx, refNode)), refNode.getPosition());
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        int opIndex = this.operands.length;
        ReferenceNode saveRefNode = cx.getReferenceNode();
        refNode.getMembers(saveRefNode);
        while (opIndex-- != 0) {
            if (!this.operands[opIndex].getBoolean(cx, refNode)) {
                cx.putReferenceNode(saveRefNode);
                return false;
            }
            refNode.setMembers(saveRefNode);
        }
        cx.putReferenceNode(saveRefNode);
        return true;
    }

    String toXmlString(int t) {
        StringBuffer sb = new StringBuffer();
        sb.append(ParsedConjunction.tab(t) + "<AND>\n");
        int length = this.operands.length;
        for (int i = 0; i < length; ++i) {
            sb.append(this.operands[i].toXmlString(t + 1));
        }
        sb.append(ParsedConjunction.tab(t) + "</AND>\n");
        return sb.toString();
    }

    String toXqlString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.operands[0].toXqlString());
        int length = this.operands.length;
        for (int i = 0; i < length; ++i) {
            sb.append(" $AND$ " + this.operands[i].toXqlString());
        }
        sb.append(')');
        return sb.toString();
    }
}

