/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.ParsedAbsoluteDescendantPath;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedFloat;
import com.wm.lang.xql.ParsedInteger;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.ParsedText;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.Relation;
import com.wm.lang.xql.RelationSpec;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.TypedValue;
import com.wm.lang.xql.XqlTokenBuffer;
import com.wm.lang.xql.resources.XqlExceptionBundle;
import com.wm.util.Values;

class ParsedComparison
extends ParsedExpression {
    static final String MSG_MISSING_RVALUE = "Comparison requires an rvalue";
    static final String MSG_TOO_MANY_RVALUES = "Comparison righthand operand evaluates to more than one value";
    ParsedQuery parsedQuery;
    boolean matchAll;
    ParsedExpression leftOperand;
    int relationIndex;
    ParsedExpression rightOperand;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType, Values namespaceHash) throws WattExpressionException {
        boolean multiplicityFound = false;
        boolean matchAll = false;
        ExpressionToken token = tokens.getCurrent();
        if (token != null) {
            if (token.getType() == 101) {
                multiplicityFound = true;
                tokens.advance();
            } else if (token.getType() == 100) {
                multiplicityFound = true;
                tokens.advance();
                matchAll = true;
            }
        }
        ParsedExpression parse = ParsedAbsoluteDescendantPath.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
        token = tokens.getCurrent();
        int comparisonType = -1;
        if (token != null && token.getType() == 104) {
            comparisonType = XqlTokenBuffer.stringToOperatorToken(token.getString());
            comparisonType = comparisonType >= 400 && comparisonType <= 411 ? (comparisonType -= 400) : -1;
        } else if (token != null && token.getType() >= 400 && token.getType() <= 411) {
            comparisonType = token.getType() - 400;
        }
        if (comparisonType != -1) {
            ParsedExpression rightOperand;
            token = tokens.next();
            if (token == null) {
                throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_MISSING_RVALUE, "");
            }
            switch (token.getType()) {
                case 203: {
                    rightOperand = ParsedText.createXql(tokens, parsedQuery);
                    break;
                }
                case 202: {
                    rightOperand = ParsedInteger.createXql(tokens, parsedQuery);
                    break;
                }
                case 201: {
                    rightOperand = ParsedFloat.createXql(tokens, parsedQuery);
                    break;
                }
                default: {
                    rightOperand = ParsedAbsoluteDescendantPath.createXql(tokens, parsedQuery, dotResultType, namespaceHash);
                }
            }
            RelationSpec relationSpec = new RelationSpec(parse.getResultType(), comparisonType, rightOperand.getResultType());
            int relationIndex = parsedQuery.addRelationSpec(relationSpec);
            parse = new ParsedComparison(parsedQuery, matchAll, parse, relationIndex, rightOperand);
        } else if (multiplicityFound) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.MISSING_COMPARE_OPERATOR, "");
        }
        return parse;
    }

    ParsedComparison(ParsedQuery parsedQuery, boolean matchAll, ParsedExpression leftOperand, int relationIndex, ParsedExpression rightOperand) {
        this.parsedQuery = parsedQuery;
        this.matchAll = matchAll;
        this.leftOperand = leftOperand;
        this.relationIndex = relationIndex;
        this.rightOperand = rightOperand;
    }

    int getResultType() {
        return this.leftOperand.getResultType();
    }

    boolean isRelative() {
        return this.leftOperand.isRelative();
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException, WMDocumentException {
        ResultSet rightResults = this.rightOperand.getResults(cx, refNode);
        if (rightResults.getSize() > 1) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TOO_MANY_RVALUES, "");
        }
        if (rightResults.getSize() == 1) {
            int valIndex;
            ResultSet leftResults = this.leftOperand.getResults(cx, refNode);
            int numValues = leftResults.getSize();
            Relation relation = cx.getRelation(this.relationIndex);
            relation.setRValue(rightResults);
            if (this.matchAll) {
                boolean allMatch = true;
                while (allMatch && valIndex < numValues) {
                    relation.setLValue(leftResults.getValue(valIndex++));
                    if (relation.holds()) continue;
                    allMatch = false;
                }
                if (allMatch) {
                    valIndex = 0;
                    while (valIndex < numValues) {
                        results.addValue(leftResults, valIndex++);
                    }
                }
            } else {
                for (valIndex = 0; valIndex < numValues; ++valIndex) {
                    Object lvalue = leftResults.getValue(valIndex);
                    relation.setLValue(lvalue);
                    if (!relation.holds()) continue;
                    results.addValue(lvalue, leftResults.getPosition(valIndex));
                }
            }
            cx.putResultSet(leftResults);
        }
        cx.putResultSet(rightResults);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException, WMDocumentException {
        ResultSet rightResults = this.rightOperand.getResults(cx, refNode);
        if (rightResults.getSize() > 1) {
            throw new WattEvaluationException(XqlExceptionBundle.class, XqlExceptionBundle.MSG_TOO_MANY_RVALUES, "");
        }
        if (rightResults.getSize() == 1) {
            ResultSet leftResults = this.leftOperand.getResults(cx, refNode);
            int valIndex = leftResults.getSize();
            Relation relation = cx.getRelation(this.relationIndex);
            relation.setRValue(rightResults);
            if (this.matchAll) {
                while (valIndex-- != 0) {
                    relation.setLValue(leftResults.getValue(valIndex));
                    if (relation.holds()) continue;
                    cx.putResultSet(leftResults);
                    cx.putResultSet(rightResults);
                    return false;
                }
                cx.putResultSet(leftResults);
                cx.putResultSet(rightResults);
                return true;
            }
            while (valIndex-- != 0) {
                relation.setLValue(leftResults.getValue(valIndex));
                if (!relation.holds()) continue;
                cx.putResultSet(leftResults);
                cx.putResultSet(rightResults);
                return true;
            }
            cx.putResultSet(leftResults);
            cx.putResultSet(rightResults);
            return false;
        }
        cx.putResultSet(rightResults);
        return false;
    }

    String toXmlString(int t) {
        return this.toXmlOrXql(true, t);
    }

    String toXqlString() {
        return this.toXmlOrXql(false, 0);
    }

    String toXmlOrXql(boolean toXml, int t) {
        String multiplicity = this.matchAll ? "all" : "any";
        RelationSpec[] relationSpecs = this.parsedQuery.getRelationSpecs();
        RelationSpec relationSpec = relationSpecs[this.relationIndex];
        String relationType = Relation.getTypeString(relationSpec.sourceRelation.getRelationType());
        String typecastType = TypedValue.getTypeString(relationSpec.sourceRelation.getComparedType());
        if (toXml) {
            StringBuffer sb = new StringBuffer();
            sb.append(ParsedComparison.tab(t) + "<" + relationType + " typecast='" + typecastType + "'" + " multiplicity='" + multiplicity + ">\n");
            sb.append(ParsedComparison.tab(t + 1) + "<lvalue>\n");
            sb.append(this.leftOperand.toXmlString(t + 2));
            sb.append(ParsedComparison.tab(t + 1) + "</lvalue>\n");
            sb.append(ParsedComparison.tab(t + 1) + "<rvalue>\n");
            sb.append(this.rightOperand.toXmlString(t + 2));
            sb.append(ParsedComparison.tab(t + 1) + "</rvalue>\n");
            sb.append(ParsedComparison.tab(t) + "</" + relationType + ">\n");
            return sb.toString();
        }
        relationType = relationType.equalsIgnoreCase("EQ") ? "=" : (relationType.equalsIgnoreCase("NE") ? "!=" : " $" + relationType + "$ ");
        String comparison = this.leftOperand.toXqlString() + relationType + this.rightOperand.toXqlString();
        if (multiplicity.equals("all")) {
            return "$all$ " + comparison;
        }
        return comparison;
    }
}

