/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.xql;

import com.wm.lang.flow.ExpressionToken;
import com.wm.lang.flow.StringToken;
import com.wm.lang.flow.TokenBuffer;
import com.wm.lang.flow.WattEvaluationException;
import com.wm.lang.flow.WattExpressionException;
import com.wm.lang.xql.ParsedExpression;
import com.wm.lang.xql.ParsedQuery;
import com.wm.lang.xql.QueryContext;
import com.wm.lang.xql.ReferenceNode;
import com.wm.lang.xql.ResultSet;
import com.wm.lang.xql.resources.XqlExceptionBundle;

class ParsedBoolean
extends ParsedExpression {
    ResultSet constantResult = new ResultSet(2);
    Boolean booleanObject;
    boolean booleanValue;

    static ParsedExpression createXql(TokenBuffer tokens, ParsedQuery parsedQuery, int dotResultType) throws WattExpressionException {
        ParsedBoolean parse = null;
        ExpressionToken token = tokens.getCurrent();
        if (token == null || token.getType() != 104) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.BOOLEAN_EXPECTED, "");
        }
        String name = ((StringToken)token).getString();
        token = tokens.next();
        if (token == null || token.getType() != 309) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.LEFT_PARATHE_EXPECTED, "");
        }
        token = tokens.next();
        if (token == null || token.getType() != 310) {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.RIGHT_PARATHE_EXPECTED, "");
        }
        tokens.advance();
        if (name.equalsIgnoreCase("TRUE")) {
            parse = new ParsedBoolean(true);
        } else if (name.equalsIgnoreCase("FALSE")) {
            parse = new ParsedBoolean(false);
        } else {
            throw new WattExpressionException(XqlExceptionBundle.class, XqlExceptionBundle.INVALID_BOOLEAN_METHOD, "", name);
        }
        return parse;
    }

    ParsedBoolean(boolean value) {
        this.booleanValue = value;
        this.booleanObject = new Boolean(value);
        this.constantResult.addValue(this.booleanObject, 0);
    }

    int getResultType() {
        return 0;
    }

    boolean isRelative() {
        return true;
    }

    void addToResults(QueryContext cx, ReferenceNode refNode, ResultSet results) throws WattEvaluationException {
        results.addValue(this.booleanObject, 0);
    }

    boolean getBoolean(QueryContext cx, ReferenceNode refNode) throws WattEvaluationException {
        return this.booleanValue;
    }

    ResultSet getResults(QueryContext cx, ReferenceNode refNode) {
        return this.constantResult;
    }

    String toXmlString(int t) {
        if (this.booleanValue) {
            return ParsedBoolean.tab(t) + "<true/>\n";
        }
        return ParsedBoolean.tab(t) + "<false/>\n";
    }

    String toXqlString() {
        if (this.booleanValue) {
            return "true()";
        }
        return "false()";
    }
}

